package com.ejianc.foundation.calibration.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 招标(定标)信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_calibration")
public class CalibrationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="ys_no")
    private String ysNo; // 系统编号
    @TableField(value="tender_code")
    private String tenderCode; // 招标编码
    @TableField(value="name")
    private String name; // 招标名称
    @TableField(value="organization_sys_no")
    private String organizationSysNo; // 组织机构系统编号
    @TableField(value="organization_code")
    private String organizationCode; // 组织机构代码
    @TableField(value="organization_name")
    private String organizationName; // 组织机构名称
    @TableField(value="contract_type")
    private String contractType; // 合同类型：0=Purchase=采购合同,1=Agreement=协议合同
    @TableField(value="system_category_type")
    private String systemCategoryType; // 品类类型：0=Material=物资,1=Equipment=设备,2=LaborSubcontract =劳务分包,3=SpecialtySubcontract=专业分包,4=SpecialtyService =专业服务5=Lease =租赁
    @TableField(value="amount")
    private BigDecimal amount; // 概算金额
    @TableField(value="calibration_result_notice_date")
    private Date calibrationResultNoticeDate; // 定标结果发布时间
    @TableField(value="tender_type")
    private String tenderType; // 招标方式：0=Public=公开招标,1=Invitation=邀请招标,2=Inquiry=询价采购,3=Protocol=议标采购——竞争性谈判,4=Sporadic=零星采购——单一来源采购,5=Emergent=紧急采购,6=Compare=询比采购,7=BiddingPrice=竞价采购,8=Negotiations=谈判采购,9=Direct=直接采购
    @TableField(value="status")
    private String status; // 状态：0=确认招标概要,10=确认招标清单,20=确认招标供应商,30=确认公告内容,40=发布公告预览,42=待发布公告,45=供应商报名,47=供应商报名截止,50=确认报名信息,60=通知报名结果,65=确认发标清单,85=开标人设置,90=确认招标文件内容,100=发布招标文件预览,105=待发布招标文件,110=回标中,115=回标截止,116=评标设置,117=评标概要汇总,118=评标人设置,119=供应商数据导入,120=开标设置,130=开标中,140=开标结果,145=已设置评标人,150=评标,155=调价中,157=调价结束160=确认定标报告,170=发布定标结果,180=结束

    @TableField(value="yzw_file_no")
    private String yzwFileNo; // 云筑网文件编码

    @TableField(value="all_project")
    private String allProject; // 所有项目名称

    @TableField(exist=false)
    @SubEntity(serviceName="calibrationProjectService", pidName="calibrationId")//此处有pid="xxx"，默认值pid="pid"
    private List<CalibrationProjectEntity> calibrationProjectList = new ArrayList<>(); // 招标(定标)信息-项目
    @TableField(exist=false)
    @SubEntity(serviceName="calibrationSupplierService", pidName="calibrationId")//此处有pid="xxx"，默认值pid="pid"
    private List<CalibrationSupplierEntity> calibrationSupplierList = new ArrayList<>(); // 招标(定标)信息-供应商

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getYsNo() {
        return ysNo;
    }

    public void setYsNo(String ysNo) {
        this.ysNo = ysNo;
    }
    public String getTenderCode() {
        return tenderCode;
    }

    public void setTenderCode(String tenderCode) {
        this.tenderCode = tenderCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getOrganizationSysNo() {
        return organizationSysNo;
    }

    public void setOrganizationSysNo(String organizationSysNo) {
        this.organizationSysNo = organizationSysNo;
    }
    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public String getSystemCategoryType() {
        return systemCategoryType;
    }

    public void setSystemCategoryType(String systemCategoryType) {
        this.systemCategoryType = systemCategoryType;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public Date getCalibrationResultNoticeDate() {
        return calibrationResultNoticeDate;
    }

    public void setCalibrationResultNoticeDate(Date calibrationResultNoticeDate) {
        this.calibrationResultNoticeDate = calibrationResultNoticeDate;
    }
    public String getTenderType() {
        return tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    
    public List<CalibrationProjectEntity> getCalibrationProjectList() {
        return calibrationProjectList;
    }

    public void setCalibrationProjectList(List<CalibrationProjectEntity> calibrationProjectList) {
        this.calibrationProjectList = calibrationProjectList;
    }
    public List<CalibrationSupplierEntity> getCalibrationSupplierList() {
        return calibrationSupplierList;
    }

    public void setCalibrationSupplierList(List<CalibrationSupplierEntity> calibrationSupplierList) {
        this.calibrationSupplierList = calibrationSupplierList;
    }

    public String getAllProject() {
        return allProject;
    }

    public void setAllProject(String allProject) {
        this.allProject = allProject;
    }

    public String getYzwFileNo() {
        return yzwFileNo;
    }

    public void setYzwFileNo(String yzwFileNo) {
        this.yzwFileNo = yzwFileNo;
    }
}
