package com.ejianc.foundation.outcontract.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.outcontract.mapper.OutcontractMaterialMapper;
import com.ejianc.foundation.outcontract.bean.OutcontractMaterialEntity;
import com.ejianc.foundation.outcontract.service.IOutcontractMaterialService;

import java.util.*;

/**
 * 物资（周转材）合同价
 * 
 * @author generator
 * 
 */
@Service("outcontractMaterialService")
public class OutcontractMaterialServiceImpl extends BaseServiceImpl<OutcontractMaterialMapper, OutcontractMaterialEntity> implements IOutcontractMaterialService{

    @Autowired
    private OutcontractMaterialMapper outcontractMaterialMapper;

    @Override
    public IPage<OutcontractMaterialVO> queryRefMaterialCostmanageList(Map<String, Object> params){
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = outcontractMaterialMapper.countRefMaterialCostmanage(params);
        Integer pageIndex = params.get("pageIndex")!=null?Integer.parseInt(params.get("pageIndex").toString()):1;
        Integer pageSize = params.get("pageSize")!=null?Integer.parseInt(params.get("pageSize").toString()):10;
        IPage<OutcontractMaterialVO> pageData = new Page<>(pageIndex, pageSize, count);
        if(count>0){
            long startLine = (pageIndex < 1 ? 0 : pageIndex -  1) * pageSize;
            params.put("startLine", startLine);
            List<OutcontractMaterialVO> list = outcontractMaterialMapper.queryRefMaterialCostmanage(params);
            pageData.setRecords(list);
        }
        return pageData;
    }
}
