package com.ejianc.foundation.sealApproval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class ZjkjTianJianSyncServiceImpl implements IZjkjTianJianSyncService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${tianjianUrl:http://36.137.93.200:10006/open_api}")
	private String tianjianUrl;
	@Autowired
	private ISealApprovalService sealApprovalService;
	@Autowired
	private IOutcontractService outcontractService;
	@Autowired
	private IChangeOutcontractService outcontractChangeService;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IUserApi userApi;
	@Autowired
	private CacheManager cacheManager;

	@Override
	public void syncSeal(Long sealId) {
		SealApprovalEntity sealEntity = sealApprovalService.selectById(sealId);
		if(!(StringUtils.isNotBlank(sealEntity.getContractSeal()) && "contractSeal".equals(sealEntity.getContractSeal()))){
			//是合同章
			return;
		}
		//获取申请部门的所属组织，并判断是否是集团的
		Long applyDept = sealEntity.getApplyDept();
		CommonResponse<DeptVO> deptResponse = orgApi.findDeptById(applyDept);
		if(deptResponse.isSuccess() && deptResponse.getData()!=null){
			DeptVO dept = deptResponse.getData();
			CommonResponse<OrgVO> orgResponse = orgApi.detailById(dept.getOrgId());
			if(orgResponse.isSuccess() && orgResponse.getData()!=null){
				OrgVO org = orgResponse.getData();
				if(org.getOrgType()==1&&!org.getInnerCode().contains("|")){
					List<OrgVO> l = new ArrayList<>();
					l.add(org);
//					this.syncOrgList(l);
				}else{
					return;
				}
			}
		}
		List<UserVO> userList = new ArrayList<>();
		Long sendId = null;
		Long sealUserId = null;
		//获取创建人
		CommonResponse<UserVO> createResponse = userApi.queryUserByUserCode(sealEntity.getCreateUserCode());
		if(createResponse.isSuccess() && createResponse.getData()!=null){
			userList.add(createResponse.getData());
			sendId = createResponse.getData().getId();
		}
		if(!sendId.equals(sealEntity.getEmployeeId())){
			//获取经办人
			CommonResponse<UserVO> employeeResponse = userApi.findUserByUserId(sealEntity.getEmployeeId());
			if(employeeResponse.isSuccess() && employeeResponse.getData()!=null){
				userList.add(employeeResponse.getData());
				sealUserId = employeeResponse.getData().getId();
			}
		}else{
			sealUserId = sendId;
		}
		this.syncUserList(userList);

		this.syncSeal(sendId, sealUserId, sealEntity);
	}

	@Override
	public void syncOrgList(List<OrgVO> orgList) {
		List<JSONObject> deptList = new ArrayList<>();
		for (OrgVO orgVO : orgList) {
			JSONObject d = new JSONObject();
			if("1247777316689256450".equals(orgVO.getId().toString())){
				continue;
			}
			d.put("id", orgVO.getId().toString());
			d.put("name", orgVO.getName());
			d.put("parentId", orgVO.getParentId()!=null?(orgVO.getParentId().toString().equals("1247777316689256450")?"1": orgVO.getParentId().toString()):"0");
			d.put("orgType", 2);
			deptList.add(d);
		}
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/depart/sync";
			JSONObject params = new JSONObject();
			params.put("deptList", deptList);
			logger.info("组织同步数据参数：-------------{}",params.toJSONString());
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("组织同步数据返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("组织同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("组织同步数据失败");
		}
	}

	@Override
	public void syncUserList(List<UserVO> users) {
		List<JSONObject> userList = new ArrayList<>();
		for (UserVO user : users) {
			JSONObject d = new JSONObject();
			d.put("id", user.getId().toString());
			d.put("username", user.getUserCode());
			d.put("realname", user.getUserName());
			d.put("phone", user.getUserMobile());
			List<JSONObject> deptList = new ArrayList<>();
			JSONObject org = new JSONObject();
//			String orgId = user.getOrgId().toString();
//			if("1247777316689256450".equals(user.getOrgId().toString())){
//				orgId = "1";
//			}
//			org.put("id", orgId);
			org.put("id", "1");
			deptList.add(org);
			d.put("deptList", deptList);
			JSONObject defaultOrg = new JSONObject();
			defaultOrg.put("id", "1");
			d.put("defaultDept", defaultOrg);
			d.put("email", user.getUserEmail());
			userList.add(d);
		}
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/user/sync";
			JSONObject params = new JSONObject();
			params.put("userList", userList);
			logger.info("人员同步数据参数：-------------{}",params.toJSONString());
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			JSONObject jsonResponse = JSON.parseObject(backData);
			logger.info("人员同步数据返回数据：-------------{}",backData);
			if("0".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("人员同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("人员同步数据失败");
		}
	}

	public List<String> getContractManageUser() {
		List<String> userList = new ArrayList<>();
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/seal/page";
			JSONObject params = new JSONObject();
			params.put("pageSize", 100);
			params.put("begin", 0);
			logger.info("获取印章信息列表参数：-------------{}", params.toJSONString());
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			JSONObject jsonResponse = JSON.parseObject(backData);
			logger.info("获取印章信息列表返回数据：-------------{}",backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONArray data = jsonResponse.getJSONArray("data");
				for (Object datum : data) {
					JSONObject da = (JSONObject) datum;
					JSONArray sealAdminList = jsonResponse.getJSONArray("sealAdminList");
					if(sealAdminList!=null && sealAdminList.size()>0){
						for (Object o : sealAdminList) {
							JSONObject seal = (JSONObject) o;
							userList.add(seal.getString("adminId"));
						}
					}
				}
			}else{
				throw new BusinessException("获取印章信息列表失败");
			}
		}catch (Exception e){
			throw new BusinessException("获取印章信息列表失败");
		}
		return userList;
	}

	@Override
	public void syncSeal(Long sendId, Long sealUserId, SealApprovalEntity sealEntity){
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/use_seal/authorize";
			JSONObject params = new JSONObject();
			params.put("applyUserId", sendId.toString());
			List<String> useSealUserIdList = this.getContractManageUser();
			if(useSealUserIdList==null){
				useSealUserIdList = new ArrayList<>();
			}
			useSealUserIdList.add(sealUserId.toString());
			params.put("useSealUserIdList", useSealUserIdList);
			List<JSONObject> sealDetailList = new ArrayList<>();
			JSONObject sealDetail = new JSONObject();
			sealDetail.put("applyCount", sealEntity.getSealCount()+30);
			sealDetail.put("applyCrossPageSealCount", sealEntity.getPageSeal()+30);
			sealDetail.put("sealId", "7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
			sealDetailList.add(sealDetail);
			params.put("sealDetailList", sealDetailList);
			params.put("title ", "合同：【"+sealEntity.getContractName()+"】，申请用章");
			params.put("billNo", sealEntity.getBillCode());
			params.put("remark", sealEntity.getSealReasons());
			JSONObject policy = new JSONObject();
			List<Integer> num = new ArrayList<>();
			num.add(1);
			num.add(2);
			policy.put("videoRecordSealModel", num);
			policy.put("videoRecordCrossModel", num);
			policy.put("videoRecordWrongModel", num);
			params.put("policy", policy);
			logger.info("用印同步数据参数：-------------{}",params.toJSONString());

			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("用印同步返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				String applyId = data.getString("applyId");
				JSONArray safeCodeList = data.getJSONArray("safeCodeList");
				JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
				String safeCode = safeCodeJSON.getString("safeCode");
				sealEntity.setTjPrintId(applyId);
				sealEntity.setTjPrintCode(safeCode);
				sealApprovalService.saveOrUpdate(sealEntity, false);
			}else{
				throw new BusinessException("用印同步失败");
			}
		}catch (Exception e){
			logger.info("用印同步失败:{}",e);
			throw new BusinessException("用印同步失败");
		}
	}

	@Override
	public String getToken() {
		String token = "";
		String key = "tj-token";
		if(cacheManager.get(key)!=null){
			token = cacheManager.get(key);
		}else {
			try {
				String url = tianjianUrl + "/token/get";
				JSONObject params = new JSONObject();
				params.put("restname", "root");
				params.put("password", "Zj@kj#qunje");
				String backData = HttpTookit.postByJson(url, params.toJSONString());
				logger.info("获取token返回数据：-------------{}", backData);
				JSONObject jsonResponse = JSON.parseObject(backData);
				if ("0".equals(jsonResponse.getString("code"))) {
					JSONObject data = jsonResponse.getJSONObject("data");
					token = data.getString("token");
					cacheManager.setex(key, token, 3600);
				} else {
					throw new BusinessException("获取token失败");
				}
			} catch (Exception e) {
				throw new BusinessException("获取token失败");
			}
		}
		return token;
	}

	@Override
	public void syncContractSeal(Long billId) {
		OutcontractEntity outcontractEntity = outcontractService.selectById(billId);

		List<OrgVO> orgList = new ArrayList<>();
		List<Long> orgIds = new ArrayList<>();
		List<UserVO> userList = new ArrayList<>();
		Long sendId = null;
		if(outcontractEntity.getAgent()!=null){
			//获取创建人
			CommonResponse<UserVO> createResponse = userApi.findUserByUserId(outcontractEntity.getAgent());
			if(createResponse.isSuccess() && createResponse.getData()!=null){
				userList.add(createResponse.getData());
				sendId = createResponse.getData().getId();
				orgIds.add(createResponse.getData().getOrgId());
			}
		}else{
			throw new BusinessException("缺少经办人信息，推送印章系统失败");
		}

		if(outcontractEntity.getSignUnit()!=null && !orgIds.contains(outcontractEntity.getSignUnit())){
			orgIds.add(outcontractEntity.getSignUnit());
		}
		//获取的所属组织，并判断是否是集团的
		CommonResponse<List<OrgVO>> orgResponse = orgApi.findAllByIds(orgIds);
		if(orgResponse.isSuccess() && orgResponse.getData()!=null){
			List<OrgVO> orgl = orgResponse.getData();
			for (OrgVO org : orgl) {
				orgList.add(org);
				if(org.getId() == outcontractEntity.getSignUnit()){
					if(org.getOrgType()==1&&!org.getInnerCode().contains("|")){
					}else{
						return;
					}
				}
			}
		}

//		this.syncOrgList(orgList);

		this.syncUserList(userList);

		this.syncSeal2(sendId, outcontractEntity);
	}


	@Override
	public void syncSeal2(Long sendId, OutcontractEntity outcontractEntity){
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/use_seal/authorize";
			JSONObject params = new JSONObject();
			params.put("applyUserId", sendId.toString());
			List<String> useSealUserIdList = this.getContractManageUser();
			if(useSealUserIdList==null){
				useSealUserIdList = new ArrayList<>();
			}
			useSealUserIdList.add(sendId.toString());
			params.put("useSealUserIdList", useSealUserIdList);
			List<JSONObject> sealDetailList = new ArrayList<>();
			JSONObject sealDetail = new JSONObject();
			sealDetail.put("applyCount", outcontractEntity.getSealCount()+30);
			sealDetail.put("applyCrossPageSealCount", outcontractEntity.getPageSeal()+30);
			sealDetail.put("sealId", "7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
			sealDetailList.add(sealDetail);
			params.put("sealDetailList", sealDetailList);
			params.put("title ", "合同：【"+outcontractEntity.getContractName()+"】，申请用章");
			params.put("billNo", outcontractEntity.getBillCode());
			params.put("remark", outcontractEntity.getRemark());
			JSONObject policy = new JSONObject();
			List<Integer> num = new ArrayList<>();
			num.add(1);
			num.add(2);
			policy.put("videoRecordSealModel", num);
			policy.put("videoRecordCrossModel", num);
			policy.put("videoRecordWrongModel", num);
			params.put("policy", policy);
			logger.info("用印同步数据参数：-------------{}",params.toJSONString());

			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("用印同步返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				String applyId = data.getString("applyId");
				JSONArray safeCodeList = data.getJSONArray("safeCodeList");
				JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
				String safeCode = safeCodeJSON.getString("safeCode");
				outcontractEntity.setTjPrintId(applyId);
				outcontractEntity.setTjPrintCode(safeCode);
				outcontractService.saveOrUpdate(outcontractEntity, false);
			}else{
				throw new BusinessException("用印同步失败");
			}
		}catch (Exception e){
			logger.info("用印同步失败:{}",e);
			throw new BusinessException("用印同步失败");
		}
	}
	@Override
	public void syncContractChangeSeal(Long billId) {
		ChangeOutcontractEntity changeEntity = outcontractChangeService.selectById(billId);

		List<OrgVO> orgList = new ArrayList<>();
		List<Long> orgIds = new ArrayList<>();
		List<UserVO> userList = new ArrayList<>();
		Long sendId = null;
		if(changeEntity.getAgent()!=null){
			//获取创建人
			CommonResponse<UserVO> createResponse = userApi.findUserByUserId(changeEntity.getAgent());
			if(createResponse.isSuccess() && createResponse.getData()!=null){
				userList.add(createResponse.getData());
				sendId = createResponse.getData().getId();
				orgIds.add(createResponse.getData().getOrgId());
			}
		}else{
			throw new BusinessException("缺少经办人信息，推送印章系统失败");
		}

		if(changeEntity.getSignUnit()!=null && !orgIds.contains(changeEntity.getSignUnit())){
			orgIds.add(changeEntity.getSignUnit());
		}
		//获取的所属组织，并判断是否是集团的
		CommonResponse<List<OrgVO>> orgResponse = orgApi.findAllByIds(orgIds);
		if(orgResponse.isSuccess() && orgResponse.getData()!=null){
			List<OrgVO> orgl = orgResponse.getData();
			for (OrgVO org : orgl) {
				orgList.add(org);
				if(org.getId() == changeEntity.getSignUnit()){
					if(org.getOrgType()==1&&!org.getInnerCode().contains("|")){
					}else{
						return;
					}
				}
			}
		}

//		this.syncOrgList(orgList);

		this.syncUserList(userList);

		this.syncSeal3(sendId, changeEntity);
	}


	@Override
	public void syncSeal3(Long sendId, ChangeOutcontractEntity changeEntity){
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("Authorization", "Bearer " + token);
		try{
			String url = tianjianUrl + "/use_seal/authorize";
			JSONObject params = new JSONObject();
			params.put("applyUserId", sendId.toString());
			List<String> useSealUserIdList = this.getContractManageUser();
			if(useSealUserIdList==null){
				useSealUserIdList = new ArrayList<>();
			}
			useSealUserIdList.add(sendId.toString());
			params.put("useSealUserIdList", useSealUserIdList);
			List<JSONObject> sealDetailList = new ArrayList<>();
			JSONObject sealDetail = new JSONObject();
			sealDetail.put("applyCount", changeEntity.getSealCount()+30);
			sealDetail.put("applyCrossPageSealCount", changeEntity.getPageSeal()+30);
			sealDetail.put("sealId", "7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
			sealDetailList.add(sealDetail);
			params.put("sealDetailList", sealDetailList);
			params.put("title ", "合同：【"+changeEntity.getContractName()+"】，申请用章");
			params.put("billNo", changeEntity.getBillCode());
			params.put("remark", changeEntity.getRemark());
			JSONObject policy = new JSONObject();
			List<Integer> num = new ArrayList<>();
			num.add(1);
			num.add(2);
			policy.put("videoRecordSealModel", num);
			policy.put("videoRecordCrossModel", num);
			policy.put("videoRecordWrongModel", num);
			params.put("policy", policy);
			logger.info("用印同步数据参数：-------------{}",params.toJSONString());

			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			logger.info("用印同步返回数据：-------------{}",backData);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("0".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				String applyId = data.getString("applyId");
				JSONArray safeCodeList = data.getJSONArray("safeCodeList");
				JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
				String safeCode = safeCodeJSON.getString("safeCode");
				changeEntity.setTjPrintId(applyId);
				changeEntity.setTjPrintCode(safeCode);
				outcontractChangeService.saveOrUpdate(changeEntity, false);
			}else{
				throw new BusinessException("用印同步失败");
			}
		}catch (Exception e){
			logger.info("用印同步失败:{}",e);
			throw new BusinessException("用印同步失败");
		}
	}
}
