/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.yzwSync.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DataToYzwUtil1 {
    private static final String CHARSET_UTF8 = "utf-8";

    private static String signRequest(Map<String, String> params, String secret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!DataToYzwUtil1.isNotEmpty((String)key) || !DataToYzwUtil1.isNotEmpty(value)) continue;
            query.append("&").append((String)key).append("=").append(value);
        }
        query.append("&appsecret=").append(secret);
        String data = query.toString().substring(1).toLowerCase();
        byte[] bytes = DataToYzwUtil1.encryptMD5(data);
        return DataToYzwUtil1.byte2hex(bytes);
    }

    public static String queryByYzwList(JSONObject object, String url, String method, String appKey, String appSecret) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appKey);
        params.put("format", "json");
        params.put("method", method);
        String nonce = DataToYzwUtil1.getUitstr();
        params.put("nonce", nonce);
        String dateitme = DataToYzwUtil1.gettime();
        params.put("timestamp", dateitme);
        params.put("version", "1.0");
        params.put("data", object.toString());
        String sign = DataToYzwUtil1.signRequest(params, appSecret);
        params.put("sign", sign);
        System.out.println(params);
        String response = DataToYzwUtil1.callApione(new URL(url), params);
        System.out.println(sign);
        return response;
    }

    private static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!DataToYzwUtil1.isNotEmpty(name) || !DataToYzwUtil1.isNotEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String callApione(URL url, Map<String, String> params) throws IOException {
        String query = DataToYzwUtil1.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setReadTimeout(60000);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            rsp = DataToYzwUtil1.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = DataToYzwUtil1.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return DataToYzwUtil1.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return DataToYzwUtil1.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = CHARSET_UTF8;
        if (DataToYzwUtil1.isNotEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || !DataToYzwUtil1.isNotEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String getUitstr() {
        char[] chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = formatter.format(date);
        String randStr = "";
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            int index = random.nextInt(36);
            randStr = randStr + chars[index];
        }
        return time + randStr;
    }

    public static String gettime() {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = formatter.format(date);
        return time;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        return DataToYzwUtil1.encryptMD5(data.getBytes(CHARSET_UTF8));
    }

    private static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET_UTF8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(CHARSET_UTF8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toLowerCase());
        }
        return sign.toString();
    }

    private static boolean isNotEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

