package com.ejianc.foundation.outcontractDisclosure.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.outcontractDisclosure.mapper.OutcontractDisclosureMapper;
import com.ejianc.foundation.outcontractDisclosure.bean.OutcontractDisclosureEntity;
import com.ejianc.foundation.outcontractDisclosure.service.IOutcontractDisclosureService;

import java.util.List;

/**
 * 供方合同交底
 * 
 * @author generator
 * 
 */
@Service("outcontractDisclosureService")
public class OutcontractDisclosureServiceImpl extends BaseServiceImpl<OutcontractDisclosureMapper, OutcontractDisclosureEntity> implements IOutcontractDisclosureService{

    @Override
    public List<OutcontractDisclosureEntity> checkBillCode(Long id, String billCode) {
        LambdaQueryWrapper<OutcontractDisclosureEntity> wrapper = new LambdaQueryWrapper();
        if (id != null){
            wrapper.ne(OutcontractDisclosureEntity::getId,id);
        }
        wrapper.eq(OutcontractDisclosureEntity::getBillCode,billCode);
        wrapper.eq(OutcontractDisclosureEntity::getDr,0);
        return super.list(wrapper);
    }

    @Override
    public List<OutcontractDisclosureEntity> selectUncommitedByContractId(Long id, Long contractId) {
        LambdaQueryWrapper<OutcontractDisclosureEntity> wrapper = new LambdaQueryWrapper<>();
        if (id!=null){
            wrapper.ne(OutcontractDisclosureEntity::getId,id);
        }
        wrapper.eq(OutcontractDisclosureEntity::getContractId,contractId);
        wrapper.eq(OutcontractDisclosureEntity::getDr,0);
        wrapper.eq(OutcontractDisclosureEntity::getBillState,0);
        return super.list(wrapper);
    }

    @Override
    public List<OutcontractDisclosureEntity> selectApprovingByContractId(Long id, Long contractId) {
        LambdaQueryWrapper<OutcontractDisclosureEntity> wrapper = new LambdaQueryWrapper<>();
        if (id!=null){
            wrapper.ne(OutcontractDisclosureEntity::getId,id);
        }
        wrapper.eq(OutcontractDisclosureEntity::getContractId,contractId);
        wrapper.eq(OutcontractDisclosureEntity::getDr,0);
        wrapper.in(OutcontractDisclosureEntity::getBillState,2,5);
        return super.list(wrapper);
    }

}
