package com.ejianc.foundation.outcontract.service.impl;

import cn.yzw.infra.component.base.model.YzwResult;
import cn.yzw.infra.component.fss.model.response.UploadResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.*;
import com.ejianc.foundation.outcontract.mapper.ChangeOutcontractMapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.outcontract.vo.*;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 变更分供方合同
 * 
 * @author generator
 * 
 */
@Service("changeOutcontractService")
public class ChangeOutcontractServiceImpl extends BaseServiceImpl<ChangeOutcontractMapper, ChangeOutcontractEntity> implements IChangeOutcontractService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IRecordOutcontractService outcontractRecordService;
	@Autowired
	private IYzwSyncService yzwSyncService;
	@Autowired
	private IShareSupplierApi supplierApi;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private IZjkjProjectApi zjkjProjectApi;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private cn.yzw.infra.component.fss.bean.FssClient fssClient;
    
	@Override
	public CommonResponse<ChangeOutcontractVO> saveChange(ChangeOutcontractVO saveOrUpdateVO) {

		//检验该单据是否存在
		boolean exitBill = false;
		if(saveOrUpdateVO.getId()!=null){
			ChangeOutcontractEntity e = this.getById(saveOrUpdateVO);
			if(e!=null){
				exitBill = true;
			}
		}
		ChangeOutcontractEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeOutcontractEntity.class);
    	//检验是否存在未生效的变更单据，若存在，则不能变更
    	QueryWrapper<ChangeOutcontractEntity> queryWrapper = new QueryWrapper<ChangeOutcontractEntity>();
    	queryWrapper.eq("outcontract_id", saveOrUpdateVO.getOutcontractId());
    	queryWrapper.eq("dr", 0);
    	queryWrapper.in("bill_state", "[0,4]");
    	if(saveOrUpdateVO.getId()!=null){
    		queryWrapper.ne("id", saveOrUpdateVO.getId());
    	}
    	List<ChangeOutcontractEntity> exit = this.list(queryWrapper);
    	if(exit!=null&&exit.size()>0){
    		throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
    	}

    	//处理子表数据
        // 供方信息
    	if(saveOrUpdateVO.getChangeOutcontractSupplierList()!=null&&saveOrUpdateVO.getChangeOutcontractSupplierList().size()>0){
    		ChangeOutcontractSupplierVO outcontractSupplierVO = saveOrUpdateVO.getChangeOutcontractSupplierList().get(0);
    		entity.setSupplierName(outcontractSupplierVO.getSupplierName());// 分供商名称
    		entity.setSupplierTaxPayerType(outcontractSupplierVO.getSupplierTaxPayerType());// 纳税人类型
    		entity.setSupplierSocialCreditCode(outcontractSupplierVO.getSupplierSocialCreditCode());// 统一社会信用代码
    		entity.setSupplierBank(outcontractSupplierVO.getSupplierBank()); // 开户行
    		entity.setSupplierBankAccount(outcontractSupplierVO.getSupplierBankAccount());; // 开户行账号
    		entity.setSupplierContactUser(outcontractSupplierVO.getSupplierContactUser()); // 联系人
    		entity.setSupplierContactUserAddress(outcontractSupplierVO.getSupplierContactUserAddress()); // 联系人地址
    		entity.setSupplierContactUserPhone(outcontractSupplierVO.getSupplierContactUserPhone()); // 联系人电话
    		entity.setSupplierContactUserEmail(outcontractSupplierVO.getSupplierContactUserEmail()); // 联系人邮箱
    		entity.setSupplierLegal(outcontractSupplierVO.getSupplierLegal()); // 法定代表人
    		entity.setSupplierTelephone(outcontractSupplierVO.getSupplierTelephone()); // 供方电话
    	}else{
    		entity.setSupplierName(null);// 分供商名称
    		entity.setSupplierTaxPayerType(null);// 纳税人类型
    		entity.setSupplierSocialCreditCode(null);// 统一社会信用代码
    		entity.setSupplierBank(null); // 开户行
    		entity.setSupplierBankAccount(null);; // 开户行账号
    		entity.setSupplierContactUser(null); // 联系人
    		entity.setSupplierContactUserAddress(null); // 联系人地址
    		entity.setSupplierContactUserPhone(null); // 联系人电话
    		entity.setSupplierContactUserEmail(null); // 联系人邮箱
    		entity.setSupplierLegal(null); // 法定代表人
    		entity.setSupplierTelephone(null); // 供方电话
    	}

		BigDecimal changeAmount = new BigDecimal(0);
		BigDecimal afterChangeAmount = new BigDecimal(0);//变更后金额
		Date supplementarySignTime = null; // 签约时间
		List<ChangeOutcontractSupplementaryAgreementEntity> changeOutcontractSupplementaryAgreementList = entity.getChangeOutcontractSupplementaryAgreementList();
		if(changeOutcontractSupplementaryAgreementList!=null&&changeOutcontractSupplementaryAgreementList.size()>0){
			for(ChangeOutcontractSupplementaryAgreementEntity agreementEntity : changeOutcontractSupplementaryAgreementList){
				if(StringUtils.isNotBlank(agreementEntity.getThisChange())&&"1".equals(agreementEntity.getThisChange())&&agreementEntity.getChangeAmount()!=null
						&& !(StringUtils.isNotBlank(agreementEntity.getRowState()) && "del".equals(agreementEntity.getRowState()))){
					changeAmount = changeAmount.add(agreementEntity.getChangeAmount());
					if(supplementarySignTime==null){
						supplementarySignTime = entity.getSupplementarySignTime();
					}
				}
			}
		}
		entity.setSupplementarySignTime(supplementarySignTime);
		if(entity.getOldAfterChangeAmount()!=null){
			afterChangeAmount = afterChangeAmount.add(entity.getOldAfterChangeAmount()).add(changeAmount);
		}else{
			if(entity.getContractPrice()!=null){
				afterChangeAmount = afterChangeAmount.add(entity.getContractPrice()).add(changeAmount);
			}else{
				afterChangeAmount = afterChangeAmount.add(changeAmount);
			}
		}

		if("劳务分包".equals(saveOrUpdateVO.getType()) || "专业分包".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList()!=null && saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList().size()>0){
				BigDecimal subcontractTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractSubcontractTotalPriceVO item : saveOrUpdateVO.getChangeOutcontractSubcontractTotalPriceList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractTotalAmount = subcontractTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractTotalAmount = subcontractTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractTotalAmount(subcontractTotalAmount);
			}
			if(saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList()!=null&&saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList().size()>0){
				List<ChangeOutcontractSubcontractUnitPriceVO> list = createTreeData(saveOrUpdateVO.getChangeOutcontractSubcontractUnitPriceList());
				BigDecimal subcontractUnitTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractSubcontractUnitPriceVO item : list){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						subcontractUnitTotalAmount = subcontractUnitTotalAmount.add(item.getTotalPrice());
					}
				}
				subcontractUnitTotalAmount = subcontractUnitTotalAmount.setScale(3, BigDecimal.ROUND_HALF_UP);
				entity.setSubcontractUnitTotalAmount(subcontractUnitTotalAmount);
			}
			if(entity.getSubcontractTotalAmount()!=null&&entity.getSubcontractUnitTotalAmount()!=null){
				entity.setSubcontractTotalAmount(entity.getSubcontractTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				entity.setSubcontractUnitTotalAmount(entity.getSubcontractUnitTotalAmount().setScale(2, BigDecimal.ROUND_HALF_UP));
				if(entity.getSubcontractTotalAmount().compareTo(entity.getSubcontractUnitTotalAmount())!=0){
					logger.info("分包工程总价汇总表合计金额-------------"+entity.getSubcontractTotalAmount());
					logger.info("分包工程综合单价计价表合计金额-------------"+entity.getSubcontractUnitTotalAmount());
					throw new BusinessException("分包工程总价汇总表合计金额("+entity.getSubcontractTotalAmount()+")与分包工程综合单价计价表合计金额("+entity.getSubcontractUnitTotalAmount()+")不一致，请修改后再保存");
				}
			}
		}else if("物资采购".equals(saveOrUpdateVO.getType()) || "周转材租赁".equals(saveOrUpdateVO.getType())
				|| "其它合同".equals(saveOrUpdateVO.getType()) || "课题支出类合同".equals(saveOrUpdateVO.getType())){
			if(saveOrUpdateVO.getChangeOutcontractMaterialList()!=null&&saveOrUpdateVO.getChangeOutcontractMaterialList().size()>0){
				BigDecimal contractPriceTotalAmount = new BigDecimal(0);
				for(ChangeOutcontractMaterialVO item : saveOrUpdateVO.getChangeOutcontractMaterialList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						contractPriceTotalAmount = contractPriceTotalAmount.add(item.getTotalPrice());
					}
				}
				entity.setContractPriceTotalAmount(contractPriceTotalAmount);
			}
		}else if("机械租赁".equals(saveOrUpdateVO.getType())){
			BigDecimal leaseItemTotalAmount = new BigDecimal(0);
			BigDecimal rentTotalAmount = new BigDecimal(0);
			BigDecimal contractPrice = new BigDecimal(0);
			if(saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList()!=null&&saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList().size()>0){
				for(ChangeOutcontractEquipmentLeaseItemVO item : saveOrUpdateVO.getChangeOutcontractEquipmentLeaseItemList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						leaseItemTotalAmount = leaseItemTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			if(saveOrUpdateVO.getChangeOutcontractEquipmentRentList()!=null&&saveOrUpdateVO.getChangeOutcontractEquipmentRentList().size()>0){
				for(ChangeOutcontractEquipmentRentVO item : saveOrUpdateVO.getChangeOutcontractEquipmentRentList()){
					if(item.getTotalPrice()!=null && !"del".equals(item.getRowState())){
						rentTotalAmount = rentTotalAmount.add(item.getTotalPrice());
					}
				}
			}
			entity.setLeaseItemTotalAmount(leaseItemTotalAmount);
			entity.setRentTotalAmount(rentTotalAmount);
		}
		entity.setChangeAmount(changeAmount);
		entity.setAfterChangeAmount(afterChangeAmount);
		this.saveOrUpdate(entity, false);
    	
		/*if(("劳务分包".equals(entity.getType())||"专业分包".equals(entity.getType()))&&!exitBill){
	    	//同步合同评审信息(新增时同步)
	    	ChangeOutcontractReviewEntity changeReviewEntity = new ChangeOutcontractReviewEntity();
	    	QueryWrapper<OutcontractReviewEntity> ReviewWrapper = new QueryWrapper<>();
	    	ReviewWrapper.eq("outcontract_id", entity.getOutcontractId());
	    	ReviewWrapper.eq("dr", 0);
	    	List<OutcontractReviewEntity> entitys = outcontractReviewservice.list(ReviewWrapper);
	    	if(entitys!=null&&entitys.size()>0){
	    		changeReviewEntity = BeanMapper.map(entitys.get(0), ChangeOutcontractReviewEntity.class);
	    		changeReviewEntity.setChangeOutcontractId(entity.getId());//默认和合同评审id一致
	        	changeReviewEntity.setCreateTime(null);
	        	changeReviewEntity.setCreateUserCode(null);
	        	changeReviewEntity.setTenantId(null);
	        	changeReviewEntity.setUpdateTime(null);
	        	changeReviewEntity.setUpdateUserCode(null);
	        	changeReviewEntity.setId(entity.getId());//默认和合同评审id一致
	        	changeOutcontractReviewService.saveOrUpdate(changeReviewEntity, false);
	    	}
		}*/
    	ChangeOutcontractVO vo = BeanMapper.map(entity, ChangeOutcontractVO.class);
    	vo.setChangeOutcontractSupplierList(saveOrUpdateVO.getChangeOutcontractSupplierList());
    	vo.setRecordOutcontractList(saveOrUpdateVO.getRecordOutcontractList());
    	if(vo.getChangeOutcontractSubcontractUnitPriceList()!=null&&vo.getChangeOutcontractSubcontractUnitPriceList().size()>0){
    		vo.setChangeOutcontractSubcontractUnitPriceList(createTreeData(vo.getChangeOutcontractSubcontractUnitPriceList()));
    	}
    	if(!exitBill){
        	//查询当前合同信息，将状态改为变更中
        	OutcontractEntity contractEntity = outcontractService.selectById(vo.getOutcontractId());
        	contractEntity.setChangeState("2");//状态改为变更中
        	contractEntity.setChangeId(vo.getId());
        	outcontractService.saveOrUpdate(contractEntity, false);
    	}
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}

	@Override
	public CommonResponse<String> delete(List<ChangeOutcontractVO> vos) {
        for(ChangeOutcontractVO vo : vos){
        	ChangeOutcontractEntity entity = this.getById(vo.getId());
        	OutcontractEntity contractEntity = outcontractService.selectById(entity.getOutcontractId());
    		QueryWrapper<RecordOutcontractEntity> queryWrapper = new QueryWrapper<>();
        	queryWrapper.eq("dr", 0);
        	queryWrapper.eq("outcontract_id", contractEntity.getId());
        	List<RecordOutcontractEntity> records = outcontractRecordService.list(queryWrapper);
        	if(records!=null&&records.size()>0){
        		contractEntity.setChangeState("3");//状态改为已变更
        	}else{
        		contractEntity.setChangeState("1");//状态改为未变更
        	}
        	contractEntity.setChangeId(null);
        	outcontractService.saveOrUpdate(contractEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
//        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
//        	changeOutcontractReviewService.removeByIds(vos.stream().map(ChangeOutcontractVO::getId).collect(Collectors.toList()),true);
//        }
		
        return CommonResponse.success("删除成功！");
	}

	@Override
	public void syncYzwContract(Long id) {
		ChangeOutcontractEntity entity = this.selectById(id);
		JSONObject param = new JSONObject();

		String tenderCode = entity.getCalibrationTenderCode();
		/*
		EXECUTION_CONTRACT("EXECUTION_CONTRACT", "招标执行合同"),
				TENDER_FRAMEWORK_PACT("TENDER_FRAMEWORK_PACT", "招标框架协议"),
				TENDER_PURCHASE_CONTRACT("TENDER_PURCHASE_CONTRACT", "招标采购合同"),

				NO_TENDER_EXECUTION_CONTRACT("NO_TENDER_EXECUTION_CONTRACT", "无招标执行合同"),
				FRAMEWORK_PACT("FRAMEWORK_PACT", "无招标框架协议"),
				PURCHASE_CONTRACT("PURCHASE_CONTRACT", "无招标采购合同"),

				PURCHASE_PURCHASE_CONTRACT("PURCHASE_PURCHASE_CONTRACT", "采购合同"),
				PURCHASE_FRAMEWORK_PACT("PURCHASE_FRAMEWORK_PACT", "采购框架协议"),
				PURCHASE_EXECUTION_CONTRACT("PURCHASE_EXECUTION_CONTRACT", "采购执行合同"),*/
		//若合同是框架协议，
		if(StringUtils.isNotBlank(entity.getYzwType())){
			if("采购合同".equals(entity.getYzwType())){
				param.put("categoryCode", "TENDER_PURCHASE_CONTRACT");//合同类型--招标采购合同
			}else if("框架协议".equals(entity.getYzwType())){
				param.put("categoryCode", "TENDER_FRAMEWORK_PACT");//合同类型-招标框架协议
			}else if("执行合同".equals(entity.getYzwType())){
				param.put("categoryCode", "EXECUTION_CONTRACT");//合同类型-招标执行合同
				if(entity.getFrameworkId()==null){
					throw new BusinessException("该执行合同缺少框架协议");
				}
				ChangeOutcontractEntity frameworkEntity = this.selectById(entity.getFrameworkId());
				tenderCode = frameworkEntity.getCalibrationTenderCode();
				param.put("frameworkOpenSysNo", frameworkEntity.getYzwOpenContractCode());//框架协议openSysNo编号
				param.put("frameworkSysNo", frameworkEntity.getYzwContractCode());//框架协议雪花id编号
			}
		}else{
			param.put("categoryCode", "TENDER_PURCHASE_CONTRACT");//合同类型-招标采购合同
		}
		//判断是否公共项目
		CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
		Boolean publicProject = false;
		List<String> plProjectName = new ArrayList<>();
		if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
			defdocResponse.getData().forEach(item -> {
				plProjectName.add(item.getName());
			});
		}
		if(plProjectName.contains(entity.getProjectName())){
			publicProject = true;
		}
		OutcontractEntity outcontractEntity = outcontractService.selectById(entity.getOutcontractId());
		BigDecimal amount = new BigDecimal(0);
		CommonResponse<ProjectVO> projectResponse = zjkjProjectApi.queryDetailById(entity.getProjectId());
		ProjectVO projectVO = null;
		if(projectResponse.isSuccess() && projectResponse.getData()!=null){
			projectVO = projectResponse.getData();
		}else{
			throw new BusinessException("未获取到项目信息");
		}
		String yzwProjectCode = projectVO.getYzwProjectCode();
		String yzwUser = projectVO.getYzwUser();
		if(StringUtils.isBlank(yzwProjectCode)){
			throw new BusinessException("项目未关联云筑网数据");
		}
		if(StringUtils.isBlank(yzwUser)){
			throw new BusinessException("项目人员未关联云筑网数据");
		}
		String buildUnit = null;
		if(entity.getBuildUnit()!=null){
			CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getBuildUnit());
			if(orgResponse.isSuccess() && orgResponse.getData()!=null){
				buildUnit = orgResponse.getData().getYzwOrgCode();
				if(StringUtils.isBlank(buildUnit)){
					throw new BusinessException("实施单位未关联云筑网数据");
				}
			}
		}
		String signUnit = null;
		if(entity.getSignUnit()!=null){
			if(entity.getBuildUnit()!=entity.getSignUnit()){
				CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getSignUnit());
				if(orgResponse.isSuccess() && orgResponse.getData()!=null){
					signUnit = orgResponse.getData().getYzwOrgCode();
					if(StringUtils.isBlank(signUnit)){
						throw new BusinessException("签约单位未关联云筑网数据");
					}
				}
			}else{
				signUnit = buildUnit;
			}
		}
		String partyBCompanyId = null;
		if(entity.getSupplier()!=null){
			CommonResponse<SupplierVO> supplierResponse = supplierApi.queryById(entity.getSupplier());
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null){
				partyBCompanyId = supplierResponse.getData().getYzwSupplierCode();
			}
			if(StringUtils.isBlank(partyBCompanyId)){
				throw new BusinessException("供应商未关联云筑网数据");
			}
		}
		Integer systemCategoryId = null;
		Boolean leaseFlag = false;
		if("劳务分包".equals(entity.getType())){
			systemCategoryId = 3;
			amount = entity.getSubcontractTotalAmount();
		}else if("专业分包".equals(entity.getType())){
			amount = entity.getSubcontractTotalAmount();
			systemCategoryId = 4;
		}else if("物资采购".equals(entity.getType())){
			amount = entity.getContractPriceTotalAmount();
			systemCategoryId = 1;
		}else if("机械租赁".equals(entity.getType())){
			amount = entity.getLeaseItemTotalAmount();
			leaseFlag = true;
			systemCategoryId = 2;
		}else if("周转材租赁".equals(entity.getType())){
			amount = entity.getContractPriceTotalAmount();
			systemCategoryId = 1;
			leaseFlag = true;
		}else if("设计勘察".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("咨询服务".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("其它合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("课题支出类合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}

		param.put("systemCategoryId", systemCategoryId);//品类ID
		param.put("amount", amount);//合同金额
		param.put("categoryCode", "TENDER_PURCHASE_CONTRACT");//合同类型      招标采购合同;招标框架协议;  无招标采购合同；无招标框架协议;招标执行合同;无招标执行合同
		param.put("createUserId", yzwUser);//创建人Id(项目上配置一个字段，云筑用户id，一个项目固定一个人)
		param.put("currency", "CNY");//币种
		param.put("customNo", entity.getBillCode());//合同编号

		if("物资采购".equals(entity.getType())){
			if(entity.getSignDate()!=null){
				param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getSignDate()));//合同开始日期
			}
			if(projectVO.getEndDate()!=null){
				param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd").format(projectVO.getEndDate()));//合同结束日期
			}else{
				SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
				Calendar calendar = Calendar.getInstance();
				calendar.add(Calendar.YEAR, 1);
				String effectiveEndTime = df1.format(entity.getSignDate());
				param.put("effectiveEndTime", effectiveEndTime);//合同结束日期
			}
		}else{
			if(entity.getMobilizationDate()!=null){
				param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getMobilizationDate()));//合同开始日期
			}
			if(entity.getExitDate()!=null){
				param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getExitDate()));//合同结束日期
			}
		}
		param.put("name", entity.getContractName());//合同名称

		List<String> organizationList = new ArrayList<>();
		organizationList.add(buildUnit);
		param.put("organizationList", organizationList);//实施单位---中建科技在云筑内组织id
		param.put("partyACode", signUnit);//签约单位	中建科技在云筑内组织id
		param.put("partyAManagerId", yzwUser);//甲方经办人Id:项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("partyBCompanyId", partyBCompanyId);//中标供应商的id	供应商	供应商对应的云筑ID
		List<String> projectListId = new ArrayList<>();
		if(publicProject){
			projectListId.add("-1000");
		}else{
			projectListId.add(yzwProjectCode);
		}
		param.put("projectListId", projectListId);//合同项目	项目	项目对应的云筑ID
		param.put("remark", entity.getRemark());//备注
		param.put("settlementAfterInspection", false);//是否收验货后结算
		param.put("signOrgName", entity.getSignUnitName());//甲方名称	签约单位
		if(entity.getSignDate()!=null){
			param.put("signTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getSignDate()));//签约日期
		}
		param.put("status", "SHELF_ON");//合同状态	固定值	SHELF_ON=已上架,、已归档
		param.put("sysNo", entity.getOutcontractCode());//合同编号
		param.put("tenderCode", tenderCode);//云筑招标编号
		param.put("thirdPartyId", entity.getId().toString());//合同ID
		param.put("updateUserId", yzwUser);//创建人Id	项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("paymentMethod", "INSTALLMENTS");//付款方式 ONE_TIME=一次性付款;INSTALLMENTS=分期付款;OTHER=其它;
		String pricingMethod = null;
		switch (entity.getPricingForm()) {
			case "按建筑面积平米的每平米固定单价":
			case "按实体工程量对应的固定单价":
			case "按承包合同价款让利费率下浮":
			case "固定单价":
			case "可调价格":
				pricingMethod = "UNIT_PRICE";//单价合同
				break;
			case "固定总价":
				pricingMethod = "LUMP_SUM";//总价合同
				break;
			case "定额计价":
			case "其他":
				pricingMethod = "OTHER";//其他形式合同
				break;
		}
		param.put("pricingMethod", pricingMethod);//计价方式 LUMP_SUM=总价合同;UNIT_PRICE=单价合同;COST_PLUS=成本加酬金合同;OTHER=其他形式合同;
		param.put("leaseFlag", leaseFlag);//根据合同类型判断	周材租赁，设备租赁传“是”

        param.put("majorOpenSysNo", outcontractEntity.getYzwOpenContractCode());//主合同openSysNo编号
        param.put("majorSysNo", entity.getYzwContractCode());//主合同编号

//        param.put("otherAttachmentList", );//其他附件说明（参数详情见otherAttachmentList）

		param.put("signType", "CHANGE_CONTRACT");//合同签订类型	固定值	MAJOR_CONTRACT主合同，CHANGE_CONTRACT变更合同，SUPPLEMENTARY_PACT补充协议，解除合同
		param.put("signWay", "ONLINE");//签章方式	固定值/签章方式	线上电子签章，OFFLINE线下签章

		JSONArray signedAttachmentList = this.upadteYzwFile(entity.getId(), entity.getType());
		param.put("signedAttachmentList", signedAttachmentList);//已签章附件（参数详情见signedAttachmentList）
		if("劳务分包".equals(entity.getType()) || "专业分包".equals(entity.getType())){
			JSONArray listData = this.dealUnitListData(entity.getChangeOutcontractSubcontractUnitPriceList());
			param.put("listData", listData);//
		}else if("物资采购".equals(entity.getType()) || "周转材租赁".equals(entity.getType())){
			JSONArray listData = this.dealMaterialListData(entity.getChangeOutcontractMaterialList());
			param.put("listData", listData);//
		}else if("机械租赁".equals(entity.getType())){
			JSONArray listData = this.dealEquipmentListRentData(entity.getChangeOutcontractEquipmentRentList());
			param.put("listData", listData);//
		}
		JSONObject result = yzwSyncService.syncContract(param);
		String sysNo = result.getString("sysNo");
		entity.setYzwContractCode(sysNo);
		this.saveOrUpdate(entity, false);
	}

	private JSONArray dealUnitListData(List<ChangeOutcontractSubcontractUnitPriceEntity> unitPriceList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "分包工程综合单价计价清单");
		data.put("source", "yql");
		/*
				OTHER("OTHER", "其它"),
				PRODUCT("PRODUCT", "商品清单"),
				BOQ("BOQ", "工程量清单"),
				CATEGORY_PRODUCT("CATEGORY_PRODUCT", "商品类别+商品清单");*/
		data.put("listType", "BOQ");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0001");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwForeignId","云筑工程量分类id","TEXT",1, false));
		columns.add(this.createColumn("outForeignId","三方工程量分类id","TEXT",1, false));
		columns.add(this.createColumn("listCode","清单编号","TEXT",1, true));
		columns.add(this.createColumn("project","项目","TEXT",2, true));
		columns.add(this.createColumn("jobContent","工作内容","TEXT",3, true));
		columns.add(this.createColumn("projectCharacteristic","项目特征","TEXT",4, true));
		columns.add(this.createColumn("engineeringQuantity","工程量","NUMBER",6, true));
		columns.add(this.createColumn("comprehensiveUnitPrice","综合单价","NUMBER",7, true));
		columns.add(this.createColumn("totalPrice","合计","NUMBER",8, true));
		columns.add(this.createColumn("laborCost","人工费","NUMBER",9, true));
		columns.add(this.createColumn("mainMaterialCost","主材费","NUMBER",10, true));
		columns.add(this.createColumn("materialLoss","材料损耗","NUMBER",11, true));
		columns.add(this.createColumn("auxiliaryMaterialCost","辅材费","NUMBER",12, true));
		columns.add(this.createColumn("machineryCost","机械费","NUMBER",13, true));
		columns.add(this.createColumn("managementCost","管理费","NUMBER",14, true));
		columns.add(this.createColumn("profit","利润","NUMBER",15, true));
		columns.add(this.createColumn("paidGovernmentCost","规费","NUMBER",16, true));
		columns.add(this.createColumn("tax","税金","NUMBER",17, true));
		columns.add(this.createColumn("mainMaterialBrand","主材品牌","TEXT",18, true));
		columns.add(this.createColumn("remark","备注","TEXT",19, true));

		columns.add(this.createColumn("ForeignCode","分部分项项目编码","TEXT",20, false));
		columns.add(this.createColumn("Name","分部分项项目名称","TEXT",20, false));
		columns.add(this.createColumn("Character","分部分项项目特征","TEXT",20, false));
		columns.add(this.createColumn("GCL","工程量","NUMBER",21, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",5, true));
		columns.add(this.createColumn("TaxRate","税率","NUMBER",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("ComUnitPrice","综合单价/含税单价","NUMBER",28, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject par = new JSONObject();
		JSONObject dataValue = new JSONObject();
		dataValue.put("yzwForeignId", "20036773");//先固定值
		par.put("dataValue", dataValue);

		JSONArray chil = new JSONArray();
		if(unitPriceList!=null && unitPriceList.size()>0) {
			List<ChangeOutcontractSubcontractUnitPriceVO> vos = BeanMapper.mapList(unitPriceList, ChangeOutcontractSubcontractUnitPriceVO.class);
			List<ChangeOutcontractSubcontractUnitPriceVO> list = createTreeData(vos);
			for (ChangeOutcontractSubcontractUnitPriceVO vo : list) {
				JSONObject re = new JSONObject();
				JSONObject ins = dealJson(vo);
				re.put("dataValue", ins);
				chil.add(re);
			}
		}
		par.put("childList", chil);
		instance.add(par);
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	public JSONObject dealJson(ChangeOutcontractSubcontractUnitPriceVO vo){
		JSONObject ins = new JSONObject();

		ins.put("GCL", vo.getEngineeringQuantity());
		ins.put("Unit", StringUtils.isNotBlank(vo.getUnit())?vo.getUnit():"/");
		ins.put("Character", vo.getProject());
		ins.put("TaxRate", 0);
		ins.put("TaxAmount", 0);
		ins.put("ComUnitPrice", vo.getComprehensiveUnitPrice());
		ins.put("ExcludeTaxUnitPrice", vo.getComprehensiveUnitPrice());
		ins.put("Valence", vo.getTotalPrice());
		ins.put("ExcludeTaxTotalPrice", vo.getTotalPrice());

		ins.put("listCode", vo.getListCode());
		ins.put("project", vo.getProject());
		ins.put("jobContent", vo.getJobContent());
		ins.put("projectCharacteristic", vo.getProjectCharacteristic());
		ins.put("engineeringQuantity", vo.getEngineeringQuantity());
		ins.put("comprehensiveUnitPrice", vo.getComprehensiveUnitPrice());
		ins.put("totalPrice", vo.getTotalPrice());
		ins.put("laborCost", vo.getLaborCost());
		ins.put("mainMaterialCost", vo.getMainMaterialCost());
		ins.put("materialLoss", vo.getMaterialLoss());
		ins.put("auxiliaryMaterialCost", vo.getAuxiliaryMaterialCost());
		ins.put("machineryCost", vo.getMachineryCost());
		ins.put("profit", vo.getProfit());
		ins.put("paidGovernmentCost", vo.getPaidGovernmentCost());
		ins.put("tax", vo.getTax());
		ins.put("mainMaterialBrand", vo.getMainMaterialBrand());
		ins.put("remark", vo.getRemark());
		if(vo.getChildren()!=null && vo.getChildren().size()>0){
			JSONArray chil = new JSONArray();
			for (ChangeOutcontractSubcontractUnitPriceVO cl : vo.getChildren()) {
				JSONObject re = new JSONObject();
				JSONObject in = dealJson(cl);
				re.put("dataValue", in);
				chil.add(re);
			}
			ins.put("childList", chil);
		}
		return ins;
	}

	public List<ChangeOutcontractSubcontractUnitPriceVO> createTreeData(List<ChangeOutcontractSubcontractUnitPriceVO> list) {
		List<ChangeOutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ChangeOutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(ChangeOutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}

		for(int i =0; i<list.size(); i++) {
			ChangeOutcontractSubcontractUnitPriceVO item = list.get(i);
			String parentId = (item.getPid() != null) ? item.getPid().toString():"";
			ChangeOutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
			if(parent != null) {
				List<ChangeOutcontractSubcontractUnitPriceVO> child = (List<ChangeOutcontractSubcontractUnitPriceVO>) parent.getChildren();
				if(child != null) {
					child.add(item);
				}else{
					List<ChangeOutcontractSubcontractUnitPriceVO> children = new ArrayList<ChangeOutcontractSubcontractUnitPriceVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getId().toString());
			}
		}

		for(String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}

	private JSONArray dealMaterialListData(List<ChangeOutcontractMaterialEntity> materialList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "物资清单");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0002");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwSkuNo","sku编号","TEXT",1, false));
		columns.add(this.createColumn("CategoryName","商品类别","TEXT",20, false));
		columns.add(this.createColumn("ProductCommonName","商品名称","TEXT",21, false));
		columns.add(this.createColumn("Model","规格型号","TEXT",22, false));
		columns.add(this.createColumn("QuotedBasis","报价依据","TEXT",23, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",25, false));
		columns.add(this.createColumn("TaxRate","税率","TEXT",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("QuotedPrice","含税单价","NUMBER",28, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));

		columns.add(this.createColumn("materialCode","物资编码","TEXT",1, true));
		columns.add(this.createColumn("materialName","标的名称","TEXT",2, true));
		columns.add(this.createColumn("strengthGrade","强度等级","TEXT",3, true));
		columns.add(this.createColumn("materialSpec","规格型号","TEXT",4, true));
		columns.add(this.createColumn("brandTrademark","品牌商标","TEXT",5, true));
		columns.add(this.createColumn("materialUnit","计量单位","TEXT",6, true));
		columns.add(this.createColumn("quantity","暂定数量","NUMBER",7, true));
		columns.add(this.createColumn("untaxUnitPrice","不含税单价","NUMBER",8, true));
		columns.add(this.createColumn("taxUnitPrice","含税单价","NUMBER",10, true));
		columns.add(this.createColumn("totalPrice","合价","NUMBER",11, true));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject dataValue = new JSONObject();

		for (ChangeOutcontractMaterialEntity vo : materialList) {
			JSONObject ins = new JSONObject();
			ins.put("yzwSkuNo", vo.getYzwSkuNo());
			ins.put("Model", vo.getMaterialSpec());
			ins.put("QuotedBasis", StringUtils.isNotBlank(vo.getBrandTrademark())?vo.getBrandTrademark():vo.getMaterialName());
			ins.put("Quantity", vo.getQuantity());
			ins.put("TaxRate", vo.getTaxRate());
			ins.put("TaxAmount", 0);
			ins.put("QuotedPrice", vo.getTaxUnitPrice());
			ins.put("ExcludeTaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("Valence", vo.getTotalPrice());
			ins.put("ExcludeTaxTotalPrice", vo.getUntaxUnitPrice().multiply(vo.getQuantity()));

			ins.put("materialCode", vo.getMaterialCode());
			ins.put("materialName", vo.getMaterialName());
			ins.put("strengthGrade", vo.getStrengthGrade());
			ins.put("materialSpec", vo.getMaterialSpec());
			ins.put("brandTrademark", vo.getBrandTrademark());
			ins.put("materialUnit", vo.getMaterialUnit());
			ins.put("quantity", vo.getQuantity());
			ins.put("untaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("taxUnitPrice", vo.getTaxUnitPrice());
			ins.put("totalPrice", vo.getTotalPrice());
			dataValue.put("dataValue", ins);
			instance.add(dataValue);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}
	private JSONArray dealEquipmentListRentData(List<ChangeOutcontractEquipmentRentEntity> outcontractEquipmentRentList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "租金明细");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0003");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwSkuNo","sku编号","TEXT",19, false));
		columns.add(this.createColumn("CategoryName","商品类别","TEXT",20, false));
		columns.add(this.createColumn("ProductCommonName","商品名称","TEXT",21, false));
		columns.add(this.createColumn("Model","规格型号","TEXT",22, false));
		columns.add(this.createColumn("QuotedBasis","报价依据","TEXT",23, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",25, false));
		columns.add(this.createColumn("TaxRate","税率","TEXT",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("QuotedPrice","含税单价","NUMBER",28, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));

		columns.add(this.createColumn("equipmentCode","设备编码","TEXT",1, true));
		columns.add(this.createColumn("equipmentName","设备名称","TEXT",2, true));
		columns.add(this.createColumn("equipmentSpec","规格","TEXT",3, true));
		columns.add(this.createColumn("untaxUnitPrice","不含税单价（元）","NUMBER",4, true));
		columns.add(this.createColumn("taxUnitPrice","含税单价（元）","NUMBER",5, true));
		columns.add(this.createColumn("equipmentUnit","单位","TEXT",6, true));
		columns.add(this.createColumn("quantity","台数","NUMBER",7, true));
		columns.add(this.createColumn("leaseTerm","租赁期（月）","NUMBER",8, true));
		columns.add(this.createColumn("taxRate","税率（%）","NUMBER",9, true));
		columns.add(this.createColumn("totalPrice","合价（元）","NUMBER",10, true));
		columns.add(this.createColumn("remark","备注","TEXT",11, true));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject dataValue = new JSONObject();
		for (ChangeOutcontractEquipmentRentEntity vo : outcontractEquipmentRentList) {
			JSONObject ins = new JSONObject();
			ins.put("yzwSkuNo", vo.getYzwSkuNo());
			ins.put("Model", vo.getEquipmentCode());
			ins.put("QuotedBasis", vo.getEquipmentSpec());
			ins.put("Quantity", vo.getQuantity());
			ins.put("TaxRate", vo.getTaxRate());
			ins.put("TaxAmount", 0);
			ins.put("QuotedPrice", vo.getTaxUnitPrice());
			ins.put("ExcludeTaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("Valence", vo.getTotalPrice());
			ins.put("ExcludeTaxTotalPrice", vo.getUntaxUnitPrice().multiply(new BigDecimal(vo.getQuantity())));

			ins.put("equipmentCode", vo.getEquipmentCode());
			ins.put("equipmentName", vo.getEquipmentName());
			ins.put("equipmentSpec", vo.getEquipmentSpec());
			ins.put("untaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("taxUnitPrice", vo.getTaxUnitPrice());
			ins.put("equipmentUnit", vo.getEquipmentUnit());
			ins.put("quantity", vo.getQuantity());
			ins.put("leaseTerm", vo.getLeaseTerm());
			ins.put("taxRate", vo.getTaxRate());
			ins.put("totalPrice", vo.getTotalPrice());
			ins.put("remark", vo.getRemark());
			dataValue.put("dataValue", ins);
			instance.add(dataValue);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	public JSONArray upadteYzwFile(Long id, String type){
		JSONArray signedAttachmentList = new JSONArray();
		String billType = null;
		String sourceType = "zjkj-outcontractChange";
		if("劳务分包".equals(type)){
			billType = "BT220105000000010";
		}else if("专业分包".equals(type)){
			billType = "BT220105000000011";
		}else if("物资采购".equals(type)){
			billType = "BT220105000000012";
		}else if("机械租赁".equals(type)){
			billType = "BT220105000000013";
		}else if("周转材租赁".equals(type)){
			billType = "BT220105000000014";
		}else if("设计勘察".equals(type)){
			billType = "BT220105000000015";
		}else if("咨询服务".equals(type)){
			billType = "BT220105000000016";
		}else if("其它合同".equals(type)){
			billType = "BT220105000000017";
		}else if("课题支出类合同".equals(type)){
			billType = "EJCBT202207000041";
		}
		CommonResponse<List<AttachmentVO>> att = attachmentApi.queryListBySourceId(id, billType, sourceType, null);
		if(att.isSuccess() && att.getData()!=null){
			for (AttachmentVO datum : att.getData()) {
				String downloadUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/no_auth/download?fileId="+datum.getId();
				byte[] fileData = null;
				try{
					// 获取文件大小
					URL download = new URL(downloadUrl);
					HttpURLConnection conn = (HttpURLConnection) download.openConnection();
					conn.setRequestMethod("HEAD");
					// 下载文件
					InputStream in = new BufferedInputStream(download.openStream());
					ByteArrayOutputStream out = new ByteArrayOutputStream();
					byte[] buffer = new byte[4096];
					int bytesRead;
					while ((bytesRead = in.read(buffer)) != -1) {
						out.write(buffer, 0, bytesRead);
					}
					fileData = out.toByteArray();
				}catch (Exception e){
					throw new BusinessException("获取文件失败");
				}
				YzwResult<UploadResponse> fssResult = fssClient.upload(datum.getFileName(), fileData, null);
				logger.info(BeanMapper.map(fssResult, JSONObject.class).toJSONString());
				if(fssResult.getCode()==200){
					JSONObject signedAttachment = new JSONObject();
					signedAttachment.put("fileName", datum.getFileName());
					signedAttachment.put("ossUrl", fssResult.getData().getUrl());
					signedAttachment.put("fileSize", datum.getFileSize());
					signedAttachmentList.add(signedAttachment);
				}
			}
		}else{
			throw new BusinessException("未获取到合同签章文件,请先上传附件");
		}
		return signedAttachmentList;
	}


	private JSONObject createColumn(String columnCode, String columnName, String valueType, Integer sortIndex, Boolean visible){
		JSONObject column = new JSONObject();
		column.put("columnCode", columnCode);
		column.put("columnName", columnName);
		column.put("valueType", valueType);
		column.put("sortIndex", sortIndex);
		column.put("requiredEnable", false);
		column.put("editEnable", false);
		column.put("visible", visible);
		return column;
	}
}
