package com.ejianc.foundation.report.service.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.ejianc.foundation.report.service.IOutcontractSignStatisticService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryByProjectService;
import com.ejianc.foundation.report.service.IOutcontractSignSummaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.report.mapper.OutcontractReportMapper;
import com.ejianc.foundation.report.bean.OutcontractReportEntity;
import com.ejianc.foundation.report.service.IOutcontractReportService;

/**
 * 报表分析表
 *
 * @author generator
 *
 */
@Service("outcontractReportService")
public class OutcontractReportServiceImpl extends BaseServiceImpl<OutcontractReportMapper, OutcontractReportEntity> implements IOutcontractReportService{

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IOutcontractSignStatisticService outcontractSignStatisticService;
    @Autowired
    private IOutcontractSignSummaryService outcontractSignSummaryService;
    @Autowired
    private IOutcontractSignSummaryByProjectService outcontractSignSummaryByProjectService;

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long orgId = InvocationInfoProxy.getTenantid();
		String userCode = InvocationInfoProxy.getUsercode();
        //
        new Thread(() -> {
            try {
				InvocationInfoProxy.setUsercode(userCode);
				InvocationInfoProxy.setTenantid(tenantId);
				InvocationInfoProxy.setOrgId(orgId);
            	outcontractSignStatisticService.saveESData("供方合同签约情况统计（自动）"+curDate);
            } catch (Exception e) {
                logger.error("生成供方合同签约统计报表数据异常，", e);
            }
        }).start();
        new Thread(() -> {
            try {
				InvocationInfoProxy.setUsercode(userCode);
				InvocationInfoProxy.setTenantid(tenantId);
				InvocationInfoProxy.setOrgId(orgId);
            	outcontractSignSummaryService.saveESData("集团-供方合同签约统计汇总表（自动）"+curDate);
            } catch (Exception e) {
                logger.error("生成供方合同签约统计报表数据异常，", e);
            }
        }).start();
        new Thread(() -> {
            try {
				InvocationInfoProxy.setUsercode(userCode);
				InvocationInfoProxy.setTenantid(tenantId);
				InvocationInfoProxy.setOrgId(orgId);
            	outcontractSignSummaryByProjectService.saveESData("区域公司-供方合同签约统计汇总表（自动）"+curDate);
            } catch (Exception e) {
                logger.error("生成供方合同签约统计报表数据异常，", e);
            }
        }).start();

        return null;
    }

    //获取上一个月字符串
    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 设置为当前时间
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) - 1); // 设置为上一个月
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }
}

