/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sealApproval.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.ChangeOutcontractEntity;
import com.ejianc.foundation.outcontract.bean.OutcontractEntity;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.service.IRecordOutcontractService;
import com.ejianc.foundation.sealApproval.bean.SealApprovalEntity;
import com.ejianc.foundation.sealApproval.service.ISealApprovalService;
import com.ejianc.foundation.sealApproval.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.util.HttpTookit;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZjkjTianJianSyncServiceImpl
implements IZjkjTianJianSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${tianjianUrl:http://36.137.93.200:10006/open_api}")
    private String tianjianUrl;
    @Autowired
    private ISealApprovalService sealApprovalService;
    @Autowired
    private IOutcontractService outcontractService;
    @Autowired
    private IChangeOutcontractService outcontractChangeService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IRecordOutcontractService recordOutcontractService;
    @Autowired
    private CacheManager cacheManager;

    @Override
    public void syncSeal(Long sealId) {
        DeptVO dept;
        CommonResponse orgResponse;
        SealApprovalEntity sealEntity = (SealApprovalEntity)((Object)this.sealApprovalService.selectById(sealId));
        if (StringUtils.isNotBlank((CharSequence)sealEntity.getTjPrintId())) {
            return;
        }
        if (!StringUtils.isNotBlank((CharSequence)sealEntity.getContractSeal()) || !"contractSeal".equals(sealEntity.getContractSeal())) {
            return;
        }
        Long applyDept = sealEntity.getApplyDept();
        CommonResponse deptResponse = this.orgApi.findDeptById(applyDept);
        if (deptResponse.isSuccess() && deptResponse.getData() != null && (orgResponse = this.orgApi.detailById((dept = (DeptVO)deptResponse.getData()).getOrgId())).isSuccess() && orgResponse.getData() != null) {
            OrgVO org = (OrgVO)orgResponse.getData();
            if (org.getOrgType() == 1 && !org.getInnerCode().contains("|")) {
                ArrayList<OrgVO> l = new ArrayList<OrgVO>();
                l.add(org);
            } else {
                return;
            }
        }
        ArrayList<UserVO> userList = new ArrayList<UserVO>();
        Long sendId = null;
        Long sealUserId = null;
        CommonResponse createResponse = this.userApi.queryUserByUserCode(sealEntity.getCreateUserCode());
        if (createResponse.isSuccess() && createResponse.getData() != null) {
            userList.add((UserVO)createResponse.getData());
            sendId = ((UserVO)createResponse.getData()).getId();
        }
        if (!sendId.equals(sealEntity.getEmployeeId())) {
            CommonResponse employeeResponse = this.userApi.findUserByUserId(sealEntity.getEmployeeId());
            if (employeeResponse.isSuccess() && employeeResponse.getData() != null) {
                userList.add((UserVO)employeeResponse.getData());
                sealUserId = ((UserVO)employeeResponse.getData()).getId();
            }
        } else {
            sealUserId = sendId;
        }
        this.syncUserList(userList);
        this.syncSeal(sendId, sealUserId, sealEntity);
    }

    @Override
    public void syncOrgList(List<OrgVO> orgList) {
        ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
        for (OrgVO orgVO : orgList) {
            JSONObject d = new JSONObject();
            if ("1247777316689256450".equals(orgVO.getId().toString())) continue;
            d.put("id", (Object)orgVO.getId().toString());
            d.put("name", (Object)orgVO.getName());
            d.put("parentId", (Object)(orgVO.getParentId() != null ? (orgVO.getParentId().toString().equals("1247777316689256450") ? "1" : orgVO.getParentId().toString()) : "0"));
            d.put("orgType", (Object)2);
            deptList.add(d);
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/depart/sync";
            JSONObject params = new JSONObject();
            params.put("deptList", deptList);
            this.logger.info("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void syncUserList(List<UserVO> users) {
        ArrayList<JSONObject> userList = new ArrayList<JSONObject>();
        for (UserVO user : users) {
            JSONObject d = new JSONObject();
            d.put("id", (Object)user.getId().toString());
            d.put("username", (Object)user.getUserCode());
            d.put("realname", (Object)user.getUserName());
            d.put("phone", (Object)user.getUserMobile());
            ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
            JSONObject org = new JSONObject();
            org.put("id", (Object)"1");
            deptList.add(org);
            d.put("deptList", deptList);
            JSONObject defaultOrg = new JSONObject();
            defaultOrg.put("id", (Object)"1");
            d.put("defaultDept", (Object)defaultOrg);
            d.put("email", (Object)user.getUserEmail());
            userList.add(d);
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/user/sync";
            JSONObject params = new JSONObject();
            params.put("userList", userList);
            this.logger.info("\u4eba\u5458\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            this.logger.info("\u4eba\u5458\u540c\u6b65\u6570\u636e\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
    }

    public List<String> getContractManageUser() {
        ArrayList<String> userList;
        block5: {
            userList = new ArrayList<String>();
            String token = this.getToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + token);
            try {
                String url = this.tianjianUrl + "/seal/page";
                JSONObject params = new JSONObject();
                params.put("pageSize", (Object)100);
                params.put("begin", (Object)0);
                this.logger.info("\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f\u5217\u8868\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
                String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
                JSONObject jsonResponse = JSON.parseObject((String)backData);
                this.logger.info("\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f\u5217\u8868\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
                if ("0".equals(jsonResponse.getString("code"))) {
                    JSONArray data = jsonResponse.getJSONArray("data");
                    for (Object datum : data) {
                        JSONObject da = (JSONObject)datum;
                        JSONArray sealAdminList = jsonResponse.getJSONArray("sealAdminList");
                        if (sealAdminList == null || sealAdminList.size() <= 0) continue;
                        for (Object o : sealAdminList) {
                            JSONObject seal = (JSONObject)o;
                            userList.add(seal.getString("adminId"));
                        }
                    }
                    break block5;
                }
                throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f\u5217\u8868\u5931\u8d25");
            }
            catch (Exception e) {
                throw new BusinessException("\u83b7\u53d6\u5370\u7ae0\u4fe1\u606f\u5217\u8868\u5931\u8d25");
            }
        }
        return userList;
    }

    @Override
    public void syncSeal(Long sendId, Long sealUserId, SealApprovalEntity sealEntity) {
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/authorize";
            JSONObject params = new JSONObject();
            params.put("applyUserId", (Object)sendId.toString());
            List<String> useSealUserIdList = this.getContractManageUser();
            if (useSealUserIdList == null) {
                useSealUserIdList = new ArrayList<String>();
            }
            useSealUserIdList.add(sealUserId.toString());
            params.put("useSealUserIdList", useSealUserIdList);
            ArrayList<JSONObject> sealDetailList = new ArrayList<JSONObject>();
            JSONObject sealDetail = new JSONObject();
            sealDetail.put("applyCount", (Object)(sealEntity.getSealCount() + 30));
            sealDetail.put("applyCrossPageSealCount", (Object)(sealEntity.getPageSeal() + 30));
            sealDetail.put("sealId", (Object)"7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
            sealDetailList.add(sealDetail);
            params.put("sealDetailList", sealDetailList);
            params.put("title", (Object)("\u5408\u540c\uff1a\u3010" + sealEntity.getContractName() + "\u3011\uff0c\u7533\u8bf7\u7528\u7ae0"));
            params.put("billNo", (Object)sealEntity.getBillCode());
            params.put("remark", (Object)sealEntity.getSealReasons());
            JSONObject policy = new JSONObject();
            ArrayList<Integer> num = new ArrayList<Integer>();
            num.add(1);
            num.add(2);
            policy.put("videoRecordSealModel", num);
            policy.put("videoRecordCrossModel", num);
            policy.put("videoRecordWrongModel", num);
            params.put("policy", (Object)policy);
            this.logger.info("\u7528\u5370\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u540c\u6b65\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            String applyId = data.getString("applyId");
            JSONArray safeCodeList = data.getJSONArray("safeCodeList");
            JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
            String safeCode = safeCodeJSON.getString("safeCode");
            sealEntity.setTjPrintId(applyId);
            sealEntity.setTjPrintCode(safeCode);
            this.sealApprovalService.saveOrUpdate((Object)sealEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }

    @Override
    public void delContractSeal(Long billId) {
        OutcontractEntity outcontractEntity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        if (StringUtils.isBlank((CharSequence)outcontractEntity.getTjPrintId())) {
            return;
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/matter/remove";
            JSONObject params = new JSONObject();
            params.put("applyId ", (Object)outcontractEntity.getTjPrintId());
            this.logger.info("\u7528\u5370\u5220\u9664\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u5220\u9664\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u5220\u9664\u5931\u8d25");
            }
            outcontractEntity.setTjPrintId(null);
            outcontractEntity.setTjPrintCode(null);
            this.outcontractService.saveOrUpdate((Object)outcontractEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }

    @Override
    public String getToken() {
        String token = "";
        String key = "tj-token";
        if (this.cacheManager.get(key) != null) {
            token = (String)((Object)this.cacheManager.get(key));
        } else {
            try {
                String url = this.tianjianUrl + "/token/get";
                JSONObject params = new JSONObject();
                params.put("restname", (Object)"root");
                params.put("password", (Object)"Zj@kj#qunje");
                String backData = HttpTookit.postByJson(url, params.toJSONString());
                this.logger.info("\u83b7\u53d6token\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
                JSONObject jsonResponse = JSON.parseObject((String)backData);
                if (!"0".equals(jsonResponse.getString("code"))) {
                    throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
                }
                JSONObject data = jsonResponse.getJSONObject("data");
                token = data.getString("token");
                this.cacheManager.setex(key, (Serializable)((Object)token), 3600);
            }
            catch (Exception e) {
                throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
            }
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void syncContractSeal(Long billId) {
        OutcontractEntity outcontractEntity = (OutcontractEntity)((Object)this.outcontractService.selectById(billId));
        if (StringUtils.isNotBlank((CharSequence)outcontractEntity.getTjPrintId())) {
            return;
        }
        ArrayList orgList = new ArrayList();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<UserVO> userList = new ArrayList<UserVO>();
        Long sendId = null;
        if (outcontractEntity.getAgent() == null) throw new BusinessException("\u7f3a\u5c11\u7ecf\u529e\u4eba\u4fe1\u606f\uff0c\u63a8\u9001\u5370\u7ae0\u7cfb\u7edf\u5931\u8d25");
        CommonResponse createResponse = this.userApi.findUserByUserId(outcontractEntity.getAgent());
        if (createResponse.isSuccess() && createResponse.getData() != null) {
            userList.add((UserVO)createResponse.getData());
            sendId = ((UserVO)createResponse.getData()).getId();
            orgIds.add(((UserVO)createResponse.getData()).getOrgId());
        }
        if (outcontractEntity.getSignUnit() == null) return;
        CommonResponse orgResponse = this.orgApi.detailById(outcontractEntity.getSignUnit());
        if (orgResponse.isSuccess() && orgResponse.getData() != null) {
            OrgVO org = (OrgVO)orgResponse.getData();
            if (org.getOrgType() != 1 || org.getInnerCode().contains("|")) return;
            this.logger.info("\u7ec4\u7ec7InnerCode\uff1a{}", (Object)org.getInnerCode());
        } else {
            this.logger.info("\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff1a{}", (Object)orgResponse.getMsg());
            if (outcontractEntity.getSignUnit() != 1247777316689256450L) {
                return;
            }
        }
        this.syncUserList(userList);
        this.syncSeal2(sendId, outcontractEntity);
    }

    @Override
    public void syncSeal2(Long sendId, OutcontractEntity outcontractEntity) {
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/authorize";
            JSONObject params = new JSONObject();
            params.put("applyUserId", (Object)sendId.toString());
            List<String> useSealUserIdList = this.getContractManageUser();
            if (useSealUserIdList == null) {
                useSealUserIdList = new ArrayList<String>();
            }
            useSealUserIdList.add(sendId.toString());
            params.put("useSealUserIdList", useSealUserIdList);
            ArrayList<JSONObject> sealDetailList = new ArrayList<JSONObject>();
            JSONObject sealDetail = new JSONObject();
            sealDetail.put("applyCount", (Object)(outcontractEntity.getSealCount() + 30));
            sealDetail.put("applyCrossPageSealCount", (Object)(outcontractEntity.getPageSeal() + 30));
            sealDetail.put("sealId", (Object)"7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
            sealDetailList.add(sealDetail);
            params.put("sealDetailList", sealDetailList);
            params.put("title", (Object)("\u5408\u540c\uff1a\u3010" + outcontractEntity.getContractName() + "\u3011\uff0c\u7533\u8bf7\u7528\u7ae0"));
            params.put("billNo", (Object)outcontractEntity.getBillCode());
            params.put("remark", (Object)outcontractEntity.getRemark());
            JSONObject policy = new JSONObject();
            ArrayList<Integer> num = new ArrayList<Integer>();
            num.add(1);
            num.add(2);
            policy.put("videoRecordSealModel", num);
            policy.put("videoRecordCrossModel", num);
            policy.put("videoRecordWrongModel", num);
            params.put("policy", (Object)policy);
            this.logger.info("\u7528\u5370\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u540c\u6b65\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            String applyId = data.getString("applyId");
            JSONArray safeCodeList = data.getJSONArray("safeCodeList");
            JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
            String safeCode = safeCodeJSON.getString("safeCode");
            outcontractEntity.setTjPrintId(applyId);
            outcontractEntity.setTjPrintCode(safeCode);
            this.outcontractService.saveOrUpdate((Object)outcontractEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void syncContractChangeSeal(Long billId) {
        ChangeOutcontractEntity changeEntity = (ChangeOutcontractEntity)((Object)this.outcontractChangeService.selectById(billId));
        if (StringUtils.isNotBlank((CharSequence)changeEntity.getTjPrintId())) {
            return;
        }
        ArrayList orgList = new ArrayList();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<UserVO> userList = new ArrayList<UserVO>();
        Long sendId = null;
        if (changeEntity.getAgent() == null) throw new BusinessException("\u7f3a\u5c11\u7ecf\u529e\u4eba\u4fe1\u606f\uff0c\u63a8\u9001\u5370\u7ae0\u7cfb\u7edf\u5931\u8d25");
        CommonResponse createResponse = this.userApi.findUserByUserId(changeEntity.getAgent());
        if (createResponse.isSuccess() && createResponse.getData() != null) {
            userList.add((UserVO)createResponse.getData());
            sendId = ((UserVO)createResponse.getData()).getId();
            orgIds.add(((UserVO)createResponse.getData()).getOrgId());
        }
        if (changeEntity.getSignUnit() == null) return;
        CommonResponse orgResponse = this.orgApi.detailById(changeEntity.getSignUnit());
        if (orgResponse.isSuccess() && orgResponse.getData() != null) {
            OrgVO org = (OrgVO)orgResponse.getData();
            if (org.getOrgType() != 1 || org.getInnerCode().contains("|")) return;
            this.logger.info("\u7ec4\u7ec7InnerCode\uff1a{}", (Object)org.getInnerCode());
        } else {
            this.logger.info("\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff1a{}", (Object)orgResponse.getMsg());
            if (changeEntity.getSignUnit() != 1247777316689256450L) {
                return;
            }
        }
        this.syncUserList(userList);
        this.syncSeal3(sendId, changeEntity);
    }

    @Override
    public void delContractChangeSeal(Long billId) {
        ChangeOutcontractEntity outcontractEntity = (ChangeOutcontractEntity)((Object)this.outcontractChangeService.selectById(billId));
        if (StringUtils.isBlank((CharSequence)outcontractEntity.getTjPrintId())) {
            return;
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/matter/remove";
            JSONObject params = new JSONObject();
            params.put("applyId ", (Object)outcontractEntity.getTjPrintId());
            this.logger.info("\u7528\u5370\u5220\u9664\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u5220\u9664\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u5220\u9664\u5931\u8d25");
            }
            outcontractEntity.setTjPrintId(null);
            outcontractEntity.setTjPrintCode(null);
            this.outcontractChangeService.saveOrUpdate((Object)outcontractEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }

    @Override
    public void syncSeal3(Long sendId, ChangeOutcontractEntity changeEntity) {
        QueryWrapper recordWrapper = new QueryWrapper();
        recordWrapper.eq((Object)"outcontract_id", (Object)changeEntity.getOutcontractId());
        recordWrapper.eq((Object)"dr", (Object)0);
        Integer count = this.recordOutcontractService.count((Wrapper)recordWrapper);
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/use_seal/authorize";
            JSONObject params = new JSONObject();
            params.put("applyUserId", (Object)sendId.toString());
            List<String> useSealUserIdList = this.getContractManageUser();
            if (useSealUserIdList == null) {
                useSealUserIdList = new ArrayList<String>();
            }
            useSealUserIdList.add(sendId.toString());
            params.put("useSealUserIdList", useSealUserIdList);
            ArrayList<JSONObject> sealDetailList = new ArrayList<JSONObject>();
            JSONObject sealDetail = new JSONObject();
            sealDetail.put("applyCount", (Object)(changeEntity.getSealCount() + 30));
            sealDetail.put("applyCrossPageSealCount", (Object)(changeEntity.getPageSeal() + 30));
            sealDetail.put("sealId", (Object)"7aa7a92d-84db-4474-95ac-86ae4e21ca0f");
            sealDetailList.add(sealDetail);
            params.put("sealDetailList", sealDetailList);
            params.put("title", (Object)("\u5408\u540c\uff1a\u3010" + changeEntity.getContractName() + "\u3011\uff0c\u7533\u8bf7\u7528\u7ae0"));
            params.put("billNo", (Object)(changeEntity.getBillCode() + "-" + (count + 1)));
            params.put("remark", (Object)changeEntity.getRemark());
            JSONObject policy = new JSONObject();
            ArrayList<Integer> num = new ArrayList<Integer>();
            num.add(1);
            num.add(2);
            policy.put("videoRecordSealModel", num);
            policy.put("videoRecordCrossModel", num);
            policy.put("videoRecordWrongModel", num);
            params.put("policy", (Object)policy);
            this.logger.info("\u7528\u5370\u540c\u6b65\u6570\u636e\u53c2\u6570\uff1a-------------{}", (Object)params.toJSONString());
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            this.logger.info("\u7528\u5370\u540c\u6b65\u8fd4\u56de\u6570\u636e\uff1a-------------{}", (Object)backData);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"0".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            String applyId = data.getString("applyId");
            JSONArray safeCodeList = data.getJSONArray("safeCodeList");
            JSONObject safeCodeJSON = safeCodeList.getJSONObject(0);
            String safeCode = safeCodeJSON.getString("safeCode");
            changeEntity.setTjPrintId(applyId);
            changeEntity.setTjPrintCode(safeCode);
            this.outcontractChangeService.saveOrUpdate((Object)changeEntity, false);
        }
        catch (Exception e) {
            this.logger.info("\u7528\u5370\u540c\u6b65\u5931\u8d25:{}", (Throwable)e);
            throw new BusinessException("\u7528\u5370\u540c\u6b65\u5931\u8d25");
        }
    }
}

