package com.ejianc.foundation.outcontract.service.impl;

import cn.yzw.infra.component.base.model.YzwResult;
import cn.yzw.infra.component.fss.model.response.UploadResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.bean.*;
import com.ejianc.foundation.outcontract.mapper.OutcontractMapper;
import com.ejianc.foundation.outcontract.service.IChangeOutcontractService;
import com.ejianc.foundation.outcontract.service.IOutcontractReviewService;
import com.ejianc.foundation.outcontract.service.IOutcontractService;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.outcontract.vo.OutcontractSupplierVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.outcontractDisclosure.mapper.OutcontractDisclosureMapper;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.yzwSync.service.IYzwSyncService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分供方合同
 * 
 * @author generator
 * 
 */
@Service("outcontractService")
public class OutcontractServiceImpl extends BaseServiceImpl<OutcontractMapper, OutcontractEntity> implements IOutcontractService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${yzwForeignId:20036773}")
	private String yzwForeignId;

	@Autowired
	private IOutcontractReviewService reviewService;
	@Autowired
	private OutcontractDisclosureMapper outcontractDisclosureMapper;

	@Autowired
	private IChangeOutcontractService changeOutcontractService;
	@Autowired
	private OutcontractMapper contractMapper;
	@Autowired
	private IYzwSyncService yzwSyncService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IShareSupplierApi supplierApi;
	@Autowired
	private IOrgApi orgApi;
	@Autowired
	private IDefdocApi defdocApi;
	@Autowired
	private IZjkjProjectApi zjkjProjectApi;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private cn.yzw.infra.component.fss.bean.FssClient fssClient;

	@Override
	public CommonResponse<String> delete(List<OutcontractVO> vos) {
        this.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        //删除合同评审信息
        if("劳务分包".equals(vos.get(0).getType())||"专业分包".equals(vos.get(0).getType())){
        	reviewService.removeByIds(vos.stream().map(OutcontractVO::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
	}

	@Override
	public CommonResponse<String> changePerformanceStatus(Long id, String performanceStatus) {
        UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id).set("performance_status", performanceStatus);
        this.update(null, updateWrapper);
        return CommonResponse.success("更改履约状态成功！");
	}

	@Override
	public CommonResponse<String> changeDate(Long id, String type, Date date) {
		UpdateWrapper<OutcontractEntity> updateWrapper = new UpdateWrapper<>();
		if("mobilizationDate".equals(type)){
			updateWrapper.eq("id",id).set("mobilization_date", date);
		}else if("exitDate".equals(type)){
			updateWrapper.eq("id",id).set("exit_date", date);
		}
        this.update(null, updateWrapper);
        return CommonResponse.success("更改成功！");
	}

	@Override
	public CommonResponse<String> file(OutcontractVO outcontractVO) {
		OutcontractEntity entity = this.selectById(outcontractVO.getId());
		if("1".equals(entity.getFileState())){
			throw new BusinessException("不能重复归档");
		}
		//变更后的合同归档的签约日期更新补充协议的签约日期，原合同签约日期不变
		if("1".equals(entity.getChangeState())){
			//未变更过的
			entity.setSignDate(outcontractVO.getSignDate());
		}else{
			//查询变更的单据
			QueryParam param = new QueryParam();
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			param.getParams().put("outcontractId", new Parameter(QueryParam.EQ, entity.getId()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			List<ChangeOutcontractEntity> list = changeOutcontractService.queryList(param,false);
			ChangeOutcontractEntity changeEntity = new ChangeOutcontractEntity();
			if(list!=null && list.size()>0){
				changeEntity = list.get(0);
				changeEntity.setSupplementarySignTime(outcontractVO.getSignDate());
				changeOutcontractService.saveOrUpdate(changeEntity, false);
			}
		}
		entity.setFileState("1");
		this.saveOrUpdate(entity, false);
		//处理冗余其他单据中的合同金额及签约日期
		this.redundanceData(entity);
		CommonResponse<String> back = attachmentApi.updateAttachRef(outcontractVO.getId(), outcontractVO.getAttachIds());
		if(!back.isSuccess()){
			throw new BusinessException("归档失败");
		}
		return CommonResponse.success("归档成功！");
	}

	@Override
	public IPage<OutcontractSupplierVO> refSupplierList(Map<String, Object> params) {
		Long count = contractMapper.countSupplier(params);
		Integer pageIndex = (Integer) params.get("pageIndex");
		Integer pageSize = (Integer) params.get("pageSize");
		IPage<OutcontractSupplierVO> pageData = new Page<>(pageIndex, pageSize, count);
		if(count>0){
			List<OutcontractSupplierVO> list = contractMapper.querySupplierList(params);
			List<Long> ids = new ArrayList<>();
			for(OutcontractSupplierVO vo : list){
				ids.add(vo.getId());
			}
			CommonResponse<List<SupplierVO>> supplierResponse = shareSupplierApi.querySupplierByIds(ids);
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null && supplierResponse.getData().size()>0){
				Map<Long, SupplierVO> map = new HashMap<>();
				for(SupplierVO vo : supplierResponse.getData()){
					map.put(vo.getId(),vo);
				}
				for(OutcontractSupplierVO vo : list){
					if(map.get(vo.getId())!=null){
						SupplierVO supplierVO = map.get(vo.getId());
						vo.setSupplierName(supplierVO.getName());
						vo.setSupplierTaxPayerType(supplierVO.getTaxPayerType());
						vo.setSupplierSocialCreditCode(supplierVO.getSocialCreditCode());
						vo.setSupplierBank(supplierVO.getBankName());
						vo.setSupplierBankAccount(supplierVO.getBankAccount());
						vo.setSupplierLegal(supplierVO.getLegal());
						vo.setSupplierTelephone(supplierVO.getTelephone());
					}
				}
			}
			pageData.setRecords(list);
		}
		return pageData;
	}


	@Override
	public void redundanceData(OutcontractEntity entity) {
		String signDate = null;
		if(entity.getSignDate()!=null){
			signDate = DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSignDate());
		}
		outcontractDisclosureMapper.updateContract(entity.getContractPrice(), signDate, entity.getId());
	}

	@Override
	public void syncYzwContract(Long id) {
		logger.info("00000");
		OutcontractEntity entity = this.selectById(id);
		JSONObject param = new JSONObject();

		String tenderCode = entity.getCalibrationTenderCode();
		/*
		EXECUTION_CONTRACT("EXECUTION_CONTRACT", "招标执行合同"),
				TENDER_FRAMEWORK_PACT("TENDER_FRAMEWORK_PACT", "招标框架协议"),
				TENDER_PURCHASE_CONTRACT("TENDER_PURCHASE_CONTRACT", "招标采购合同"),

				NO_TENDER_EXECUTION_CONTRACT("NO_TENDER_EXECUTION_CONTRACT", "无招标执行合同"),
				FRAMEWORK_PACT("FRAMEWORK_PACT", "无招标框架协议"),
				PURCHASE_CONTRACT("PURCHASE_CONTRACT", "无招标采购合同"),

				PURCHASE_PURCHASE_CONTRACT("PURCHASE_PURCHASE_CONTRACT", "采购合同"),
				PURCHASE_FRAMEWORK_PACT("PURCHASE_FRAMEWORK_PACT", "采购框架协议"),
				PURCHASE_EXECUTION_CONTRACT("PURCHASE_EXECUTION_CONTRACT", "采购执行合同"),*/
		//若合同是框架协议，
		if(StringUtils.isNotBlank(entity.getYzwType())){
			if("采购合同".equals(entity.getYzwType())){
				param.put("categoryCode", "TENDER_PURCHASE_CONTRACT");//合同类型--招标采购合同
			}else if("框架协议".equals(entity.getYzwType())){
				param.put("categoryCode", "TENDER_FRAMEWORK_PACT");//合同类型-招标框架协议
			}else if("执行合同".equals(entity.getYzwType())){
				param.put("categoryCode", "EXECUTION_CONTRACT");//合同类型-招标执行合同
				if(entity.getFrameworkId()==null){
					throw new BusinessException("该执行合同缺少框架协议");
				}
				OutcontractEntity frameworkEntity = this.selectById(entity.getFrameworkId());
				tenderCode = frameworkEntity.getCalibrationTenderCode();
				param.put("frameworkOpenSysNo", frameworkEntity.getYzwOpenContractCode());//框架协议openSysNo编号
				param.put("frameworkSysNo", frameworkEntity.getYzwContractCode());//框架协议雪花id编号
			}
		}else{
			param.put("categoryCode", "TENDER_PURCHASE_CONTRACT");//合同类型-招标采购合同
		}
		//判断是否公共项目
		CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("pl_project");
		Boolean publicProject = false;
		List<String> plProjectName = new ArrayList<>();
		if(defdocResponse.isSuccess() && defdocResponse.getData().size() > 0){
			defdocResponse.getData().forEach(item -> {
				plProjectName.add(item.getName());
			});
		}
		if(plProjectName.contains(entity.getProjectName())){
			publicProject = true;
		}
		BigDecimal amount = new BigDecimal(0);
		CommonResponse<ProjectVO> projectResponse = zjkjProjectApi.queryDetailById(entity.getProjectId());
		ProjectVO projectVO = null;
		if(projectResponse.isSuccess() && projectResponse.getData()!=null){
			projectVO = projectResponse.getData();
		}else{
			throw new BusinessException("未获取到项目信息");
		}
		String yzwProjectCode = projectVO.getYzwProjectCode();
		String yzwUser = projectVO.getYzwUser();
		if(StringUtils.isBlank(yzwProjectCode) && !publicProject){
			throw new BusinessException("项目未关联云筑网数据");
		}
		if(StringUtils.isBlank(yzwUser)){
			throw new BusinessException("项目人员未关联云筑网数据");
		}
		String buildUnit = null;
		if(entity.getBuildUnit()!=null){
			CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getBuildUnit());
			if(orgResponse.isSuccess() && orgResponse.getData()!=null){
				buildUnit = orgResponse.getData().getYzwOrgCode();
				if(StringUtils.isBlank(buildUnit)){
					throw new BusinessException("实施单位未关联云筑网数据");
				}
			}
		}
		String signUnit = null;
		if(entity.getSignUnit()!=null){
			if(entity.getBuildUnit()!=entity.getSignUnit()){
				CommonResponse<OrgVO> orgResponse = orgApi.detailById(entity.getSignUnit());
				if(orgResponse.isSuccess() && orgResponse.getData()!=null){
					signUnit = orgResponse.getData().getYzwOrgCode();
					if(StringUtils.isBlank(signUnit)){
						throw new BusinessException("签约单位未关联云筑网数据");
					}
				}
			}else{
				signUnit = buildUnit;
			}
		}
		String partyBCompanyId = null;
		if(entity.getSupplier()!=null){
			CommonResponse<SupplierVO> supplierResponse = supplierApi.queryById(entity.getSupplier());
			if(supplierResponse.isSuccess() && supplierResponse.getData()!=null){
				partyBCompanyId = supplierResponse.getData().getYzwSupplierCode();
			}
			if(StringUtils.isBlank(partyBCompanyId)){
				throw new BusinessException("供应商未关联云筑网数据");
			}
		}
		Integer systemCategoryId = null;
		Boolean leaseFlag = false;
		if("劳务分包".equals(entity.getType())){
			amount = entity.getSubcontractTotalAmount();
			systemCategoryId = 3;
		}else if("专业分包".equals(entity.getType())){
			amount = entity.getSubcontractTotalAmount();
			systemCategoryId = 4;
		}else if("物资采购".equals(entity.getType())){
			amount = entity.getContractPriceTotalAmount();
			systemCategoryId = 1;
		}else if("机械租赁".equals(entity.getType())){
			amount = entity.getLeaseItemTotalAmount();
			leaseFlag = true;
			systemCategoryId = 2;
		}else if("周转材租赁".equals(entity.getType())){
			systemCategoryId = 1;
			amount = entity.getContractPriceTotalAmount();
			leaseFlag = true;
		}else if("设计勘察".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("咨询服务".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("其它合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}else if("课题支出类合同".equals(entity.getType())){
			amount = entity.getContractPrice();
		}

		param.put("amount", amount);//合同金额
		param.put("createUserId", yzwUser);//创建人Id(项目上配置一个字段，云筑用户id，一个项目固定一个人)
		param.put("currency", "CNY");//币种
		param.put("customNo", entity.getBillCode());//合同编号
		if("物资采购".equals(entity.getType())){
			if(entity.getSignDate()!=null){
				param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getSignDate()));//合同开始日期
			}
			if(projectVO.getEndDate()!=null){
				param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd").format(projectVO.getEndDate()));//合同结束日期
			}else{
				SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
				Calendar calendar = Calendar.getInstance();
				calendar.add(Calendar.YEAR, 1);
				String effectiveEndTime = df1.format(entity.getSignDate());
				param.put("effectiveEndTime", effectiveEndTime);//合同结束日期
			}
		}else{
			if(entity.getMobilizationDate()!=null){
				param.put("effectiveStartTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getMobilizationDate()));//合同开始日期
			}
			if(entity.getExitDate()!=null){
				param.put("effectiveEndTime", new SimpleDateFormat("yyyy-MM-dd").format(entity.getExitDate()));//合同结束日期
			}
		}
		param.put("name", entity.getContractName());//合同名称
		List<String> organizationList = new ArrayList<>();
		organizationList.add(buildUnit);
		param.put("organizationList", organizationList);//实施单位---中建科技在云筑内组织id
		param.put("partyACode", signUnit);//签约单位	中建科技在云筑内组织id
		param.put("partyAManagerId", yzwUser);//甲方经办人Id:项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("partyBCompanyId", partyBCompanyId);//中标供应商的id	供应商	供应商对应的云筑ID
		List<String> projectListId = new ArrayList<>();
		if(publicProject){
			projectListId.add("-1000");
		}else{
			projectListId.add(yzwProjectCode);
		}

		param.put("projectListId", projectListId);//合同项目	项目	项目对应的云筑ID
		param.put("remark", entity.getRemark());//备注
		param.put("systemCategoryId", systemCategoryId);//品类ID
		param.put("settlementAfterInspection", false);//是否收验货后结算
		param.put("signOrgName", entity.getSignUnitName());//甲方名称	签约单位
		if(entity.getSignDate()!=null){
			param.put("signTime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(entity.getSignDate()));//签约日期
		}
		/*
		PREPARATION("PREPARATION", "编制中"),
				UNDER_APPROVAL("UNDER_APPROVAL", "审批中"),
				APPROVED("APPROVED", "审批通过"),
				APPROVAL_FAILED("APPROVAL_FAILED", "审批不通过"),
				CONFIRMING("CONFIRMING", "确认中"),
				CONFIRM_REJECTION("CONFIRM_REJECTION", "确认不通过"),
				CONFIRMED("CONFIRMED", "确认通过"),
				SIGNATURE_APPROVAL("SIGNATURE_APPROVAL", "签章审批中"),
				SIGNATURE_APPROVED("SIGNATURE_APPROVED", "签章审批通过"),
				SIGNATURE_APPROVAL_FAILED("SIGNATURE_APPROVAL_FAILED", "签章审批不通过"),
				SIGNING("SIGNING", "签章中"),
				SIGNATURE_COMPLETED("SIGNATURE_COMPLETED", "签章完成"),
				INVALID_APPROVAL("INVALID_APPROVAL", "作废审批中"),
				INVALID_APPROVAL_FAILED("INVALID_APPROVAL_FAILED", "作废审批不通过"),
				ABOLISHED("ABOLISHED", "已作废"),
				DELETED("DELETED", "已删除"),
				SHELF_ON("SHELF_ON", "已上架"),
				SHELF_OFF("SHELF_OFF", "已下架"),
				TERMINATE_APPROVAL("TERMINATE_APPROVAL", "解除审批中"),
				TERMINATE_APPROVAL_FAILED("TERMINATE_APPROVAL_FAILED", "解除审批不通过"),
				TERMINATING("TERMINATING", "解除中"),
				TERMINATED("TERMINATED", "已解除"),
				ARCHIVED("ARCHIVED", "已归档");*/
		param.put("status", "SHELF_ON");//合同状态	固定值	SHELF_ON=已上架,、已归档
//		param.put("sysNo", entity.getBillCode());//合同编号---变更需要传
		param.put("tenderCode", tenderCode);//云筑招标编号
		param.put("thirdPartyId", entity.getId().toString());//合同ID
		param.put("updateUserId", yzwUser);//创建人Id	项目获取	项目上配置一个字段，云筑用户id，一个项目固定一个人
		param.put("paymentMethod", "INSTALLMENTS");//付款方式 ONE_TIME=一次性付款;INSTALLMENTS=分期付款;OTHER=其它;
		String pricingMethod = null;
		switch (entity.getPricingForm()) {
			case "按建筑面积平米的每平米固定单价":
			case "按实体工程量对应的固定单价":
			case "按承包合同价款让利费率下浮":
			case "固定单价":
			case "可调价格":
				pricingMethod = "UNIT_PRICE";//单价合同
				break;
			case "固定总价":
				pricingMethod = "LUMP_SUM";//总价合同
				break;
			case "定额计价":
			case "其他":
				pricingMethod = "OTHER";//其他形式合同
				break;
		}
		param.put("pricingMethod", pricingMethod);//计价方式 LUMP_SUM=总价合同;UNIT_PRICE=单价合同;COST_PLUS=成本加酬金合同;OTHER=其他形式合同;
		param.put("leaseFlag", leaseFlag);//根据合同类型判断	周材租赁，设备租赁传“是”

//        param.put("majorOpenSysNo", );//主合同openSysNo编号
//        param.put("majorSysNo", );//主合同编号

//        param.put("otherAttachmentList", );//其他附件说明（参数详情见otherAttachmentList）
		param.put("signType", "MAJOR_CONTRACT");//合同签订类型	固定值	MAJOR_CONTRACT主合同，CHANGE_CONTRACT变更合同，SUPPLEMENTARY_PACT补充协议，解除合同
		param.put("signWay", "ONLINE");//签章方式	固定值/签章方式	线上电子签章，OFFLINE线下签章

		JSONArray signedAttachmentList = this.upadteYzwFile(entity.getId(), entity.getType());
        param.put("signedAttachmentList", signedAttachmentList);//已签章附件（参数详情见signedAttachmentList）
		if("劳务分包".equals(entity.getType()) || "专业分包".equals(entity.getType())){
			JSONArray listData = this.dealUnitListData(entity.getOutcontractSubcontractUnitPriceList());
			param.put("listData", listData);//
		}else if("物资采购".equals(entity.getType()) || "周转材租赁".equals(entity.getType())){
			JSONArray listData = this.dealMaterialListData(entity.getOutcontractMaterialList());
			param.put("listData", listData);//
		}else if("机械租赁".equals(entity.getType())){
			JSONArray listData = this.dealEquipmentListRentData(entity.getOutcontractEquipmentRentList());
			param.put("listData", listData);//
		}
		JSONObject result = yzwSyncService.syncContract(param);
		String sysNo = result.getString("sysNo");
		String openSysNo = result.getString("openSysNo");
		entity.setYzwOpenContractCode(openSysNo);
		entity.setYzwContractCode(sysNo);
		this.saveOrUpdate(entity, false);
	}

	@Override
	public JSONArray upadteYzwFile(Long id, String type){
		JSONArray signedAttachmentList = new JSONArray();
		String billType = null;
		String sourceType = "zjkj-outcontract";
		if("劳务分包".equals(type)){
			billType = "BT220105000000001";
		}else if("专业分包".equals(type)){
			billType = "BT220105000000002";
		}else if("物资采购".equals(type)){
			billType = "BT220105000000003";
		}else if("机械租赁".equals(type)){
			billType = "BT220105000000004";
		}else if("周转材租赁".equals(type)){
			billType = "BT220105000000005";
		}else if("设计勘察".equals(type)){
			billType = "BT220105000000006";
		}else if("咨询服务".equals(type)){
			billType = "BT220105000000007";
		}else if("其它合同".equals(type)){
			billType = "BT220105000000008";
		}else if("课题支出类合同".equals(type)){
			billType = "EJCBT202207000040";
		}
		CommonResponse<List<AttachmentVO>> att = attachmentApi.queryListBySourceId(id, billType, sourceType, null);
		if(att.isSuccess() && att.getData()!=null){
			for (AttachmentVO datum : att.getData()) {
				String downloadUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/no_auth/download?fileId="+datum.getId();
				byte[] fileData = null;
				try{
					// 获取文件大小
					URL download = new URL(downloadUrl);
					HttpURLConnection conn = (HttpURLConnection) download.openConnection();
					conn.setRequestMethod("HEAD");
					// 下载文件
					InputStream in = new BufferedInputStream(download.openStream());
					ByteArrayOutputStream out = new ByteArrayOutputStream();
					byte[] buffer = new byte[4096];
					int bytesRead;
					while ((bytesRead = in.read(buffer)) != -1) {
						out.write(buffer, 0, bytesRead);
					}
					fileData = out.toByteArray();
				}catch (Exception e){
					throw new BusinessException("获取文件失败");
				}
				YzwResult<UploadResponse> fssResult = fssClient.upload(datum.getFileName(), fileData, null);
				logger.info(BeanMapper.map(fssResult, JSONObject.class).toJSONString());
				if(fssResult.getCode()==200){
					JSONObject signedAttachment = new JSONObject();
					signedAttachment.put("fileName", datum.getFileName());
					signedAttachment.put("ossUrl", fssResult.getData().getUrl());
					signedAttachment.put("fileSize", datum.getFileSize());
					signedAttachmentList.add(signedAttachment);
				}
			}
		}else{
			throw new BusinessException("未获取到合同签章文件,请先上传附件");
		}
		return signedAttachmentList;
	}

	@Override
	public void syncYzwSign(Long id) {
		OutcontractEntity entity = this.selectById(id);
//		if(entity.getSignType()!=null && "线下签章".equals(entity.getSignType())){
			String billType = null;
			String sourceType = "zjkj-outcontract-yzw-sign";
			if("劳务分包".equals(entity.getType())){
				billType = "BT220105000000001";
			}else if("专业分包".equals(entity.getType())){
				billType = "BT220105000000002";
			}else if("物资采购".equals(entity.getType())){
				billType = "BT220105000000003";
			}else if("机械租赁".equals(entity.getType())){
				billType = "BT220105000000004";
			}else if("周转材租赁".equals(entity.getType())){
				billType = "BT220105000000005";
			}else if("设计勘察".equals(entity.getType())){
				billType = "BT220105000000006";
			}else if("咨询服务".equals(entity.getType())){
				billType = "BT220105000000007";
			}else if("其它合同".equals(entity.getType())){
				billType = "BT220105000000008";
			}else if("课题支出类合同".equals(entity.getType())){
				billType = "EJCBT202207000040";
			}
			CommonResponse<List<AttachmentVO>> att = attachmentApi.queryListBySourceId(entity.getId(), billType, sourceType, null);
			if(att.isSuccess() && att.getData()!=null){
				JSONObject result = yzwSyncService.uploadYzwSign(att.getData().get(0).getId().toString(), entity.getId(), entity.getContractName(), entity.getBillCode());
				String data = result.getString("data");
				entity.setYzwSignCode(data);
				this.saveOrUpdate(entity, false);
			}else{
				throw new BusinessException("未获取到合同签章文件");
			}
//		}else{
//			//获取线上文件
//			if(entity.getFileId()!=null){
//				JSONObject result = yzwSyncService.uploadYzwSign(entity.getFileId().toString(), entity.getId(), entity.getContractName(), entity.getBillCode());
//				String data = result.getString("data");
//				entity.setYzwSignCode(data);
//				this.saveOrUpdate(entity, false);
//			}else{
//				throw new BusinessException("未获取到线上合同签章文件,请先生成文件");
//			}
//		}
	}

	@Override
	public String generateYzwUrl(Long id, String yzwSignCode) {
		return yzwSyncService.generateYzwUrl(id, yzwSignCode);
	}

	private JSONArray dealUnitListData(List<OutcontractSubcontractUnitPriceEntity> unitPriceList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "分包工程综合单价计价清单");
		data.put("source", "yql");
		/*
				OTHER("OTHER", "其它"),
				PRODUCT("PRODUCT", "商品清单"),
				BOQ("BOQ", "工程量清单"),
				CATEGORY_PRODUCT("CATEGORY_PRODUCT", "商品类别+商品清单");*/
		data.put("listType", "BOQ");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0001");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwForeignId","云筑工程量分类id","TEXT",1, false));
		columns.add(this.createColumn("outForeignId","三方工程量分类id","TEXT",1, false));
		columns.add(this.createColumn("listCode","清单编号","TEXT",1, true));
		columns.add(this.createColumn("project","项目","TEXT",2, true));
		columns.add(this.createColumn("jobContent","工作内容","TEXT",3, true));
		columns.add(this.createColumn("projectCharacteristic","项目特征","TEXT",4, true));
		columns.add(this.createColumn("engineeringQuantity","工程量","NUMBER",6, true));
		columns.add(this.createColumn("comprehensiveUnitPrice","综合单价","NUMBER",7, true));
		columns.add(this.createColumn("totalPrice","合计","NUMBER",8, true));
		columns.add(this.createColumn("laborCost","人工费","NUMBER",9, true));
		columns.add(this.createColumn("mainMaterialCost","主材费","NUMBER",10, true));
		columns.add(this.createColumn("materialLoss","材料损耗","NUMBER",11, true));
		columns.add(this.createColumn("auxiliaryMaterialCost","辅材费","NUMBER",12, true));
		columns.add(this.createColumn("machineryCost","机械费","NUMBER",13, true));
		columns.add(this.createColumn("managementCost","管理费","NUMBER",14, true));
		columns.add(this.createColumn("profit","利润","NUMBER",15, true));
		columns.add(this.createColumn("paidGovernmentCost","规费","NUMBER",16, true));
		columns.add(this.createColumn("tax","税金","NUMBER",17, true));
		columns.add(this.createColumn("mainMaterialBrand","主材品牌","TEXT",18, true));
		columns.add(this.createColumn("remark","备注","TEXT",19, true));

		columns.add(this.createColumn("ForeignCode","分部分项项目编码","TEXT",20, false));
		columns.add(this.createColumn("Name","分部分项项目名称","TEXT",20, false));
		columns.add(this.createColumn("Character","分部分项项目特征","TEXT",20, false));
		columns.add(this.createColumn("GCL","工程量","NUMBER",21, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",5, true));
		columns.add(this.createColumn("TaxRate","税率","NUMBER",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("ComUnitPrice","综合单价/含税单价","NUMBER",28, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject par = new JSONObject();
		JSONObject dataValue = new JSONObject();
		dataValue.put("yzwForeignId", yzwForeignId);//先固定值
		par.put("dataValue", dataValue);
		JSONArray chil = new JSONArray();
		if(unitPriceList!=null && unitPriceList.size()>0){
			List<OutcontractSubcontractUnitPriceVO> vos = BeanMapper.mapList(unitPriceList, OutcontractSubcontractUnitPriceVO.class);
			List<OutcontractSubcontractUnitPriceVO> list = createTreeData(vos);
			for (OutcontractSubcontractUnitPriceVO vo : list) {
				JSONObject re = new JSONObject();
				JSONObject ins = dealJson(vo);
				re.put("dataValue", ins);
				chil.add(re);
			}
		}
		par.put("childList", chil);
		instance.add(par);
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	public JSONObject dealJson(OutcontractSubcontractUnitPriceVO vo){
		JSONObject ins = new JSONObject();
		ins.put("GCL", vo.getEngineeringQuantity()!=null?vo.getEngineeringQuantity():0);
		ins.put("Unit", StringUtils.isNotBlank(vo.getUnit())?vo.getUnit():"/");
		ins.put("Character", vo.getProject());
		ins.put("TaxRate", 0);
		ins.put("TaxAmount", 0);
		ins.put("ComUnitPrice", vo.getComprehensiveUnitPrice()!=null?vo.getComprehensiveUnitPrice():0);
		ins.put("ExcludeTaxUnitPrice", vo.getComprehensiveUnitPrice()!=null?vo.getComprehensiveUnitPrice():0);
		ins.put("Valence", vo.getTotalPrice());
		ins.put("ExcludeTaxTotalPrice", vo.getTotalPrice());

		ins.put("listCode", vo.getListCode());
		ins.put("project", vo.getProject());
		ins.put("jobContent", vo.getJobContent());
		ins.put("projectCharacteristic", vo.getProjectCharacteristic());
		ins.put("engineeringQuantity", vo.getEngineeringQuantity());
		ins.put("comprehensiveUnitPrice", vo.getComprehensiveUnitPrice());
		ins.put("totalPrice", vo.getTotalPrice());
		ins.put("laborCost", vo.getLaborCost());
		ins.put("mainMaterialCost", vo.getMainMaterialCost());
		ins.put("materialLoss", vo.getMaterialLoss());
		ins.put("auxiliaryMaterialCost", vo.getAuxiliaryMaterialCost());
		ins.put("machineryCost", vo.getMachineryCost());
		ins.put("profit", vo.getProfit());
		ins.put("paidGovernmentCost", vo.getPaidGovernmentCost());
		ins.put("tax", vo.getTax());
		ins.put("mainMaterialBrand", vo.getMainMaterialBrand());
		ins.put("remark", vo.getRemark());
		if(vo.getChildren()!=null && vo.getChildren().size()>0){
			JSONArray chil = new JSONArray();
			for (OutcontractSubcontractUnitPriceVO cl : vo.getChildren()) {
				JSONObject re = new JSONObject();
				JSONObject in = dealJson(cl);
				re.put("dataValue", in);
				chil.add(re);
			}
			ins.put("childList", chil);
		}
		return ins;
	}

	public List<OutcontractSubcontractUnitPriceVO> createTreeData(List<OutcontractSubcontractUnitPriceVO> list) {
		List<OutcontractSubcontractUnitPriceVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, OutcontractSubcontractUnitPriceVO> listMap = new HashMap<>();
		for(OutcontractSubcontractUnitPriceVO item:list) {
			listMap.put(item.getId().toString(), item);
		}

		for(int i =0; i<list.size(); i++) {
			OutcontractSubcontractUnitPriceVO item = list.get(i);
			String parentId = (item.getPid() != null) ? item.getPid().toString():"";
			OutcontractSubcontractUnitPriceVO parent = listMap.get(parentId);
			if(parent != null) {
				List<OutcontractSubcontractUnitPriceVO> child = (List<OutcontractSubcontractUnitPriceVO>) parent.getChildren();
				if(child != null) {
					child.add(item);
				}else{
					List<OutcontractSubcontractUnitPriceVO> children = new ArrayList<OutcontractSubcontractUnitPriceVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getId().toString());
			}
		}

		for(String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}

	private JSONArray dealMaterialListData(List<OutcontractMaterialEntity> materialList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "物资清单");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0002");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwSkuNo","sku编号","TEXT",1, false));
		columns.add(this.createColumn("CategoryName","商品类别","TEXT",20, false));
		columns.add(this.createColumn("ProductCommonName","商品名称","TEXT",21, false));
		columns.add(this.createColumn("Model","规格型号","TEXT",22, false));
		columns.add(this.createColumn("QuotedBasis","报价依据","TEXT",23, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",25, false));
		columns.add(this.createColumn("TaxRate","税率","TEXT",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("QuotedPrice","含税单价","NUMBER",28, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));

		columns.add(this.createColumn("materialCode","物资编码","TEXT",1, true));
		columns.add(this.createColumn("materialName","标的名称","TEXT",2, true));
		columns.add(this.createColumn("strengthGrade","强度等级","TEXT",3, true));
		columns.add(this.createColumn("materialSpec","规格型号","TEXT",4, true));
		columns.add(this.createColumn("brandTrademark","品牌商标","TEXT",5, true));
		columns.add(this.createColumn("materialUnit","计量单位","TEXT",6, true));
		columns.add(this.createColumn("quantity","暂定数量","NUMBER",7, true));
		columns.add(this.createColumn("untaxUnitPrice","不含税单价","NUMBER",8, true));
		columns.add(this.createColumn("taxUnitPrice","含税单价","NUMBER",10, true));
		columns.add(this.createColumn("totalPrice","合价","NUMBER",11, true));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject dataValue = new JSONObject();

		for (OutcontractMaterialEntity vo : materialList) {
			JSONObject ins = new JSONObject();
			ins.put("yzwSkuNo", vo.getYzwSkuNo());
			ins.put("Model", vo.getMaterialSpec());
			ins.put("QuotedBasis", StringUtils.isNotBlank(vo.getBrandTrademark())?vo.getBrandTrademark():vo.getMaterialName());
			ins.put("Quantity", vo.getQuantity());
			ins.put("TaxRate", vo.getTaxRate());
			ins.put("TaxAmount", 0);
			ins.put("QuotedPrice", vo.getTaxUnitPrice());
			ins.put("ExcludeTaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("Valence", vo.getTotalPrice());
			ins.put("ExcludeTaxTotalPrice", vo.getUntaxUnitPrice().multiply(vo.getQuantity()));

			ins.put("materialCode", vo.getMaterialCode());
			ins.put("materialName", vo.getMaterialName());
			ins.put("strengthGrade", vo.getStrengthGrade());
			ins.put("materialSpec", vo.getMaterialSpec());
			ins.put("brandTrademark", vo.getBrandTrademark());
			ins.put("materialUnit", vo.getMaterialUnit());
			ins.put("quantity", vo.getQuantity());
			ins.put("untaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("taxUnitPrice", vo.getTaxUnitPrice());
			ins.put("totalPrice", vo.getTotalPrice());
			dataValue.put("dataValue", ins);
			instance.add(dataValue);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	private JSONArray dealEquipmentListRentData(List<OutcontractEquipmentRentEntity> outcontractEquipmentRentList) {
		JSONArray listData = new JSONArray();
		JSONObject data = new JSONObject();
		data.put("listName", "租金明细");
		data.put("source", "yql");
		data.put("listType", "PRODUCT");
		data.put("priceTaxSeparation", true);
		data.put("quoteType", "FLOAT");
		data.put("systemCategory", "0003");
		JSONArray columns = new JSONArray();
		columns.add(this.createColumn("yzwSkuNo","sku编号","TEXT",19, false));
		columns.add(this.createColumn("CategoryName","商品类别","TEXT",20, false));
		columns.add(this.createColumn("ProductCommonName","商品名称","TEXT",21, false));
		columns.add(this.createColumn("Model","规格型号","TEXT",22, false));
		columns.add(this.createColumn("QuotedBasis","报价依据","TEXT",23, false));
		columns.add(this.createColumn("Quantity","数量","NUMBER",24, false));
		columns.add(this.createColumn("Unit","单位","TEXT",25, false));
		columns.add(this.createColumn("TaxRate","税率","TEXT",26, false));
		columns.add(this.createColumn("TaxAmount","税额","NUMBER",27, false));
		columns.add(this.createColumn("QuotedPrice","含税单价","NUMBER",28, false));
		columns.add(this.createColumn("ExcludeTaxUnitPrice","不含税单价","NUMBER",29, false));
		columns.add(this.createColumn("Valence","合价","NUMBER",30, false));
		columns.add(this.createColumn("ExcludeTaxTotalPrice","不含税合价","NUMBER",31, false));

		columns.add(this.createColumn("equipmentCode","设备编码","TEXT",1, true));
		columns.add(this.createColumn("equipmentName","设备名称","TEXT",2, true));
		columns.add(this.createColumn("equipmentSpec","规格","TEXT",3, true));
		columns.add(this.createColumn("untaxUnitPrice","不含税单价（元）","NUMBER",4, true));
		columns.add(this.createColumn("taxUnitPrice","含税单价（元）","NUMBER",5, true));
		columns.add(this.createColumn("equipmentUnit","单位","TEXT",6, true));
		columns.add(this.createColumn("quantity","台数","NUMBER",7, true));
		columns.add(this.createColumn("leaseTerm","租赁期（月）","NUMBER",8, true));
		columns.add(this.createColumn("taxRate","税率（%）","NUMBER",9, true));
		columns.add(this.createColumn("totalPrice","合价（元）","NUMBER",10, true));
		columns.add(this.createColumn("remark","备注","TEXT",11, true));
		data.put("columns", columns);

		JSONArray instance = new JSONArray();
		JSONObject dataValue = new JSONObject();
		for (OutcontractEquipmentRentEntity vo : outcontractEquipmentRentList) {
			JSONObject ins = new JSONObject();
			ins.put("yzwSkuNo", vo.getYzwSkuNo());
			ins.put("Model", vo.getEquipmentCode());
			ins.put("QuotedBasis", vo.getEquipmentSpec());
			ins.put("Quantity", vo.getQuantity());
			ins.put("TaxRate", vo.getTaxRate());
			ins.put("TaxAmount", 0);
			ins.put("QuotedPrice", vo.getTaxUnitPrice());
			ins.put("ExcludeTaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("Valence", vo.getTotalPrice());
			ins.put("ExcludeTaxTotalPrice", vo.getUntaxUnitPrice().multiply(new BigDecimal(vo.getQuantity())));

			ins.put("equipmentCode", vo.getEquipmentCode());
			ins.put("equipmentName", vo.getEquipmentName());
			ins.put("equipmentSpec", vo.getEquipmentSpec());
			ins.put("untaxUnitPrice", vo.getUntaxUnitPrice());
			ins.put("taxUnitPrice", vo.getTaxUnitPrice());
			ins.put("equipmentUnit", vo.getEquipmentUnit());
			ins.put("quantity", vo.getQuantity());
			ins.put("leaseTerm", vo.getLeaseTerm());
			ins.put("taxRate", vo.getTaxRate());
			ins.put("totalPrice", vo.getTotalPrice());
			ins.put("remark", vo.getRemark());
			dataValue.put("dataValue", ins);
			instance.add(dataValue);
		}
		data.put("instance", instance);
		listData.add(data);
		return listData;
	}

	private JSONObject createColumn(String columnCode, String columnName, String valueType, Integer sortIndex, Boolean visible){
		JSONObject column = new JSONObject();
		column.put("columnCode", columnCode);
		column.put("columnName", columnName);
		column.put("valueType", valueType);
		column.put("sortIndex", sortIndex);
		column.put("requiredEnable", false);
		column.put("editEnable", false);
		column.put("visible", visible);
		return column;
	}

}
