package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.PutawayDetailEntity;
import com.ejianc.business.panhuo.bean.PutawayEntity;
import com.ejianc.business.panhuo.service.IPutawayService;
import com.ejianc.business.panhuo.vo.PutawayVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 批量上架
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("putaway")
public class PutawayController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PUTAWAY";//此处需要根据实际修改

    @Autowired
    private IPutawayService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PutawayVO> saveOrUpdate(@RequestBody PutawayVO saveOrUpdateVO) {
    	PutawayEntity entity = BeanMapper.map(saveOrUpdateVO, PutawayEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<PutawayDetailEntity> putawayDetailList = entity.getPutawayDetailList();
    	if (CollectionUtils.isNotEmpty(putawayDetailList)){
            String materialNames = putawayDetailList.stream().map(PutawayDetailEntity::getMaterialName).collect(Collectors.joining(","));
            entity.setMaterialNames(materialNames);
            BigDecimal sumShelfMny = putawayDetailList.stream().map(PutawayDetailEntity::getShelfMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setSumShelfMny(sumShelfMny);
        }
        service.saveOrUpdate(entity, false);
    	PutawayVO vo = BeanMapper.map(entity, PutawayVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PutawayVO> queryDetail(Long id) {
    	PutawayEntity entity = service.selectById(id);
        List<PutawayDetailEntity> putawayDetailList = entity.getPutawayDetailList();
        //处理子表附件信息
//        if (CollectionUtils.isNotEmpty(putawayDetailList)){
//            List<Long> attachIds = putawayDetailList.stream().map(PutawayDetailEntity::getId).collect(Collectors.toList());
//            Map<String, List<Long>> map = new HashMap<>();
//            map.put("sourceIds",attachIds);
//            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
//            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
//            if (listCommonResponse.isSuccess()){
//                List<AttachmentVO> data = listCommonResponse.getData();
//                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, List<AttachmentVO>> attacMap = data.stream().
//                            collect(Collectors.groupingBy(AttachmentVO::getSourceId));
//                    for (PutawayDetailEntity putawayDetail : putawayDetailList){
//                        List<AttachmentVO> attachmentVOList = attacMap.get(putawayDetail.getId());
//                        if(CollectionUtils.isNotEmpty(attachmentVOList)){
//                            List<Long> attachId = attachmentVOList.stream().map(AttachmentVO::getId).collect(Collectors.toList());
//                            putawayDetail.setAttachIds(attachId);
//                            putawayDetail.setAttachIds(attachId);
//                        }
//                    }
//                }
//            }
//        }

    	PutawayVO vo = BeanMapper.map(entity, PutawayVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PutawayVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PutawayVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PutawayVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PutawayVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("phone");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        Long orgId = null;
        //移动端查询
        if(param.getParams().containsKey("orgId")){
            Object orgId1 = param.getParams().get("orgId").getValue();
            orgId = Long.valueOf(String.valueOf(orgId1));
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");

        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });

        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PutawayEntity> page = service.queryPage(param,false);
        IPage<PutawayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PutawayVO> putawayVOS = BeanMapper.mapList(page.getRecords(), PutawayVO.class);
        putawayVOS.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        pageData.setRecords(putawayVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("phone");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PutawayEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        list.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        beans.put("records", list);
        ExcelExport.getInstance().export("putawayExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPutawayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PutawayVO>> refPutawayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PutawayEntity> page = service.queryPage(param,false);
        IPage<PutawayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PutawayVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
