package com.ejianc.business.panhuo.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.PutawayVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 资产表
 *
 * @author generator
 *
 */
public interface IGoodsService extends IBaseService<GoodsEntity> {

    GoodsVO saveGoods(GoodsVO vo);

    GoodsDetailsVO queryGoodsDetail(Long id);

    List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper,String lon,String lat);

    ReportVO orgStatistics(Long orgId);

    List<ReportVO> periodStatistics(List<Long> commonOrgIds);

    List<ReportVO> proportion(List<Long> commonOrgIds,int type);

    CommonResponse<Map<String, BigDecimal>> queryIdleGoods(String range, String dateIn, Long orgId);

    GoodsVO updateStatus(GoodsVO saveorUpdateVO);
}
