package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.util.DateFormater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.WbuyVO;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("wbuy")
public class WbuyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWbuyService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WbuyVO> saveOrUpdate(@RequestBody WbuyVO saveorUpdateVO) {
    	WbuyEntity entity = BeanMapper.map(saveorUpdateVO, WbuyEntity.class);
    	service.saveOrUpdate(entity, false);
    	WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        return CommonResponse.success("操作成功！",service.saveWbuy(saveorUpdateVO));
    }

    /**
     * @Description updateStatus 停止求购
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WbuyVO> updateStatus(@RequestBody WbuyVO saveorUpdateVO) {
        WbuyEntity entity = service.selectById(saveorUpdateVO.getId());
        entity.setStatus(2);
        entity.setCloseType(0);
        entity.setEndbuyTime(DateFormater.getCurrentDate());
        entity.setCloser(Long.parseLong(InvocationInfoProxy.getEmployeeId()));
        service.saveOrUpdate(entity, false);
        WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        return CommonResponse.success("操作成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WbuyVO> queryDetail(Long id) {
    	WbuyEntity entity = service.selectById(id);
    	WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WbuyVO> vos) {
        service.removeByIds(vos.stream().map(WbuyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的求购-求购中列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的求购-已关闭列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的求购-暂存列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyTemp(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
