package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private static final String PANHUO_DD = "PANHUO_DD";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IGoodsService goodsService;

    @Override
    public OrderVO saveOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        OrderEntity orderEntity = BeanMapper.map(vo,OrderEntity.class);
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);//待确认
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        if(null!=vo&&StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_DD,tenantId);
            if(billCode.isSuccess()) {
                orderEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        BigDecimal nums = goodsEntity.getNums()==null?BigDecimal.ZERO:goodsEntity.getNums();
//        BigDecimal sellNums = goodsEntity.getSellNums()==null?BigDecimal.ZERO:goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
        BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
        goodsEntity.setPreNums(preNums.add(vo.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.subtract(vo.getOrdernums()));
        goodsService.saveOrUpdate(goodsEntity,false);

        super.saveOrUpdate(orderEntity, false);
        OrderVO resvo = BeanMapper.map(orderEntity, OrderVO.class);
        return resvo;
    }
}
