package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.vo.AddressVO;

/**
 * 地址管理
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("address")
public class AddressController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IAddressService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AddressVO> saveOrUpdate(@RequestBody AddressVO saveorUpdateVO) {
    	AddressEntity entity = BeanMapper.map(saveorUpdateVO, AddressEntity.class);
        entity.setUserId(InvocationInfoProxy.getUserid());
    	service.saveOrUpdate(entity, false);
    	AddressVO vo = BeanMapper.map(entity, AddressVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AddressVO> queryDetail(Long id) {
    	AddressEntity entity = service.selectById(id);
    	AddressVO vo = BeanMapper.map(entity, AddressVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AddressVO> vos) {
        service.removeByIds(vos.stream().map(AddressVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AddressVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        IPage<AddressEntity> page = service.queryPage(param,false);
        IPage<AddressVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AddressVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 地址参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/addressRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AddressVO>> addressRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("address");
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<AddressEntity> pageData = service.queryPage(queryParam,false);
        IPage<AddressVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), AddressVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }
}
