package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.panhuo.mapper.WbuyMapper;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.IWbuyService;

import java.util.List;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
@Service("wbuyService")
public class WbuyServiceImpl extends BaseServiceImpl<WbuyMapper, WbuyEntity> implements IWbuyService{

    private static final String PANHUO_QG = "PANHUO_QG";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public WbuyVO saveWbuy(WbuyVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WbuyEntity entity = BeanMapper.map(vo, WbuyEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_QG,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<ImgdetailVO> list = vo.getImgsPath();
        if(CollectionUtils.isNotEmpty(list)){
            entity.setMainimgPath(list.get(0).getThumpath());
        }

        super.saveOrUpdate(entity, false);
        WbuyVO resvo = BeanMapper.map(entity, WbuyVO.class);
        return resvo;
    }
}
