/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderService service;
    @Autowired
    private IGoodsService goodsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        this.service.saveOrder(saveorUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/confirmerOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        this.service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateBuyStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelType(0);
        entity.setCancelTime(DateFormater.getCurrentDate());
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
        BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
        goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateSellStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelType(1);
        entity.setCancelTime(DateFormater.getCurrentDate());
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
        BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
        goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

