package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderVO;

import javax.servlet.http.HttpServletRequest;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("order")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOrderService service;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 买家下单
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        service.saveOrder(saveorUpdateVO);
    	return CommonResponse.success("操作成功！");
    }

    /**
     * @Description saveOrUpdate 卖家确认订单
     */
    @RequestMapping(value = "/confirmerOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity entity = service.selectById(id);
    	OrderVO vo = BeanMapper.map(entity, OrderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询我的购买-预定中
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-待处理
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description updateStatus 买家取消订单
     */
    @RequestMapping(value = "/updateBuyStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,entity.getId());
            List<OrderEntity> list= service.list(lambdachange);
            if(null==list||list.size()<=0){
                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }else{
                // to do 还原金额
                BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
            }
        }else{
            // to do 还原金额
            BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
        }

        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(0);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        goodsService.saveOrUpdate(goodsEntity,false);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description updateStatus 卖家取消订单
     */
    @RequestMapping(value = "/updateSellStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,entity.getId());
            List<OrderEntity> list= service.list(lambdachange);
            if(null==list||list.size()<=0){
                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }else{
                // to do 还原金额
                BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
            }
        }else{
            // to do 还原金额
            BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
        }
        goodsService.saveOrUpdate(goodsEntity,false);
        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(1);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description closeOrder 定时关闭到期订单
     */
    @RequestMapping(value = "/closeOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse closeOrder(HttpServletRequest request) {
        String day = request.getParameter("day");
        logger.debug("参数----"+day);
        if(StringUtils.isNotEmpty(day)){
            //获取求购到期数据
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.lt(OrderEntity::getBuyTime, DateFormater.getInstance().setDay(Integer.parseInt(day)));
            lambdachange.eq(OrderEntity::getType, 0);
            List<OrderEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.debug("开始循环设置----"+list.size());
                list.forEach(entity -> {
                    entity.setType(2); //0-待确认，1-已完成，2-订单取消
                    entity.setCancel("99999");//下架类型0-手动下架，1-售罄下架，2-到期下架
                    entity.setCancelName("到期自动取消");
                    entity.setCancelType(2);//取消类型，0=买家，1=卖家，2-超时
                    entity.setCancelTime(DateFormater.getCurrentDate());
                });
                service.updateBatchById(list);
            }
        }
        return CommonResponse.success("运行成功！");
    }
}
