package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
@Service("goodsService")
public class GoodsServiceImpl extends BaseServiceImpl<GoodsMapper, GoodsEntity> implements IGoodsService{

    private static final String PANHUO_ZC = "PANHUO_ZC";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IImgdetailService imgdetailService;

    @Autowired
    private ILabeldetailService labeldetailService;

    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = BeanMapper.map(vo, GoodsEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(vo.getId() != null && vo.getId() > 0){
            //修改
            List<ImgdetailVO> list = vo.getImgsPath();
            if(CollectionUtils.isNotEmpty(list)){
                entity.setMainimgPath(list.get(0).getThumpath());
            }
            QueryWrapper imgWrapper = new QueryWrapper();
            imgWrapper.eq("source_id",vo.getId());
            imgdetailService.remove(imgWrapper);

            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq("source_id",vo.getId());
            labeldetailService.remove(labekWrapper);

        }else{
            if(0==vo.getStatus()){
                entity.setShelfTime(DateFormater.getCurrentDate());
            }
            //资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
            if("1".equals(vo.getShelfType())){
                //机具需要生成机具主键，为后续记录周转记录用
                long toolId=System.currentTimeMillis();
                entity.setToolId(toolId);
            }
            //将第一张图片缩略图设置为主图
            List<ImgdetailVO> list = vo.getImgsPath();
            if(CollectionUtils.isNotEmpty(list)){
                entity.setMainimgPath(list.get(0).getThumpath());
            }
        }
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate(entity, false);
        GoodsVO resvo = BeanMapper.map(entity, GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = super.selectById(id);
        GoodsDetailsVO vo = BeanMapper.map(entity, GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        //获取项目其他在售
        LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange.eq(GoodsEntity::getProjectId,entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus,0);
        lambdachange.ne(GoodsEntity::getId,id);
        int nums = super.count(lambdachange);

        LambdaQueryWrapper<GoodsEntity> lambdachange2 = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange2.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId,entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus,0);
        lambdachange2.ne(GoodsEntity::getId,id);
        lambdachange2.last("limit 3");
        List<GoodsEntity> list = super.list(lambdachange2);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setOthersGoods(BeanMapper.mapList(list,GoodsVO.class));
            vo.setOtherNums(nums);
        }
        //如果是机具，需要获取机具周转记录
        //资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
        if("1".equals(entity.getShelfType())){
            List<GoodsToolVO> listtools = new ArrayList<>();
            GoodsToolVO toolVO = BeanMapper.map(entity,GoodsToolVO.class);
            toolVO.setDealrTime(entity.getShelfTime());
            toolVO.setName("采购入库");
            listtools.add(toolVO);
            //发生周转，本次资产状态为下架，下架类型为售罄
            if(1==entity.getStatus()&&1==entity.getLowerType()){
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
                queryParam.getParams().put("tool_id", new Parameter(QueryParam.EQ,entity.getToolId()));
                queryParam.getParams().put("type", new Parameter(QueryParam.EQ,1));
                queryParam.getOrderMap().put("dealr_time",QueryParam.DESC);
                List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
                if(CollectionUtils.isNotEmpty(listOrder)){
                    List<GoodsToolVO> tools = BeanMapper.mapList(listOrder,GoodsToolVO.class);
                    tools.forEach(e -> {
                        e.setName("周转入库");
                    });
                    listtools.addAll(tools);
                }
            }
            vo.setToolDetails(listtools);
        }

        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper,String lon,String lat) {
        return baseMapper.getGoods(pages,queryWrapper,lon,lat);
    }
}
