/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ImgdetailEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.mapper.WbuyMapper;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wbuyService")
public class WbuyServiceImpl
extends BaseServiceImpl<WbuyMapper, WbuyEntity>
implements IWbuyService {
    private static final String PANHUO_QG = "PANHUO_QG";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IImgdetailService imgdetailService;
    @Autowired
    private ILabeldetailService labeldetailService;

    @Override
    public WbuyVO saveWbuy(WbuyVO vo) {
        List<ImgdetailEntity> list;
        Long tenantId = InvocationInfoProxy.getTenantid();
        WbuyEntity entity = (WbuyEntity)((Object)BeanMapper.map((Object)vo, WbuyEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_QG, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != vo.getId() && vo.getId() > 0L) {
            list = entity.getImgsPath();
            List<LabeldetailEntity> listlb = entity.getLabels();
            entity.setMainimgPath(null);
            QueryWrapper imgWrapper = new QueryWrapper();
            imgWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.imgdetailService.remove((Wrapper)imgWrapper);
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                entity.setMainimgPath(list.get(0).getThumpath());
                list.forEach(e -> e.setId(null));
            }
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = vo.getImgsPath()))) {
            entity.setMainimgPath(((ImgdetailVO)list.get(0)).getThumpath());
        }
        entity.setBuyTime(DateFormater.getCurrentDate());
        super.saveOrUpdate((Object)entity, false);
        WbuyVO resvo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        return resvo;
    }

    @Override
    public List<WbuyEntity> queryWbuy(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((WbuyMapper)this.baseMapper).getWbuy(pages, queryWrapper, lon, lat);
    }
}

