/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.ImgdetailEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsToolVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsService")
public class GoodsServiceImpl
extends BaseServiceImpl<GoodsMapper, GoodsEntity>
implements IGoodsService {
    private static final String PANHUO_ZC = "PANHUO_ZC";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IImgdetailService imgdetailService;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;

    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        List<ImgdetailEntity> list;
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)vo, GoodsEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (vo.getId() != null && vo.getId() > 0L) {
            list = entity.getImgsPath();
            List<LabeldetailEntity> listlb = entity.getLabels();
            entity.setMainimgPath(null);
            QueryWrapper imgWrapper = new QueryWrapper();
            imgWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.imgdetailService.remove((Wrapper)imgWrapper);
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(list)) {
                list.forEach(e -> e.setId(null));
            }
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = vo.getImgsPath()))) {
            entity.setMainimgPath(((ImgdetailVO)list.get(0)).getThumpath());
        }
        if ("1".equals(vo.getShelfType()) && (null == vo.getToolId() || vo.getToolId() <= 0L)) {
            long toolId = System.currentTimeMillis();
            entity.setToolId(toolId);
            entity.setType(0);
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate((Object)entity, false);
        GoodsVO resvo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)super.selectById((Serializable)id));
        GoodsDetailsVO vo = (GoodsDetailsVO)BeanMapper.map((Object)((Object)entity), GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange.gt(GoodsEntity::getRotatableNums, (Object)0);
        int nums = super.count((Wrapper)lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId, (Object)entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, (Object)0);
        lambdachange2.ne(BaseEntity::getId, (Object)id);
        lambdachange2.gt(GoodsEntity::getRotatableNums, (Object)0);
        lambdachange2.last("limit 3");
        List list = super.list((Wrapper)lambdachange2);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setOthersGoods(BeanMapper.mapList((Iterable)list, GoodsVO.class));
        }
        if ("1".equals(entity.getShelfType())) {
            LambdaQueryWrapper lambdachange3 = Wrappers.lambdaQuery();
            lambdachange3.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdachange3.eq(GoodsEntity::getToolId, (Object)entity.getToolId());
            lambdachange3.orderBy(false, true, (Object[])new SFunction[]{GoodsEntity::getShelfTime});
            List listgoods = super.list((Wrapper)lambdachange3);
            ArrayList<GoodsToolVO> listtools = new ArrayList<GoodsToolVO>();
            GoodsToolVO toolVO = (GoodsToolVO)BeanMapper.map(listgoods.get(0), GoodsToolVO.class);
            toolVO.setDealrTime(((GoodsEntity)((Object)listgoods.get(0))).getShelfTime());
            toolVO.setName("\u8d44\u4ea7\u4e0a\u67b6");
            listtools.add(toolVO);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("tool_id", new Parameter("eq", (Object)entity.getToolId()));
            queryParam.getParams().put("type", new Parameter("eq", (Object)1));
            queryParam.getOrderMap().put("dealr_time", "asc");
            List listOrder = this.orderService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)listOrder)) {
                listOrder.forEach(e -> {
                    GoodsToolVO toolVo = new GoodsToolVO();
                    toolVo.setName("\u5468\u8f6c\u5165\u5e93");
                    toolVo.setProjectName(e.getBuyProjectName());
                    toolVo.setDealrTime(e.getDealrTime());
                    toolVo.setToolId(e.getToolId());
                    listtools.add(toolVo);
                });
            }
            vo.setToolDetails(listtools);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)0));
        List listc = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listc)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)listc.get(0))).getId());
        } else {
            vo.setIsCollect(Integer.valueOf(0));
        }
        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((GoodsMapper)this.baseMapper).getGoods(pages, queryWrapper, lon, lat);
    }
}

