package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.WbuyVO;

import javax.servlet.http.HttpServletRequest;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 求购实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("wbuy")
public class WbuyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IWbuyService service;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String baseHost;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WbuyVO> saveOrUpdate(@RequestBody WbuyVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！",service.saveWbuy(saveorUpdateVO));
    }

    /**
     * @Description updateMainimgPath 修改主图
     */
    @RequestMapping(value = "/updateMainimgPath", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody WbuyVO saveorUpdateVO) {
        LambdaUpdateWrapper<WbuyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(WbuyEntity::getId,saveorUpdateVO.getId());
        updateWrapper.set(WbuyEntity::getMainimgPath,saveorUpdateVO.getMainimgPath());
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description updateStatus 停止求购
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WbuyVO> updateStatus(@RequestBody WbuyVO saveorUpdateVO) {
        WbuyEntity entity = service.selectById(saveorUpdateVO.getId());
        entity.setStatus(1);
        entity.setCloseType(0);
        entity.setEndbuyTime(DateFormater.getCurrentDate());
        entity.setCloser(InvocationInfoProxy.getUserid());
        service.saveOrUpdate(entity, false);
        WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        return CommonResponse.success("操作成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WbuyVO> queryDetail(Long id) {
    	WbuyEntity entity = service.selectById(id);
    	WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("user_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,1));
        List<CollectEntity> list= collectService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setIsCollect(1);
            vo.setCollectId(list.get(0).getId());
        }else{
            vo.setIsCollect(0);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 再次求购
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WbuyVO> queryCopyDetail(Long id) {
        WbuyEntity entity = service.selectById(id);
        WbuyVO vo = BeanMapper.map(entity, WbuyVO.class);
        vo.setId(null);
        vo.setCloser(null);
        vo.setCloseType(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
            vo.getImgsPath().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getLabels())){
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getMaterialDetails())){
            vo.getMaterialDetails().forEach(e -> {
                e.setWbuyId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WbuyVO> vos) {
        service.removeByIds(vos.stream().map(WbuyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        Parameter lon = param.getParams().get("lon");
        Parameter lat = param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        if(null!=lon&&null!=lat){
            Page<WbuyEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = changeToQueryWrapper(param);
            List<WbuyEntity> list = service.queryWbuy(page,wrapper,lon.getValue()+"",lat.getValue()+"");
            res.put("records", BeanMapper.mapList(list,WbuyVO.class));
            res.put("total", page.getTotal());
            res.put("current", page.getCurrent());
            res.put("size", page.getSize());
            res.put("pages", page.getPages());
        }else{
            IPage<WbuyEntity> page = service.queryPage(param,false);
            res.put("records", BeanMapper.mapList(page.getRecords(), WbuyVO.class));
            res.put("total", page.getTotal());
            res.put("current", page.getCurrent());
            res.put("size", page.getSize());
            res.put("pages", page.getPages());
        }

        return CommonResponse.success("查询列表数据成功！",res);
    }

    /**
     * @Description queryList 查询我的求购-求购中列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("buyer");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的求购-已关闭列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 1));
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("buyer");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的求购-暂存列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWbuyTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyTemp(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("buyer");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("buyer", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<WbuyEntity> page = service.queryPage(param,false);
        IPage<WbuyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WbuyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description shelfWbuy 定时下架到期求购
     */
    @RequestMapping(value = "/shelfWbuy", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse shelfWbuy(HttpServletRequest request) {
        logger.debug("开始----");
        //获取求购到期数据
        LambdaQueryWrapper<WbuyEntity> lambdachange = Wrappers.<WbuyEntity>lambdaQuery();
        lambdachange.lt(WbuyEntity::getEndDate, DateFormater.getInstance(new Date()).format(DateFormater.SHORT_FORMAT));
        lambdachange.eq(WbuyEntity::getStatus, 0);
        List<WbuyEntity> list= service.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            Map<Long,List<WbuyEntity>> map = new HashMap<>();
            logger.debug("开始循环设置----"+list.size());
            list.forEach(e -> {
                e.setStatus(1);//关闭
                e.setCloser(99999L);//系统默认
                e.setCloseType(1);//到期关闭
                e.setEndbuyTime(DateFormater.getCurrentDate());
                //为发消息做准备
                if(map.containsKey(e.getBuyer())){
                    map.get(e.getBuyer()).add(e);
                }else{
                    List<WbuyEntity> listWbuy = new ArrayList<>();
                    listWbuy.add(e);
                    map.put(e.getBuyer(),listWbuy);
                }
            });
            for(Map.Entry<Long,List<WbuyEntity>> entry : map.entrySet()){
                // TO DO 定时到期下架消息发送
                List<String> messageType = new ArrayList<>();
                messageType.add("sys");
                List<String> sender = new ArrayList<>();
                sender.add(entry.getKey()+"");
                logger.info("发送信息给发布人:>----------" + sender);
                String formurl = baseHost+"ejc-panhuo-frontend/#/buyingManagement?activeKey=2&isMyWbuy=0&endbuyTime="+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                String subject = "您发布的求购信息有【"+entry.getValue().size()+"】条今日到期已自动关闭";
                String content = "您发布的求购信息有【"+entry.getValue().size()+"】条今日到期已自动关闭。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                this.sendMsg(messageType, sender, "notice", subject, content);
            }
            service.updateBatchById(list);
        }
        return CommonResponse.success("运行成功！");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
