package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ParamVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderVO;

import javax.servlet.http.HttpServletRequest;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("order")
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOrderService service;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IAddressService addressService;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * @Description saveOrUpdate 买家下单
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
    	return CommonResponse.success("操作成功！",service.saveOrder(saveorUpdateVO).getId()+"");
    }

    /**
     * @Description saveOrUpdate 卖家确认订单
     */
    @RequestMapping(value = "/confirmerOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
    	OrderEntity orderEntity = service.selectById(id);
        GoodsEntity goodsEntity = goodsService.selectById(orderEntity.getGoodsId());
    	OrderVO vo = BeanMapper.map(orderEntity, OrderVO.class);
    	vo.setRemainingNums(goodsEntity.getRemainingNums());
    	vo.setRotatableNums(goodsEntity.getRotatableNums());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 周转上架
     * @param id
     */
    @RequestMapping(value = "/queryShelfDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryShelfDetail(Long id) {
        OrderEntity orderEntity = service.selectById(id);
        GoodsEntity entity = goodsService.selectById(orderEntity.getGoodsId());
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);


        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("status", new Parameter(QueryParam.EQ,0));//在售，说明已点过周转上架，并且在售
        List<GoodsEntity> listGoods = goodsService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listGoods)&&listGoods.size()>0){
            throw new BusinessException("该机具已周转上架，不可重复上架");
        }

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam2.getParams().put("status", new Parameter(QueryParam.EQ,1));//下架
        queryParam2.getParams().put("lowerType", new Parameter(QueryParam.EQ,1));//售罄下架，说明该机具已到别处项目，不可周转
        List<GoodsEntity> listGoods2 = goodsService.queryList(queryParam2,false);
        if(CollectionUtils.isNotEmpty(listGoods2)&&listGoods2.size()>0){
            throw new BusinessException("该机具已周转完成，不可周转");
        }
        vo.setId(IdWorker.getId());
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setPrice(null);
        vo.setDiscount(null);

        vo.setOriginalprice(orderEntity.getPrice());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRemainingNums(entity.getNums());
        vo.setRotatableNums(entity.getNums());

        vo.setType(1);
        vo.setOrderId(id);
        //周转上架需带出买方地址
        AddressEntity addressEntity = addressService.getById(orderEntity.getBuyAddressId());

        vo.setAddressId(addressEntity.getId());
        vo.setAddress(addressEntity.getAddress());
        vo.setAddressName(addressEntity.getProjectName());
        vo.setProjectAddress(addressEntity.getProjectAddress());
        vo.setPhone(addressEntity.getPhone());
        vo.setName(addressEntity.getName());
        vo.setLat(addressEntity.getLat());
        vo.setLon(addressEntity.getLon());
        vo.setFirstLocation(addressEntity.getFirstLocation());
        vo.setSecondLocation(addressEntity.getSecondLocation());
        vo.setThirdLocation(addressEntity.getThirdLocation());
        vo.setFourthLocation(addressEntity.getFourthLocation());
        vo.setLocation(addressEntity.getLocation());

        vo.setProjectId(addressEntity.getProjectId());
        vo.setProjectName(addressEntity.getProjectName());
        vo.setOrgId(addressEntity.getOrgId());
        vo.setOrgName(addressEntity.getOrgName());


//        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
//            vo.getImgsPath().forEach(e -> {
//                e.setSourceId(null);
//                e.setRowState("add");
//            });
//        }
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                entity.getId().toString(),
                "BT200813000000001",
                "imgUpload",
                vo.getId().toString(),
                "BT200813000000001",
                "imgUpload"
        );
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        if(CollectionUtils.isNotEmpty(vo.getLabels())){
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 校验是否可周转
     * @Param
     */
    @RequestMapping(value = "/checkTurnover", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkTurnover(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("status", new Parameter(QueryParam.EQ,0));//在售，说明已点过周转上架，并且在售
        List<GoodsEntity> listGoods = goodsService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listGoods)&&listGoods.size()>0){
            return CommonResponse.error(5001,"该机具已周转上架，不可重复上架！");
        }

        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter(QueryParam.EQ,id));
        queryParam2.getParams().put("status", new Parameter(QueryParam.EQ,1));//下架
        queryParam2.getParams().put("lowerType", new Parameter(QueryParam.EQ,1));//售罄下架，说明该机具已到别处项目，不可周转
        List<GoodsEntity> listGoods2 = goodsService.queryList(queryParam2,false);
        if(CollectionUtils.isNotEmpty(listGoods2)&&listGoods2.size()>0){
            return CommonResponse.error(5001,"该机具已周转完成，不可周转！");
        }
        return CommonResponse.success("校验成功！");
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        service.removeByIds(vos.stream().map(OrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询我的购买-预定中
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("orderUserId");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("orderUserId");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的购买-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMyOrderFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        Parameter isMyOrder = param.getParams().get("isMyOrder");
        if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")&&isMyOrder.getValue().toString().contains("1")){
            param.getParams().remove("orderUserId");
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().put("orderUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyOrder&&isMyOrder.getValue().toString().contains("0")){
            param.getParams().remove("orderUserId");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("buyOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-待处理
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));//0-待确认，1-已完成，2-订单取消
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-已取消
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 2));//0-待确认，1-已完成，2-订单取消
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询我的出售-已完成
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryMySellFinish", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter(QueryParam.EQ, 1));//0-待确认，1-已完成，2-订单取消
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")&&isMyGoods.getValue().toString().contains("1")){
            param.getParams().remove("seller");
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        }else if(null!=isMyGoods&&isMyGoods.getValue().toString().contains("0")){
            param.getParams().remove("seller");
        }
        param.getParams().remove("isMyGoods");
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("sellOrg", new Parameter(QueryParam.IN, childIds));
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description updateStatus 买家取消订单
     */
    @RequestMapping(value = "/updateBuyStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
        if(entity.getVersion()!=saveorUpdateVO.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,entity.getId());
            List<OrderEntity> list= service.list(lambdachange);
            if(null==list||list.size()<=0){
                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }else{
                // to do 还原金额
                BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
            }
        }else{
            // to do 还原金额
            BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
        }

        // TO DO 确认订单消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(entity.getSeller()+"");//发布人
        logger.info("发送信息给发布人:>----------" + sender);
        String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
        String subject = "您的订单【"+entity.getBillCode()+"】已被买家取消";
        String content = "您的订单【"+entity.getBillCode()+"】已被买家取消。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        service.sendMsg(messageType, sender, "notice", subject, content);


        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(0);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        goodsService.saveOrUpdate(goodsEntity,false);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description updateStatus 卖家取消订单
     */
    @RequestMapping(value = "/updateSellStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = service.selectById(saveorUpdateVO.getId());
        if(entity.getVersion()!=saveorUpdateVO.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,entity.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,entity.getId());
            List<OrderEntity> list= service.list(lambdachange);
            if(null==list||list.size()<=0){
                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }else{
                // to do 还原金额
                BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

                goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
            }
        }else{
            // to do 还原金额
            BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
            BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();

            goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
            goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
        }

        // TO DO 确认订单消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(entity.getOrderUserId()+"");//预定人
        logger.info("发送信息给预定人:>----------" + sender);
        String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
        String subject = "您的订单【"+entity.getBillCode()+"】已被卖家取消";
        String content = "您的订单【"+entity.getBillCode()+"】已被卖家取消。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        service.sendMsg(messageType, sender, "notice", subject, content);

        goodsService.saveOrUpdate(goodsEntity,false);
        entity.setType(2); //0-待确认，1-已完成，2-订单取消
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(sessionManager.getUserContext().getUserName());
        entity.setCancelType(1);//取消类型，0=买家，1=卖家，2-超时
        entity.setCancelTime(DateFormater.getCurrentDate());

        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description closeOrder 定时关闭到期订单
     */
    @RequestMapping(value = "/closeOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse closeOrder(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param );
        logger.info("获取到的参数JSON是："+param+"----");
        int hour = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是："+hour+"----");
        if(hour>0){
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.HOUR_OF_DAY, calendar.get(Calendar.HOUR_OF_DAY) - hour);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取求购到期数据
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.le(OrderEntity::getBuyTime, df.format(calendar.getTime()));
            lambdachange.eq(OrderEntity::getType, 0);
            List<OrderEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("开始循环设置----"+list.size());
                Map<Long,List<OrderEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    entity.setType(2); //0-待确认，1-已完成，2-订单取消
                    entity.setCancel("99999");//下架类型0-手动下架，1-售罄下架，2-到期下架
                    entity.setCancelName("到期自动取消");
                    entity.setCancelType(2);//取消类型，0=买家，1=卖家，2-超时
                    entity.setCancelTime(DateFormater.getCurrentDate());

                    GoodsEntity goodsEntity = goodsService.selectById(entity.getGoodsId());
                    // to do 还原金额
                    BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                    BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
                    goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));//预定中
                    goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));//可周转
                    goodsService.updateById(goodsEntity);

                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    List<String> sender = new ArrayList<>();
                    sender.add(entity.getSeller()+"");
                    logger.info("发送信息给发布人和预订人:>----------" + sender);
                    String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+entity.getId()+"&type=3";
                    String subject = "您的订单【"+entity.getBillCode()+"】到期未确认，已失效";
                    String content = "您的订单【"+entity.getBillCode()+"】到期未确认，已失效。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content);


                    List<String> messageType2 = new ArrayList<>();
                    messageType2.add("sys");
                    List<String> sender2 = new ArrayList<>();
                    sender2.add(entity.getOrderUserId()+"");
                    logger.info("发送信息给发布人和预订人:>----------" + sender2);
                    String formurl2 = "https://dev.17elian.com/ejc-panhuo-frontend/#/assetMarket/orderMarket?id="+entity.getId();
                    String subject2 = "您的订单【"+entity.getBillCode()+"】卖家未及时确认已取消";
                    String content2 = "您的订单【"+entity.getBillCode()+"】卖家未及时确认已取消。<a href=" + '"' + formurl2 + '"' + ">前往点击</a>";
                    this.sendMsg(messageType2, sender2, "notice", subject2, content2);

                });
                service.updateBatchById(list);
            }
        }
        return CommonResponse.success("运行成功！");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
