package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.business.panhuo.vo.WorkVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.panhuo.mapper.CollectMapper;
import com.ejianc.business.panhuo.bean.CollectEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 收藏实体
 * 
 * @author generator
 * 
 */
@Service("collectService")
public class CollectServiceImpl extends BaseServiceImpl<CollectMapper, CollectEntity> implements ICollectService{

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IAddressService addressService;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IWbuyService wbuyService;

    @Override
    public List<GoodsVO> queryMyCollectGoods(Page pages, QueryWrapper queryWrapper,String userId) {
        return baseMapper.getMyCollectGoods(pages,queryWrapper,userId);
    }

    @Override
    public List<WbuyVO> queryMyCollectWbuy(Page pages, QueryWrapper queryWrapper, String userId) {
        return baseMapper.getMyCollectWbuy(pages,queryWrapper,userId);
    }

    @Override
    public WorkVO queryNums() {
        WorkVO workVO = new WorkVO();
        Long tenantId = InvocationInfoProxy.getTenantid();
        Long userId = InvocationInfoProxy.getUserid();
        //资产收藏数量
        QueryWrapper goodsWrapper = new QueryWrapper();
        goodsWrapper.eq("tenant_id", tenantId);
        goodsWrapper.eq("user_id", userId);
        goodsWrapper.eq("type", 0);
        int zcNums= super.count(goodsWrapper);
        workVO.setZcNums(zcNums);
        //求购收藏数量
        QueryWrapper wbuyWrapper = new QueryWrapper();
        wbuyWrapper.eq("tenant_id", tenantId);
        wbuyWrapper.eq("user_id", userId);
        wbuyWrapper.eq("type", 1);
        int qgNums= super.count(wbuyWrapper);
        workVO.setQgNums(qgNums);

        //地址管理数量
        QueryWrapper addressWrapper = new QueryWrapper();
        addressWrapper.eq("tenant_id", tenantId);
        addressWrapper.eq("user_id", userId);
        int addressNums= addressService.count(addressWrapper);
        workVO.setAddressNums(addressNums);

        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(userId);
        if(!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));


        //购买订单-求购中数量
        QueryWrapper buyIngWrapper = new QueryWrapper();
        buyIngWrapper.eq("tenant_id", tenantId);
        buyIngWrapper.eq("type", 0);
        if (CollectionUtils.isNotEmpty(childIds)) {
            buyIngWrapper.in("buy_org",childIds);
        }
        int buyIngNums= orderService.count(buyIngWrapper);
        workVO.setBuyIngNums(buyIngNums);

        //出售订单-待处理数量
        QueryWrapper sellIngWrapper = new QueryWrapper();
        sellIngWrapper.eq("tenant_id", tenantId);
        sellIngWrapper.eq("type", 0);
        if (CollectionUtils.isNotEmpty(childIds)) {
            sellIngWrapper.in("sell_org",childIds);
        }
        int sellIngNums= orderService.count(sellIngWrapper);
        workVO.setSellIngNums(sellIngNums);

        //货架管理-暂存数量
        QueryWrapper goodsTempWrapper = new QueryWrapper();
        goodsTempWrapper.eq("tenant_id", tenantId);
        goodsTempWrapper.eq("status", 2);
        if (CollectionUtils.isNotEmpty(childIds)) {
            goodsTempWrapper.in("org_id",childIds);
        }
        int goodsNums= goodsService.count(goodsTempWrapper);
        workVO.setGoodsNums(goodsNums);

        //求购管理-暂存数量
        QueryWrapper wbuyTempWrapper = new QueryWrapper();
        wbuyTempWrapper.eq("tenant_id", tenantId);
        wbuyTempWrapper.eq("status", 2);
        if (CollectionUtils.isNotEmpty(childIds)) {
            wbuyTempWrapper.in("org_id",childIds);
        }
        int wbuyNums= wbuyService.count(wbuyTempWrapper);
        workVO.setWbuyNums(wbuyNums);

        return workVO;
    }
}
