/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"wbuy"})
public class WbuyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWbuyService service;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WbuyVO> saveOrUpdate(@RequestBody WbuyVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveWbuy(saveorUpdateVO));
    }

    @RequestMapping(value={"/updateMainimgPath"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody WbuyVO saveorUpdateVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        updateWrapper.set(WbuyEntity::getMainimgPath, (Object)saveorUpdateVO.getMainimgPath());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WbuyVO> updateStatus(@RequestBody WbuyVO saveorUpdateVO) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setStatus(1);
        entity.setCloseType(0);
        entity.setEndbuyTime(DateFormater.getCurrentDate());
        entity.setCloser(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)entity, false);
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WbuyVO> queryDetail(Long id) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(id));
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("user_id", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter("eq", (Object)1));
        List list = this.collectService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setIsCollect(Integer.valueOf(1));
            vo.setCollectId(((CollectEntity)((Object)list.get(0))).getId());
        } else {
            vo.setIsCollect(Integer.valueOf(0));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WbuyVO> queryCopyDetail(Long id) {
        WbuyEntity entity = (WbuyEntity)((Object)this.service.selectById(id));
        WbuyVO vo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        vo.setId(null);
        vo.setCloser(null);
        vo.setCloseType(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        if (CollectionUtils.isNotEmpty((Collection)vo.getImgsPath())) {
            vo.getImgsPath().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getMaterialDetails())) {
            vo.getMaterialDetails().forEach(e -> {
                e.setWbuyId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WbuyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getComplexParams().add(this.getPageQueryParam());
        param.getParams().put("status", new Parameter("eq", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        if (null != lon && null != lat) {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<WbuyEntity> list = this.service.queryWbuy(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", (Object)BeanMapper.mapList(list, WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        } else {
            IPage page = this.service.queryPage(param, false);
            res.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    public ComplexParam getPageQueryParam() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("pushType", new Parameter("eq", (Object)1));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/queryLists"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryLists(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("status", new Parameter("eq", (Object)0));
        Parameter lon = (Parameter)param.getParams().get("lon");
        Parameter lat = (Parameter)param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        JSONObject res = new JSONObject();
        if (null != lon && null != lat) {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<WbuyEntity> list = this.service.queryWbuy(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", (Object)BeanMapper.mapList(list, WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        } else {
            IPage page = this.service.queryPage(param, false);
            res.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
            res.put("total", (Object)page.getTotal());
            res.put("current", (Object)page.getCurrent());
            res.put("size", (Object)page.getSize());
            res.put("pages", (Object)page.getPages());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryWbuyIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)0));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("buyer");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("buyer", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryWbuyEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)1));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("buyer");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("buyer", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryWbuyTemp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WbuyVO>> queryWbuyTemp(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)2));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("buyer");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("buyer", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().remove("buyer");
        }
        param.getParams().remove("isMyOrder");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter("in", childIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WbuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/shelfWbuy"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse shelfWbuy(HttpServletRequest request) {
        this.logger.debug("\u5f00\u59cb----");
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.lt(WbuyEntity::getEndDate, (Object)DateFormater.getInstance((Date)new Date()).format("yyyy-MM-dd"));
        lambdachange.eq(WbuyEntity::getStatus, (Object)0);
        List list = this.service.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            HashMap map = new HashMap();
            this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
            list.forEach(e -> {
                e.setStatus(1);
                e.setCloser(99999L);
                e.setCloseType(1);
                e.setEndbuyTime(DateFormater.getCurrentDate());
                if (map.containsKey(e.getBuyer())) {
                    ((List)map.get(e.getBuyer())).add(e);
                } else {
                    ArrayList<WbuyEntity> listWbuy = new ArrayList<WbuyEntity>();
                    listWbuy.add((WbuyEntity)((Object)e));
                    map.put(e.getBuyer(), listWbuy);
                }
            });
            for (Map.Entry entry : map.entrySet()) {
                ArrayList<String> messageType = new ArrayList<String>();
                messageType.add("sys");
                messageType.add("weChat");
                ArrayList<String> sender = new ArrayList<String>();
                sender.add(entry.getKey() + "");
                this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender);
                String formurl = this.baseHost + "ejc-panhuo-frontend/#/buyingManagement?activeKey=2&isMyWbuy=0&endbuyTime=" + DateFormater.getInstance().format("yyyy-MM-dd");
                String subject = "\u60a8\u53d1\u5e03\u7684\u6c42\u8d2d\u4fe1\u606f\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u6761\u4eca\u65e5\u5230\u671f\u5df2\u81ea\u52a8\u5173\u95ed";
                String content = "\u60a8\u53d1\u5e03\u7684\u6c42\u8d2d\u4fe1\u606f\u6709\u3010" + ((List)entry.getValue()).size() + "\u3011\u6761\u4eca\u65e5\u5230\u671f\u5df2\u81ea\u52a8\u5173\u95ed\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.sendMsg(messageType, sender, "notice", subject, content);
            }
            this.service.updateBatchById(list);
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)"\u6d88\u606f\u63d0\u9192");
            weixineeParams.put("description", (Object)subject);
            weixineeParams.put("url", (Object)(this.baseHost + "ejc-panhuo-mobile/#/purchaseIndex?activeTab=1&userid={userid}"));
            weixineeParams.put("btntxt", (Object)"\u70b9\u51fb\u67e5\u770b");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

