package com.ejianc.business.panhuo.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/panhuo/")
@Api(value = "资产盘活API接口", tags = {"资产盘活API接口"})
public class PanhuoApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IGoodsService service;


    @ApiOperation("通过材料id查询资产集市对应数量")
    @RequestMapping(value = "/queryGoodsByMaterialIds", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<GoodsVO>> queryGoodsByMaterialIds(@RequestParam(value = "materialIds") List<Long> materialIds){
        logger.info("接收到材料id：{}", JSONObject.toJSONString(materialIds));
        QueryWrapper<GoodsEntity> query = new QueryWrapper<>();
        query.select("material_id, ifnull(sum(rotatable_nums),0) as rotatableNums");
        query.in("material_id", materialIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("status", 0);
        query.groupBy("material_id");
        List<GoodsEntity> goodsList = service.list(query);
        logger.info("查到材料对应数量：{}", JSONObject.toJSONString(goodsList));
        return CommonResponse.success("查询成功", BeanMapper.mapList(goodsList, GoodsVO.class));
    }


}
