package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.bean.PutawayDetailEntity;
import com.ejianc.business.panhuo.bean.PutawayEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.service.IPutawayService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.business.store.api.IIdleManageApi;
import com.ejianc.business.store.api.IStoreApi;
import com.ejianc.business.store.vo.AllotOutDetailVO;
import com.ejianc.business.store.vo.AllotOutVO;
import com.ejianc.business.store.vo.IdleFlowVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PANHUO_DD = "PANHUO_DD";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPutawayService putawayService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IAllotService allotService;

    @Autowired
    private IStoreApi storeApi;
    @Autowired
    private PutawayBpmServiceImpl putawayBpmService;
    @Autowired
    private IIdleManageApi idleManageApi;


    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;
    @Override
    public OrderVO saveOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        if(goodsEntity.getVersion()!=vo.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
        BigDecimal ordernums = vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums();
        if(ordernums.compareTo(rotatableNums)>0){
            throw new BusinessException("下单数量不能超过资产可周转数量!");
        }

        OrderEntity orderEntity = BeanMapper.map(vo,OrderEntity.class);
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);//待确认
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setSellStoreId(goodsEntity.getStoreId());
        orderEntity.setSellStoreName(goodsEntity.getStoreName());
        orderEntity.setSourceType(goodsEntity.getSourceType());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny()==null?BigDecimal.ZERO:vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice()==null?BigDecimal.ZERO:vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        if(null!=vo&&StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_DD,tenantId);
            if(billCode.isSuccess()) {
                orderEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        BigDecimal nums = goodsEntity.getNums()==null?BigDecimal.ZERO:goodsEntity.getNums();
//        BigDecimal sellNums = goodsEntity.getSellNums()==null?BigDecimal.ZERO:goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
        goodsEntity.setPreNums(preNums.add(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums()));
        goodsEntity.setRotatableNums(rotatableNums.subtract(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums()));
        goodsService.saveOrUpdate(goodsEntity,false);

        super.saveOrUpdate(orderEntity, false);
        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(goodsEntity.getSeller()+"");
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=1";
        String mobileUrl = baseHost+"ejc-panhuo-mobile/#/sellerManage/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理";
        String content = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        OrderVO resvo = BeanMapper.map(orderEntity, OrderVO.class);
        return resvo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String confirmerOrder(OrderVO vo) {
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        OrderEntity orderEntity = super.getById(vo.getId());
        if(orderEntity.getVersion()!=vo.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }
        BigDecimal nums = goodsEntity.getNums()==null?BigDecimal.ZERO:goodsEntity.getNums();
        BigDecimal sellNums = goodsEntity.getSellNums()==null?BigDecimal.ZERO:goodsEntity.getSellNums();
        BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
        BigDecimal remainingNums = goodsEntity.getRemainingNums()==null?BigDecimal.ZERO:goodsEntity.getRemainingNums();//剩余

        goodsEntity.setSellNums(sellNums.add(vo.getNums()));//已成交
        goodsEntity.setPreNums(preNums.subtract(orderEntity.getOrdernums()));//预定中
        goodsEntity.setRotatableNums(nums.subtract(goodsEntity.getSellNums()).subtract(goodsEntity.getPreNums()));//可周转
        goodsEntity.setRemainingNums(nums.subtract(goodsEntity.getSellNums()));//剩余数量
        if(BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums())>=0){
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId,vo.getGoodsId());
            lambdachange.eq(OrderEntity::getType,0);
            lambdachange.ne(OrderEntity::getId,vo.getId());
            int num = super.count(lambdachange);
            if(num<=0){
                // TO DO 下架消息发送
                List<String> messageType = new ArrayList<>();
                messageType.add("sys");
                messageType.add("weChat");
                List<String> sender = new ArrayList<>();
                sender.add(goodsEntity.getSeller()+"");
                logger.info("发送信息给提交人:>----------" + sender);
                String formurl = baseHost+"ejc-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=1&lowerTime="+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                String mobileUrl = baseHost+"ejc-panhuo-mobile/#/goodsManage/card?id="+goodsEntity.getId()+"&userid={userid}";
                String subject = "您上架的物资【"+goodsEntity.getMaterialName()+"】已经售罄并下架";
                String content = "您上架的物资【"+goodsEntity.getMaterialName()+"】已经售罄并下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());

                //处理仓库逻辑
                if (goodsEntity.getSourceType() != null && goodsEntity.getSourceType().equals("仓库")){
                    PutawayEntity putawayEntity = putawayService.selectById(goodsEntity.getPutawayId());
                    List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
                    List<IdleFlowVO> idleFlowVOList = new ArrayList<>();
                    if(CollectionUtils.isNotEmpty(putawayDetailList)){
                        for (PutawayDetailEntity putawayDetailEntity : putawayDetailList){
                            if (putawayDetailEntity.getId().equals(goodsEntity.getPutawayDetailId())){
                                IdleFlowVO idleFlowVO = putawayBpmService.getIdleFlowVO(putawayEntity, putawayDetailEntity, 1);
                                idleFlowVOList.add(idleFlowVO);
                            }
                        }
                    }

                    CommonResponse<String> stringCommonResponse = idleManageApi.inOutStore(idleFlowVOList);
                    if(!stringCommonResponse.isSuccess()) {
                        throw new BusinessException(stringCommonResponse.getMsg());
                    }
                }
            }
        }

        // TO DO 确认订单消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(orderEntity.getOrderUserId()+"");//订购人
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"ejc-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=2";
        String mobileUrl = baseHost+"ejc-panhuo-mobile/#/buyOrder/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成";
        String content = "您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        goodsService.saveOrUpdate(goodsEntity,false);
        orderEntity.setConfirmer(vo.getConfirmer());
        orderEntity.setConfirmName(vo.getConfirmName());
        orderEntity.setPrice(vo.getPrice());
        orderEntity.setNums(vo.getNums());
        orderEntity.setMny(vo.getMny());
        orderEntity.setDealrTime(DateFormater.getCurrentDate());
        orderEntity.setType(1);//订单完成
        super.saveOrUpdate(orderEntity, false);

        //生成调拨单
        AllotVO allotVO = BeanMapper.map(orderEntity, AllotVO.class);
        allotVO.setId(null);
        allotVO.setBillCode(null);
        allotVO.setOrderId(orderEntity.getId());
        allotVO.setAmount(orderEntity.getMny());
        allotVO.setConfirmerName(orderEntity.getConfirmName());
        allotVO.setBillState(1);
        allotService.saveAllot(allotVO);

        //仓库来源的数据生成调拨出库单
        if ("仓库".equals(orderEntity.getSourceType())){
            //设置主表数据
            AllotOutVO allotOutVO = this.getAllotOutVO(orderEntity);
            logger.info("推送调拨出库数据-allotOutVO-{}", JSONObject.toJSONString(allotOutVO));
            storeApi.changeToAllouOut(allotOutVO);
        }

        return "success";
    }

    //组装调拨出库单数据
    private AllotOutVO getAllotOutVO(OrderEntity orderEntity) {
        AllotOutVO allotOutVO = new AllotOutVO();
        allotOutVO.setProjectId(orderEntity.getSellProject());
        allotOutVO.setProjectName(orderEntity.getSellProjectName());
        allotOutVO.setOrgId(orderEntity.getSellOrg());
        allotOutVO.setOrgName(orderEntity.getSellOrgName());
        allotOutVO.setStoreId(orderEntity.getSellStoreId());
        allotOutVO.setStoreName(orderEntity.getSellStoreName());
        allotOutVO.setOutDate(new Date());
        allotOutVO.setOutMny(orderEntity.getMny());
        allotOutVO.setOutTaxMny(orderEntity.getMny());
        allotOutVO.setEmployeeId(orderEntity.getConfirmer());
        allotOutVO.setEmployeeName(orderEntity.getConfirmName());
        allotOutVO.setInProjectId(orderEntity.getBuyProject());
        allotOutVO.setInProjectName(orderEntity.getBuyProjectName());
        allotOutVO.setInOrgId(orderEntity.getBuyOrg());
        allotOutVO.setInOrgName(orderEntity.getBuyOrgName());
        allotOutVO.setMaterialNames(orderEntity.getMaterialName());
        allotOutVO.setReceiverId(orderEntity.getOrderUserId());
        allotOutVO.setReceiverName(orderEntity.getOrderUserName());
        allotOutVO.setReceiverPersonId(orderEntity.getOrderUserId().toString());
        allotOutVO.setReceiverPerson(orderEntity.getOrderUserName());
        allotOutVO.setInStoreId(orderEntity.getBuyStoreId());
        allotOutVO.setInStoreName(orderEntity.getBuyStoreName());
        allotOutVO.setReceiveDate(new Date());

        //设置上级组织
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(Arrays.asList(allotOutVO.getOrgId(), allotOutVO.getInOrgId()));
        if(!orgResp.isSuccess()) {
            logger.error("推送调拨出库，获取组织信息orgId-{}，inOrgId-{}，信息失败，{}", allotOutVO.getOrgId(), allotOutVO.getInOrgId(), orgResp.getMsg());
            throw new BusinessException("推送调拨出库，获取项目部信息失败！");
        }
        List<OrgVO> orgVOList = orgResp.getData();
        logger.info("orgId-{}, inOrgId-{}", allotOutVO.getOrgId(), allotOutVO.getInOrgId());
        logger.info("获取组织信息orgVOList-{}", JSONObject.toJSONString(orgVOList));
        if (CollectionUtils.isNotEmpty(orgVOList)){
            for (OrgVO orgVO : orgVOList) {
                if (allotOutVO.getOrgId().equals(orgVO.getId()) && allotOutVO.getParentOrgId() == null){
                    allotOutVO.setParentOrgId(orgVO.getParentId());
                }
                if (allotOutVO.getInOrgId().equals(orgVO.getId()) && allotOutVO.getInParentOrgId() == null){
                    allotOutVO.setInParentOrgId(orgVO.getParentId());
                }
            }
        }

        //设置子表
        AllotOutDetailVO allotOutDetailVO = new AllotOutDetailVO();
        allotOutDetailVO.setMaterialCategoryId(orderEntity.getMaterialTypeId());
        allotOutDetailVO.setMaterialCategoryName(orderEntity.getMaterialTypeName());
        //没有分类编码
        allotOutDetailVO.setMaterialId(orderEntity.getMaterialId());
        allotOutDetailVO.setMaterialName(orderEntity.getMaterialName());
        allotOutDetailVO.setMaterialCode(orderEntity.getMaterialCode());
        allotOutDetailVO.setMaterialSpec(orderEntity.getSpec());
        allotOutDetailVO.setMaterialUnit(orderEntity.getUnit());
        allotOutDetailVO.setAllocatNum(orderEntity.getOrdernums());
        allotOutDetailVO.setAllocatTaxPrice(orderEntity.getOrderprice());
        allotOutDetailVO.setAllocatTaxMny(orderEntity.getOrdermny());

        allotOutVO.setAllotOutDetailList(Arrays.asList(allotOutDetailVO));
        return allotOutVO;
    }

    @Override
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", url);
            weixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
