package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.panhuo.bean.*;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.ILableService;
import com.ejianc.business.panhuo.service.IPutawayService;
import com.ejianc.business.panhuo.vo.LableUIVO;
import com.ejianc.business.store.api.IIdleManageApi;
import com.ejianc.business.store.vo.IdleFlowVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.swing.plaf.LabelUI;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("putaway") 
public class PutawayBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IGoodsService goodsService;
	@Autowired
	private IPutawayService putawayService;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String PANHUO_ZC = "PANHUO_ZC";
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private ILableService lableService;
	@Autowired
	private ILabeldetailService labeldetailService;
	@Autowired
	private IIdleManageApi idleManageApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		//推送流水
		PutawayEntity putawayEntity = putawayService.selectById(billId);
		List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
		List<IdleFlowVO> idleFlowVOList = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(putawayDetailList)){
			for (PutawayDetailEntity putawayDetailEntity : putawayDetailList){
				if (putawayDetailEntity.getSourceType() != null && putawayDetailEntity.getSourceType().equals("仓库")){
					IdleFlowVO idleFlowVO = getIdleFlowVO(putawayEntity, putawayDetailEntity, 0);
					idleFlowVOList.add(idleFlowVO);
				}
			}
			if (CollectionUtils.isNotEmpty(idleFlowVOList)){
				CommonResponse<String> stringCommonResponse = idleManageApi.inOutStore(idleFlowVOList);
				if(!stringCommonResponse.isSuccess()) {
					throw new BusinessException(stringCommonResponse.getMsg());
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		CommonResponse<String> stringCommonResponse = idleManageApi.inOutStoreRollback(billId);
		if(!stringCommonResponse.isSuccess()) {
			return CommonResponse.error(stringCommonResponse.getMsg());
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//推送goods
		Long tenantId = InvocationInfoProxy.getTenantid();
		PutawayEntity putawayEntity = putawayService.selectById(billId);
		List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
		if (CollectionUtils.isNotEmpty(putawayDetailList)){
			List<IdleFlowVO> idleFlowVOList = new ArrayList<>();
			List<LabeldetailEntity> lableDetailEntityNewList = new ArrayList<>();
			List<GoodsEntity> goodsEntityArrayList = new ArrayList<>();
			List<LableUIVO> lableUIVOArrayList = new ArrayList<>();
//			LambdaQueryWrapper<LableEntity> lambdaLable = Wrappers.<LableEntity>lambdaQuery();
//			lambdaLable.eq(LableEntity::getDocumentId, rmatTalkEntity.getBillId());
			List<LableEntity> lableEntityList = lableService.list();
			Map<Long, LableEntity> lableMap = new HashMap<>();
			if (CollectionUtils.isNotEmpty(lableEntityList)){
				lableMap = lableEntityList.stream().collect(Collectors.toMap(LableEntity::getId, Function.identity()));
			}
			//获取附件信息
			List<Long> attachIds = putawayDetailList.stream().map(PutawayDetailEntity::getId).collect(Collectors.toList());
			Map<String, List<Long>> map = new HashMap<>();
			map.put("sourceIds",attachIds);
			JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
			CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
			Map<Long, List<AttachmentVO>> attacMap = new HashMap<>();
			if (listCommonResponse.isSuccess()){
				List<AttachmentVO> data = listCommonResponse.getData();
				if (CollectionUtils.isNotEmpty(data)){
					attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
				}
			}
			Date date = new Date();
			for (PutawayDetailEntity putawayDetailEntity : putawayDetailList){
				GoodsEntity goodsEntity = new GoodsEntity();
				goodsEntity.setId(IdWorker.getId());
				CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
				if(billCode.isSuccess()) {
					goodsEntity.setBillCode(billCode.getData());
				}else{
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
				goodsEntity.setSellerName(putawayEntity.getSellerName());
				goodsEntity.setSeller(putawayEntity.getSeller());
				if ("1".equals(putawayDetailEntity.getShelfType())){
					goodsEntity.setToolId(IdWorker.getId());
					goodsEntity.setType(0);//手动上架
				}
				//资产主图
				if (attacMap.containsKey(putawayDetailEntity.getId())){
					List<AttachmentVO> attachmentVOList = attacMap.get(putawayDetailEntity.getId());
					AttachmentVO attachmentVO = attachmentVOList.stream().findFirst().get();
					goodsEntity.setMainimgPath(attachmentVO.getImgServerPath() + attachmentVO.getFilePath());
				}
				goodsEntity.setProjectId(putawayEntity.getProjectId());
				goodsEntity.setProjectName(putawayEntity.getProjectName());
				goodsEntity.setOrgId(putawayEntity.getOrgId());
				goodsEntity.setOrgName(putawayEntity.getOrgName());
				goodsEntity.setSpec(putawayDetailEntity.getSpec());
				goodsEntity.setShelfType(putawayDetailEntity.getShelfType());
				goodsEntity.setMaterialId(putawayDetailEntity.getMaterialId());
				goodsEntity.setMaterialCode(putawayDetailEntity.getMaterialCode());
				goodsEntity.setMaterialName(putawayDetailEntity.getMaterialName());
				goodsEntity.setMaterialTypeId(putawayDetailEntity.getMaterialTypeId());
				goodsEntity.setMaterialTypeName(putawayDetailEntity.getMaterialTypeName());
				goodsEntity.setSourceId(putawayDetailEntity.getSourceId());
				goodsEntity.setSystemId(putawayDetailEntity.getSystemId());
				goodsEntity.setOriginalprice(putawayDetailEntity.getOriginalprice());
				goodsEntity.setDiscount(putawayDetailEntity.getDiscount());
				goodsEntity.setUnit(putawayDetailEntity.getUnit());
				goodsEntity.setPrice(putawayDetailEntity.getPrice());
				goodsEntity.setNums(putawayDetailEntity.getRotatableNums());
				goodsEntity.setRemainingNums(putawayDetailEntity.getRotatableNums());
				goodsEntity.setShelfMny(putawayDetailEntity.getShelfMny());
				goodsEntity.setIsPack(putawayDetailEntity.getIsPack());
				goodsEntity.setAddress(putawayEntity.getAddress());
				goodsEntity.setAddressId(putawayEntity.getAddressId());
				goodsEntity.setAddressName(putawayEntity.getAddressName());
				goodsEntity.setAddress(putawayEntity.getAddress());
				goodsEntity.setProjectAddress(putawayEntity.getProjectAddress());
				goodsEntity.setLon(putawayEntity.getLon());
				goodsEntity.setLat(putawayEntity.getLat());
				goodsEntity.setFirstLocation(putawayEntity.getFirstLocation());
				goodsEntity.setSecondLocation(putawayEntity.getSecondLocation());
				goodsEntity.setThirdLocation(putawayEntity.getThirdLocation());
				goodsEntity.setFourthLocation(putawayEntity.getFourthLocation());
				goodsEntity.setLocation(putawayEntity.getLocation());
				goodsEntity.setPhone(putawayEntity.getPhone());
				goodsEntity.setName(putawayEntity.getName());
				goodsEntity.setShelfTime(date);
				goodsEntity.setDetails(putawayDetailEntity.getDetails());
				goodsEntity.setStatus(0);
				goodsEntity.setLabelName(putawayDetailEntity.getLabelName());
				goodsEntity.setPutawayId(putawayEntity.getId());
				goodsEntity.setPutawayDetailId(putawayDetailEntity.getId());
				goodsEntity.setRotatableNums(putawayDetailEntity.getRotatableNums());
				goodsEntity.setStoreId(putawayDetailEntity.getStoreId());
				goodsEntity.setStoreName(putawayDetailEntity.getStoreName());
				goodsEntity.setSourceType(putawayDetailEntity.getSourceType());

				if (state == 1 && putawayDetailEntity.getSourceType() != null && putawayDetailEntity.getSourceType().equals("仓库")){
					IdleFlowVO idleFlowVO = getIdleFlowVO(putawayEntity, putawayDetailEntity,0);
					idleFlowVOList.add(idleFlowVO);
				}

				//标签处理
				String labelIds = putawayDetailEntity.getLabelIds();
				if (labelIds != null){
					String[] split = labelIds.split(",");
					List<String> labIds = Arrays.asList(split);
					for (String id : labIds){
						Long lableId = Long.parseLong(id);
						if (lableMap.containsKey(lableId)){
							LableEntity lableEntity = lableMap.get(lableId);
							LabeldetailEntity labeldetailEntity = new LabeldetailEntity();
							labeldetailEntity.setId(IdWorker.getId());
							labeldetailEntity.setSourceId(goodsEntity.getId());
							labeldetailEntity.setType(0);
							labeldetailEntity.setLabelId(lableEntity.getId());
							labeldetailEntity.setName(lableEntity.getName());
							labeldetailEntity.setColour(lableEntity.getColour());
							lableDetailEntityNewList.add(labeldetailEntity);
							LableUIVO lableUIVO = new LableUIVO();
							lableUIVO.setUitype("EJCTagItem");
							lableUIVO.setUititle(lableEntity.getName());
							lableUIVO.setText(lableEntity.getName());
							lableUIVO.setValue(lableEntity.getId().toString());
							lableUIVO.setColour(lableEntity.getColour());
							lableUIVO.setLabelId(lableEntity.getId().toString());
							lableUIVO.setName(lableEntity.getName());
							lableUIVO.setType("0");
							lableUIVOArrayList.add(lableUIVO);

						}

					}

				}
				goodsEntity.setLabelName(JSONObject.toJSONString(lableUIVOArrayList));
				goodsEntityArrayList.add(goodsEntity);
			}
			if (CollectionUtils.isNotEmpty(goodsEntityArrayList)){
				goodsService.saveBatch(goodsEntityArrayList);
			}
			if (CollectionUtils.isNotEmpty(lableDetailEntityNewList)){
				labeldetailService.saveBatch(lableDetailEntityNewList);
			}
			if (CollectionUtils.isNotEmpty(idleFlowVOList)){
				CommonResponse<String> stringCommonResponse = idleManageApi.inOutStore(idleFlowVOList);
				if(!stringCommonResponse.isSuccess()) {
					throw new BusinessException(stringCommonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审，可以从货架下架材料!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	//type 0 上架 1-下架
	public IdleFlowVO getIdleFlowVO(PutawayEntity putawayEntity,PutawayDetailEntity putawayDetailEntity, Integer type) {
		IdleFlowVO idleFlowVO = new IdleFlowVO();
		idleFlowVO.setStoreId(putawayDetailEntity.getStoreId());
		idleFlowVO.setStoreName(putawayDetailEntity.getStoreName());
		idleFlowVO.setSourceBillTypeName("材料上架");
		idleFlowVO.setSourceBillTypeCode("EJCBT202312000010");
		idleFlowVO.setProjectId(putawayEntity.getProjectId());
		idleFlowVO.setProjectName(putawayEntity.getProjectName());
		idleFlowVO.setOrgId(putawayEntity.getOrgId());
		idleFlowVO.setOrgName(putawayEntity.getOrgName());
		idleFlowVO.setMaterialCategoryId(putawayDetailEntity.getMaterialTypeId());
		idleFlowVO.setMaterialCategoryName(putawayDetailEntity.getMaterialTypeName());
		idleFlowVO.setMaterialCategoryCode(putawayDetailEntity.getMaterialTypeCode());
		idleFlowVO.setMaterialId(putawayDetailEntity.getMaterialId());
		idleFlowVO.setMaterialName(putawayDetailEntity.getMaterialName());
		idleFlowVO.setMaterialCode(putawayDetailEntity.getMaterialCode());
		idleFlowVO.setMaterialSpec(putawayDetailEntity.getSpec());
		idleFlowVO.setMaterialUnitId(putawayDetailEntity.getUnitId());
		idleFlowVO.setMaterialUnitName(putawayDetailEntity.getUnit());
		if (type == 0){
			idleFlowVO.setNum(putawayDetailEntity.getRotatableNums());
		}else{
			idleFlowVO.setNum(ComputeUtil.safeSub(BigDecimal.ZERO,putawayDetailEntity.getRotatableNums()));
		}
		idleFlowVO.setSourceId(putawayEntity.getId());
		idleFlowVO.setSourceDetailId(putawayDetailEntity.getId());
		idleFlowVO.setSourceBillCode(putawayEntity.getBillCode());
		idleFlowVO.setSourceBillDate(putawayEntity.getCreateTime());
		idleFlowVO.setSourceBillRemark(putawayEntity.getMemo());
		idleFlowVO.setRowState(putawayEntity.getRowState());
		return idleFlowVO;
	}

}
