package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.PutawayEntity;
import com.ejianc.business.panhuo.vo.PutawayVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.LableEntity;
import com.ejianc.business.panhuo.service.ILableService;
import com.ejianc.business.panhuo.vo.LableVO;

/**
 * 标签库
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("lable")
public class LableController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ILableService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LableVO> saveOrUpdate(@RequestBody LableVO saveorUpdateVO) {
    	LableEntity entity = BeanMapper.map(saveorUpdateVO, LableEntity.class);
    	service.saveOrUpdate(entity, false);
    	LableVO vo = BeanMapper.map(entity, LableVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LableVO> queryDetail(Long id) {
    	LableEntity entity = service.selectById(id);
    	LableVO vo = BeanMapper.map(entity, LableVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LableVO> vos) {
        service.removeByIds(vos.stream().map(LableVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<LableVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", BeanMapper.mapList(service.queryList(param,false),LableVO.class));
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLableData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LableVO>> refLableData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("type", new Parameter(QueryParam.EQ, 0));

        IPage<LableEntity> page = service.queryPage(param,false);
        IPage<LableVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LableVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
