package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.*;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.business.panhuo.vo.*;
import com.ejianc.business.store.api.IIdleManageApi;
import com.ejianc.business.store.vo.IdleFlowVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 资产表
 *
 * @author generator
 *
 */
@Service("goodsService")
public class GoodsServiceImpl extends BaseServiceImpl<GoodsMapper, GoodsEntity> implements IGoodsService{

    private static final String PANHUO_ZC = "PANHUO_ZC";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrgApi iOrgApi;

//    @Autowired
//    private IImgdetailService imgdetailService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ILabeldetailService labeldetailService;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IGoodsService servicel;
    @Autowired
    private IPutawayService putawayService;
    @Autowired
    private PutawayBpmServiceImpl putawayBpmService;
    @Autowired
    private IIdleManageApi idleManageApi;
    @Override
    public GoodsVO saveGoods(GoodsVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity entity = BeanMapper.map(vo, GoodsEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(vo.getId() != null && vo.getId() > 0){
            //修改
//            List<ImgdetailEntity> list = entity.getImgsPath();
            List<LabeldetailEntity> listlb = entity.getLabels();

//            entity.setMainimgPath(null);
//            QueryWrapper imgWrapper = new QueryWrapper();
//            imgWrapper.eq("source_id",vo.getId());
//            imgdetailService.remove(imgWrapper);

            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq("source_id",vo.getId());
            labeldetailService.remove(labekWrapper);

//            if(CollectionUtils.isNotEmpty(list)){
//                list.forEach(e -> {
//                    e.setId(null);
//                });
//            }

            if(CollectionUtils.isNotEmpty(listlb)){
                listlb.forEach(e -> {
                    e.setId(null);
                });
            }
        }

        //将第一张图片缩略图设置为主图
//        List<ImgdetailVO> list = vo.getImgsPath();
//        if(CollectionUtils.isNotEmpty(list)){
//            entity.setMainimgPath(list.get(0).getThumpath());
//        }

        //资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
        if("1".equals(vo.getShelfType())&&!(null!=vo.getToolId()&&vo.getToolId()>0)){
            //机具需要生成机具主键，为后续记录周转记录用
            long toolId=System.currentTimeMillis();
            entity.setToolId(toolId);
            entity.setType(0);//手动上架
        }
        entity.setShelfTime(DateFormater.getCurrentDate());
        entity.setNums(vo.getRotatableNums());
        entity.setRemainingNums(vo.getRotatableNums());
        super.saveOrUpdate(entity, false);
        GoodsVO resvo = BeanMapper.map(entity, GoodsVO.class);
        return resvo;
    }

    @Override
    public GoodsDetailsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = super.selectById(id);
        GoodsDetailsVO vo = BeanMapper.map(entity, GoodsDetailsVO.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        //获取项目其他在售
        LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange.eq(GoodsEntity::getProjectId,entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus,0);
        lambdachange.gt(GoodsEntity::getRotatableNums,0);
        int nums = super.count(lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper<GoodsEntity> lambdachange2 = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange2.eq(GoodsEntity::getTenantId, tenantId);
        lambdachange2.eq(GoodsEntity::getProjectId,entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus,0);
        lambdachange2.ne(GoodsEntity::getId,id);
        lambdachange2.gt(GoodsEntity::getRotatableNums,0);
        lambdachange2.last("limit 3");
        List<GoodsEntity> list = super.list(lambdachange2);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setOthersGoods(BeanMapper.mapList(list,GoodsVO.class));
        }
        //如果是机具，需要获取机具周转记录
        //资产类型0-周转材，1-机具，2-剩余物资，3-办公用品
        if("1".equals(entity.getShelfType())){
            LambdaQueryWrapper<GoodsEntity> lambdachange3 = Wrappers.<GoodsEntity>lambdaQuery();
            lambdachange3.eq(GoodsEntity::getTenantId, tenantId);
            lambdachange3.eq(GoodsEntity::getToolId,entity.getToolId());
            lambdachange3.orderBy(false,true,GoodsEntity::getShelfTime);
            List<GoodsEntity> listgoods = super.list(lambdachange3);
            List<GoodsToolVO> listtools = new ArrayList<>();
            GoodsToolVO toolVO = BeanMapper.map(listgoods.get(0),GoodsToolVO.class);
            toolVO.setDealrTime(listgoods.get(0).getShelfTime());
            toolVO.setName("资产上架");
            listtools.add(toolVO);
            //发生周转，本次资产状态为下架，下架类型为售罄
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("tool_id", new Parameter(QueryParam.EQ,entity.getToolId()));
            queryParam.getParams().put("type", new Parameter(QueryParam.EQ,1));
            queryParam.getOrderMap().put("dealr_time",QueryParam.ASC);
            List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
            if(CollectionUtils.isNotEmpty(listOrder)){
                listOrder.forEach(e -> {
                    GoodsToolVO toolVo = new GoodsToolVO();
                    toolVo.setName("周转入库");
                    toolVo.setProjectName(e.getBuyProjectName());
                    toolVo.setDealrTime(e.getDealrTime());
                    toolVo.setToolId(e.getToolId());
                    listtools.add(toolVo);
                });
            }
            vo.setToolDetails(listtools);
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("collect_id", new Parameter(QueryParam.EQ,id));
        queryParam.getParams().put("user_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getUserid()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
        List<CollectEntity> listc= collectService.queryList(queryParam,false);
        if(CollectionUtils.isNotEmpty(listc)){
            vo.setIsCollect(1);
            vo.setCollectId(listc.get(0).getId());
        }else{
            vo.setIsCollect(0);
        }

        //设置材料上架编码
        if (entity.getPutawayId() != null){
            PutawayEntity putawayEntity = putawayService.selectById(entity.getPutawayId());
            vo.setPutawayBillCode(putawayEntity.getBillCode());
        }

        return vo;
    }

    @Override
    public List<GoodsEntity> queryGoods(Page pages, QueryWrapper queryWrapper,String lon,String lat) {
        return baseMapper.getGoods(pages,queryWrapper,lon,lat);
    }

    @Override
    public ReportVO orgStatistics(Long orgId) {
        List<Long> commonOrgIds = new ArrayList<>();
        if(null==orgId||orgId<=0){
            orgId = InvocationInfoProxy.getOrgId();
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ReportVO resVO = new ReportVO();

        ReportVO pronumsVo = baseMapper.getPronums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=pronumsVo){
            resVO.setProNums(pronumsVo.getProNums()==null?BigDecimal.ZERO:pronumsVo.getProNums());
        }else{
            resVO.setProNums(BigDecimal.ZERO);
        }

        ReportVO goodsNumsVo = baseMapper.getGoodsnums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=goodsNumsVo){
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsAmount());
            if(null!=goodsNumsVo.getShelfTime()){
                int days = (int) ((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / (1000*3600*24));
                resVO.setDays(days);
            }
        }else{
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }

        ReportVO goodsNumsIngVo = baseMapper.getGoodsnumsIng(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=goodsNumsIngVo){
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfAmount());
        }else{
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }

        ReportVO OrdernumsVo = baseMapper.getOrdernums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=OrdernumsVo){
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }else{
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }

        return resVO;
    }

    @Override
    public List<ReportVO> periodStatistics(List<Long> commonOrgIds) {
        return baseMapper.getPeriodStatistics(InvocationInfoProxy.getTenantid(),commonOrgIds);
    }

    @Override
    public List<ReportVO> proportion(List<Long> commonOrgIds,int type) {
        if(type==0){//上架
            return baseMapper.getGoodsProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }else if(1==type){//在售
            return baseMapper.getGoodsIngProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }else{//成交
            return baseMapper.getProportion(InvocationInfoProxy.getTenantid(),commonOrgIds);
        }
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> queryIdleGoods(String range, String dateIn, Long orgId) {
        BigDecimal estimationMny = new BigDecimal(0); // 闲置物资暂估金额
        BigDecimal yearEstimationMny = new BigDecimal(0); // 本年新增闲置物资暂估金额
        BigDecimal utilizeMny = new BigDecimal(0); // 闲置物资再利用金额
        BigDecimal turnoverRate = new BigDecimal(0); // 闲置物资周转率
        BigDecimal shelfNum = new BigDecimal(0);// 累计上架数量
        BigDecimal shelfProject = new BigDecimal(0); // 累计上架项目
        BigDecimal yiBai = new BigDecimal(100);
        ReportVO res = servicel.orgStatistics(orgId);
        // 累计上架项目
        shelfProject = res.getProNums();
        // 累计上架数量
        shelfNum = res.getGoodsNums();
        // 闲置物资暂估金额
        estimationMny = res.getGoodsAmount();
        // 闲置物资再利用金额
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> reportVOS = servicel.proportion(commonOrgIds,2);
        for (ReportVO reportVO : reportVOS){
            utilizeMny = utilizeMny.add(reportVO.getOrderAmount());
        }
        // 闲置物资周转率
        if (estimationMny.equals(BigDecimal.ZERO)){
            turnoverRate = turnoverRate;
        }else {
            turnoverRate = utilizeMny.divide(estimationMny,4,BigDecimal.ROUND_HALF_UP).multiply(yiBai);
        }
        // 本年新增闲置物资暂估金额
        ReportVO resVO = new ReportVO();
        ReportVO goodsNumsVo = baseMapper.getYearGoodsnums(InvocationInfoProxy.getTenantid(),commonOrgIds);
        if(null!=goodsNumsVo){
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsAmount());
        }else{
            resVO.setGoodsAmount(BigDecimal.ZERO);
        }
        yearEstimationMny = resVO.getGoodsAmount();
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("estimationMny", estimationMny);// 闲置物资暂估金额
        map.put("yearEstimationMny", yearEstimationMny);// 本年新增闲置物资暂估金额
        map.put("utilizeMny", utilizeMny);// 闲置物资再利用金额
        map.put("turnoverRate", turnoverRate);// 闲置物资周转率
        map.put("shelfNum", shelfNum);// 累计上架数量
        map.put("shelfProject", shelfProject);// 累计上架项目
        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    @Transactional
    public GoodsVO updateStatus(GoodsVO saveorUpdateVO) {
        GoodsEntity entity = super.selectById(saveorUpdateVO.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ,saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ,0));
        List<OrderEntity> listOrder= orderService.queryList(queryParam,false);
        if(null!=listOrder&&listOrder.size()>0){
            throw new BusinessException("存在未完成的订单,不允许下架！");
        }

        entity.setStatus(1);//下架
        entity.setLowerType(0);//下架类型0-手动下架，1-售罄下架，2-到期下架
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        super.saveOrUpdate(entity, false);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);

        //处理仓库逻辑
        if (entity.getSourceType() != null && entity.getSourceType().equals("仓库")){

            PutawayEntity putawayEntity = putawayService.selectById(entity.getPutawayId());
            List<PutawayDetailEntity> putawayDetailList = putawayEntity.getPutawayDetailList();
            List<IdleFlowVO> idleFlowVOList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(putawayDetailList)){
                for (PutawayDetailEntity putawayDetailEntity : putawayDetailList){
                    if (putawayDetailEntity.getId().equals(entity.getPutawayDetailId())){
                        IdleFlowVO idleFlowVO = putawayBpmService.getIdleFlowVO(putawayEntity, putawayDetailEntity, 1);
                        idleFlowVO.setNum(ComputeUtil.safeSub(BigDecimal.ZERO,entity.getRotatableNums()));
                        idleFlowVOList.add(idleFlowVO);
                    }
                }
            }

            CommonResponse<String> stringCommonResponse = idleManageApi.inOutStore(idleFlowVOList);
            if(!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }

        return vo;
    }

}
