package com.ejianc.foundation.print.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Component;

@Component
public class TemplateVO extends BaseVO {

    /**
     * 通用模板
     */
    public static final String TEMPLATE_TYPE_UNIVERSAL = "1";
    /**
     * 自定义模板
     */
    public static final String TEMPLATE_TYPE_CUSTOM = "2";
    private static final long serialVersionUID = 7990232943880627089L;

    /**
     * 模板编码
     */
    private String templateCode;
    /**
     * 模板名称
     */
    private String templateName;
    /**
     * 模板对应业务对象编码
     */
    private String boCode;

    /**
     * 模板内容
     */
    private String content;

    /**
     * 模板类型：1-自定义表单模板，2-普通模板
     */
    private String templateType;

    /**
     * 模板字段间关系
     */
    private String fieldRelationJson;

    /**
     * 数据查询Url
     */
    private String detailUrl;

    /**
     * 单据类型主键Id
     */
    private Long billTypeId;

    /**
     * 单据类型编号
     */
    private String billTypeCode;

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getFieldRelationJson() {
        return fieldRelationJson;
    }

    public void setFieldRelationJson(String fieldRelationJson) {
        this.fieldRelationJson = fieldRelationJson;
    }

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    @ReferSerialTransfer(referCode="billType")
    public Long getBillTypeId() {
        return billTypeId;
    }

    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public String getBoCode() {
        return boCode;
    }

    public void setBoCode(String boCode) {
        this.boCode = boCode;
    }
}
