/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.model.TemplatePageModel;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.TemplateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/template/"})
public class TemplateController {
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IBusinessObjectService businessObjectService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.templateService.queryPage(queryParam, false);
        resp.put("data", (Object)pageData);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"save"})
    public CommonResponse<TemplateVO> save(@RequestBody TemplateVO templateVO) {
        TemplateVO resp = null;
        TemplateEntity dbEntity = null;
        if ("1".equals(templateVO.getTemplateType())) {
            if (null == templateVO.getId()) {
                TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), InvocationInfoProxy.getTenantid());
                if (null != entityByCode) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
                }
                CommonResponse billType = this.billTypeApi.getById(templateVO.getBillTypeId());
                CommonResponse clsResp = this.mdClassApi.queryDetail(((BillTypeVO)billType.getData()).getMetadataId());
                if (1 == clsResp.getCode()) {
                    this.logger.error("\u4fdd\u5b58\u6a21\u677f\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25: " + clsResp.getMsg());
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25\uff01");
                }
                BusinessObjectEntity bo = this.businessObjectService.getByEntityIdAndProjectId(((MdClassVO)clsResp.getData()).getId(), ((MdClassVO)clsResp.getData()).getProjectId());
                if (null == bo) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7c7b\u578b\u4e0b\u4e3a\u521b\u5efa\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u6e90\uff01");
                }
                dbEntity = (TemplateEntity)((Object)BeanMapper.map((Object)templateVO, TemplateEntity.class));
                dbEntity.setBoId(bo.getId());
            } else {
                dbEntity = this.templateService.detail(templateVO.getId());
                dbEntity.setTemplateName(templateVO.getTemplateName());
                dbEntity.setDetailUrl(templateVO.getDetailUrl());
            }
        }
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        resp = (TemplateVO)BeanMapper.map(dbEntity, TemplateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"saveDesign"})
    public CommonResponse<String> saveDesign(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detail(templateVO.getId());
        dbEntity.setContent(templateVO.getContent());
        TemplatePageModel model = new TemplatePageModel(templateVO.getContent());
        dbEntity.setFieldRelationJson(model.getRelationJson());
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"copyTemplate"})
    public CommonResponse<String> copyTemplate(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detail(templateVO.getId());
        TemplateEntity saveEntity = new TemplateEntity();
        saveEntity.setTemplateCode(templateVO.getTemplateCode());
        saveEntity.setTemplateName(templateVO.getTemplateName());
        saveEntity.setContent(dbEntity.getContent());
        saveEntity.setFieldRelationJson(dbEntity.getFieldRelationJson());
        saveEntity.setBoId(dbEntity.getBoId());
        saveEntity.setBillTypeId(dbEntity.getBillTypeId());
        saveEntity.setTemplateType(dbEntity.getTemplateType());
        this.templateService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)"\u6a21\u677f\u590d\u5236\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<TemplateVO> detail(@RequestParam Long id) {
        TemplateEntity dbEntity = this.templateService.detail(id);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"checkCode"})
    public CommonResponse<String> checkCode(@RequestBody QueryParam queryParam) {
        List list = this.templateService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<TemplateVO> detailByCode(@RequestParam String code) {
        TemplateEntity dbEntity = this.templateService.detailByCode(code, InvocationInfoProxy.getTenantid());
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody Long id) {
        this.templateService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

