package com.ejianc.foundation.print.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_print_template")
public class TemplateEntity extends BaseEntity {

    private static final long serialVersionUID = -6680697857049690363L;

    /**
     * 单据类型主键Id
     */
    @TableField(value = "bill_type_id")
    private Long billTypeId;

    /**
     * 单据类型编号
     */
    @TableField(value = "bill_type_code")
    private String billTypeCode;

    /**
     * 模板编码
     */
    @TableField(value = "template_code")
    private String templateCode;
    /**
     * 模板名称
     */
    @TableField(value = "template_name")
    private String templateName;
    /**
     * 模板对应业务对象Id
     */
    @TableField(value = "bo_id")
    private Long boId;

    /**
     * 模板内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 模板类型：1-自定义表单模板，2-普通模板
     */
    @TableField(value = "template_type")
    private String templateType;

    /**
     * 模板字段间关系
     */
    @TableField(value = "field_relation_json")
    private String fieldRelationJson;

    /**
     * 数据查询Url
     */
    @TableField(value = "detail_url")
    private String detailUrl;

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Long getBoId() {
        return boId;
    }

    public void setBoId(Long boId) {
        this.boId = boId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getFieldRelationJson() {
        return fieldRelationJson;
    }

    public void setFieldRelationJson(String fieldRelationJson) {
        this.fieldRelationJson = fieldRelationJson;
    }

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    public Long getBillTypeId() {
        return billTypeId;
    }

    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
}
