package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/bomanage/")
public class BusinessObjectController {

    @Autowired
    private IBusinessObjectService businessObjectService;

    @Autowired
    private IMdClassApi mdClassApi;

    @Autowired
    private IMdProjectApi mdProjectApi;

    @PostMapping("save")
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if(null != vo.getId()) {
            dbEntity = businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
        } else {
            dbEntity = businessObjectService.getByCode(vo.getCode(), InvocationInfoProxy.getTenantid());
            if(null != dbEntity) {

            } else {
                dbEntity = BeanMapper.map(vo, BusinessObjectEntity.class);
            }
        }
        businessObjectService.saveOrUpdate(dbEntity, false);

        return CommonResponse.success("保存业务对象成功！", BeanMapper.map(dbEntity, BusinessObjectVO.class));
    }

    @PostMapping("page")
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<BusinessObjectEntity> pagData = businessObjectService.queryPage(param, false);
        resp.put("data", pagData);
        return CommonResponse.success(resp);
    }

    @PostMapping("delete")
    public CommonResponse<String> del(@RequestBody Long id) {
        businessObjectService.removeById(id, false);
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("detail")
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = businessObjectService.queryDetail(id);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        CommonResponse<MdProjectVO> projectResp = mdProjectApi.queryDetail(entity.getProjectId());
        CommonResponse<MdClassVO> clsResp = mdClassApi.queryDetail(entity.getEntityId());
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        vo.setProject(projectResp.getData());
        vo.setEntity(clsResp.getData());
        return CommonResponse.success(vo);
    }

    @GetMapping("boCheck")
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = businessObjectService.getByCode(code, InvocationInfoProxy.getTenantid());
        if(null != e) {
            vo = BeanMapper.map(e, BusinessObjectVO.class);
        }

        return CommonResponse.success(vo);
    }

}
