package com.ejianc.foundation.print.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * 模板页面模型
 */
public class TemplatePageModel {

    private List<Map> panels;

    /**表格字段*/
    private List<BaseFieldModel> panelsFields;

    public TemplatePageModel(String designContent) {
        Map<String, Object> content = JSONObject.parseObject(designContent, Map.class);
        panels = (List<Map>) content.get("panels");
    }

    /**
     * 解析字段关系：
     *
     * @return
     */
    public String getRelationJson() {
        String jsonResp = "";
        Map<String, BaseFieldModel> relationMap = new HashMap<>();
        List<BaseFieldModel> fields = new ArrayList<>();
        BaseFieldModel parent = null, curField = null;
        List<BaseFieldModel> panelRealtion = new ArrayList<>();
        Map<String, Object> column = null;


        if(CollectionUtils.isNotEmpty(panels)) {
            Map<String, Object> options = null;
            for(Map panelMap : panels) {
//                统计所有页面中的所有字段
                fields.addAll(JSONArray.parseArray(JSONArray.toJSONString(panelMap.get("printElements")), BaseFieldModel.class));
            }
            if(CollectionUtils.isNotEmpty(fields)) {
                String fileCodeStr = null, curItemField = null, parentField = null;
                for(BaseFieldModel field : fields) {
                    options = field.getOptions();
                    if(null == options.get("field")) {
                        //非数据字段跳过
                        continue;
                    }
                    fileCodeStr = options.get("field").toString();
                    curItemField = fileCodeStr.substring(fileCodeStr.lastIndexOf(".")+1);
                    if(fileCodeStr.contains(".")) {
                        parentField = fileCodeStr.substring(0, fileCodeStr.lastIndexOf("."));
                    }
                    field.setName(options.get("title").toString());
                    field.setCode(curItemField);
                    field.setParentCode(parentField);
                    panelRealtion.add(field);
                }
            }

            jsonResp = JSONArray.toJSONString(panelRealtion);
        }
        return jsonResp;
    }

    public List<Map> getPanels() {
        return panels;
    }

    public void setPanels(List<Map> panels) {
        this.panels = panels;
    }

    public List<BaseFieldModel> getPanelsFields() {
        return panelsFields;
    }

    public void setPanelsFields(List<BaseFieldModel> panelsFields) {
        this.panelsFields = panelsFields;
    }
}
