/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bomanage/"})
public class BusinessObjectController {
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANT_ID;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IMdProjectApi mdProjectApi;

    @PostMapping(value={"save"})
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if (null != vo.getId()) {
            dbEntity = this.businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
        } else {
            dbEntity = this.businessObjectService.getByCode(vo.getCode(), InvocationInfoProxy.getTenantid());
            if (null == dbEntity) {
                dbEntity = (BusinessObjectEntity)((Object)BeanMapper.map((Object)vo, BusinessObjectEntity.class));
            }
        }
        this.businessObjectService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)dbEntity), BusinessObjectVO.class));
    }

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pagData = this.businessObjectService.queryPage(param, false);
        resp.put("data", (Object)pagData);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> del(@RequestBody Long id) {
        this.businessObjectService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = this.businessObjectService.queryDetail(id);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse projectResp = this.mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse clsResp = this.mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject((MdProjectVO)projectResp.getData());
        vo.setEntity((MdClassVO)clsResp.getData());
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value="tenantId", required=false) Long tenantId) {
        BusinessObjectEntity entity = this.businessObjectService.getByCode(code, null != tenantId ? tenantId : this.BASE_TENANT_ID);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"boCheck"})
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = this.businessObjectService.getByCode(code, InvocationInfoProxy.getTenantid());
        if (null != e) {
            vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)e), BusinessObjectVO.class);
        }
        return CommonResponse.success(vo);
    }
}

