/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.model.TemplatePageModel;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.TemplateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/template/"})
public class TemplateController {
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANT_ID;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBusinessObjectService businessObjectService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c21 = new ComplexParam();
        Long rootOrgId = null;
        CommonResponse orgVO = this.orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
        if (orgVO.isSuccess() && orgVO.getData() != null) {
            rootOrgId = ((OrgVO)orgVO.getData()).getId();
            c21.setLogic("or");
            c21.getParams().put("orgId", new Parameter("eq", (Object)rootOrgId));
        }
        ComplexParam c22 = new ComplexParam();
        c22.setLogic("or");
        c22.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("tenantId", new Parameter("eq", (Object)this.BASE_TENANT_ID));
        if (rootOrgId != null) {
            c1.getComplexParams().add(c21);
        }
        c1.getComplexParams().add(c22);
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.templateService.queryPage(queryParam, false);
        Page data = new Page();
        data.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), TemplateVO.class));
        data.setPages(pageData.getPages());
        data.setCurrent(pageData.getCurrent());
        data.setSize(pageData.getSize());
        data.setTotal(pageData.getTotal());
        resp.put("data", (Object)data);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"save"})
    public CommonResponse<TemplateVO> save(@RequestBody TemplateVO templateVO) {
        boolean isEditUniversalTemplate;
        TemplateVO resp = null;
        TemplateEntity dbEntity = null;
        Long curTenantId = InvocationInfoProxy.getTenantid();
        boolean bl = isEditUniversalTemplate = null != templateVO.getTenantId() && !curTenantId.equals(templateVO.getTenantId());
        if (isEditUniversalTemplate || null == templateVO.getId()) {
            TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if (null != entityByCode) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            CommonResponse billType = this.billTypeApi.getById(templateVO.getBillTypeId());
            CommonResponse clsResp = this.mdClassApi.queryDetail(((BillTypeVO)billType.getData()).getMetadataId());
            if (1 == clsResp.getCode()) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25: " + clsResp.getMsg());
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25\uff01");
            }
            BusinessObjectEntity bo = this.businessObjectService.getByEntityIdAndProjectId(((MdClassVO)clsResp.getData()).getId(), ((MdClassVO)clsResp.getData()).getProjectId());
            if (null == bo) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7c7b\u578b\u4e0b\u672a\u521b\u5efa\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u6e90\uff01");
            }
            dbEntity = (TemplateEntity)((Object)BeanMapper.map((Object)templateVO, TemplateEntity.class));
            dbEntity.setBoCode(bo.getCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
            if (this.BASE_TENANT_ID.equals(curTenantId) || isEditUniversalTemplate) {
                dbEntity.setTemplateType("1");
            } else {
                dbEntity.setTemplateType("2");
            }
            if (isEditUniversalTemplate) {
                dbEntity.setId(null);
                dbEntity.setCreateTime(null);
                dbEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                dbEntity.setUpdateTime(null);
                dbEntity.setCreateUserCode(null);
            }
        } else {
            dbEntity = this.templateService.detail(templateVO.getId());
            TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if (null != entityByCode && !entityByCode.getId().equals(dbEntity.getId())) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            dbEntity.setTemplateName(templateVO.getTemplateName());
            dbEntity.setDetailUrl(templateVO.getDetailUrl());
            dbEntity.setTemplateCode(templateVO.getTemplateCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
        }
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        resp = (TemplateVO)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"saveDesign"})
    public CommonResponse<String> saveDesign(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detailByCode(templateVO.getTemplateCode(), InvocationInfoProxy.getTenantid());
        dbEntity.setContent(templateVO.getContent());
        TemplatePageModel model = new TemplatePageModel(templateVO.getContent());
        dbEntity.setFieldRelationJson(model.getRelationJson());
        dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"copyTemplate"})
    public CommonResponse<String> copyTemplate(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detail(templateVO.getId());
        TemplateEntity saveEntity = new TemplateEntity();
        Long curTenantId = InvocationInfoProxy.getTenantid();
        TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
        if (null != entityByCode) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        saveEntity.setTemplateCode(templateVO.getTemplateCode());
        saveEntity.setTemplateName(templateVO.getTemplateName());
        saveEntity.setContent(dbEntity.getContent());
        saveEntity.setFieldRelationJson(dbEntity.getFieldRelationJson());
        saveEntity.setBoCode(dbEntity.getBoCode());
        saveEntity.setBillTypeId(dbEntity.getBillTypeId());
        saveEntity.setBillTypeCode(dbEntity.getBillTypeCode());
        saveEntity.setTemplateType(dbEntity.getTemplateType());
        saveEntity.setTenantId(curTenantId);
        saveEntity.setOrgId(InvocationInfoProxy.getOrgId());
        if (this.BASE_TENANT_ID.equals(curTenantId)) {
            saveEntity.setTemplateType("1");
        } else {
            saveEntity.setTemplateType("2");
        }
        this.templateService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)"\u6a21\u677f\u590d\u5236\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<TemplateVO> detail(@RequestParam Long id) {
        TemplateEntity dbEntity = this.templateService.detail(id);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"checkCode"})
    public CommonResponse<String> checkCode(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.templateService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<TemplateVO> detailByCode(@RequestParam String code) {
        TemplateEntity dbEntity = this.templateService.detailByCode(code, InvocationInfoProxy.getTenantid());
        if (null == dbEntity) {
            dbEntity = this.templateService.detailByCode(code, this.BASE_TENANT_ID);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody Long id) {
        this.templateService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"queryList"})
    public CommonResponse<List<TemplateVO>> queryList(@RequestBody TemplateVO templateVO) {
        CommonResponse orgVO;
        List voList = new ArrayList();
        QueryParam queryParam = new QueryParam();
        if (null != templateVO.getBillTypeId()) {
            queryParam.getParams().put("billTypeId", new Parameter("eq", (Object)templateVO.getBillTypeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)templateVO.getBillTypeCode())) {
            queryParam.getParams().put("billTypeCode", new Parameter("eq", (Object)templateVO.getBillTypeCode()));
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List list = new ArrayList();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        list = this.templateService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(list) && (orgVO = this.orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid())).isSuccess() && orgVO.getData() != null) {
            if (!((OrgVO)orgVO.getData()).getId().equals(InvocationInfoProxy.getOrgId())) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)((OrgVO)orgVO.getData()).getId()));
                list = this.templateService.queryList(queryParam, false);
            }
            if (CollectionUtils.isEmpty(list) && !tenantId.equals(this.BASE_TENANT_ID)) {
                queryParam.getParams().remove("orgId");
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.BASE_TENANT_ID));
                list = this.templateService.queryList(queryParam, false);
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, TemplateVO.class);
        }
        return CommonResponse.success(voList);
    }
}

