package com.ejianc.foundation.print.controller;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.model.TemplatePageModel;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.vo.TemplateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/template/")
public class TemplateController {

    @Value("${oms.tenantid}")
    private Long BASE_TENANT_ID;

    @Autowired
    private ITemplateService templateService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMdClassApi mdClassApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBusinessObjectService businessObjectService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 分页查询模板列表
     *
     * @param queryParam
     * @return
     */
    @PostMapping("page")
    public CommonResponse<JSONObject> page(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        //查询所有通用模板和用户自定义（非修改通用模板而来的模板）
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

//        ComplexParam c2 = new ComplexParam();
//        c2.setLogic(ComplexParam.OR);
//        c2.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        ComplexParam c21 = new ComplexParam();
        //获取租户根组织id
       /* 
        * 获取本级+租户根组织
        Long rootOrgId = null;
        CommonResponse<OrgVO> orgVO = orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
        if(orgVO.isSuccess()&&orgVO.getData()!=null){
        	rootOrgId = orgVO.getData().getId();
            c21.setLogic(ComplexParam.OR);
            c21.getParams().put("orgId", new Parameter(QueryParam.EQ, rootOrgId));
        }

        ComplexParam c22 = new ComplexParam();
        c22.setLogic(ComplexParam.OR);
        c22.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
*/
        //获取本上组织
    	List<Long> orgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgList = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if(orgList.isSuccess()&&orgList.getData()!=null&&orgList.getData().size()>0){
        	orgList.getData().forEach(e -> {
        		orgIds.add(e.getId());
        	});
	        c21.setLogic(ComplexParam.OR);
	        c21.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }
        
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("tenantId", new Parameter(QueryParam.EQ, BASE_TENANT_ID));

//        if(rootOrgId!=null){
//        	c1.getComplexParams().add(c21);
//        }
//        c1.getComplexParams().add(c2);
//      c1.getComplexParams().add(c22);
        if(orgIds!=null&&orgIds.size()>0){
        	c1.getComplexParams().add(c21);
        }
        
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);

        queryParam.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<TemplateEntity> pageData = templateService.queryPage(queryParam, false);

        IPage<TemplateVO> data = new Page<>();
        data.setRecords(BeanMapper.mapList(pageData.getRecords(), TemplateVO.class));
        data.setPages(pageData.getPages());
        data.setCurrent(pageData.getCurrent());
        data.setSize(pageData.getSize());
        data.setTotal(pageData.getTotal());
        resp.put("data", data);
        return CommonResponse.success(resp);
    }

    /**
     * 模板新增、更新
     *
     * @param templateVO
     * @return
     */
    @PostMapping("save")
    public CommonResponse<TemplateVO> save(@RequestBody TemplateVO templateVO) {
        TemplateVO resp = null;
        TemplateEntity dbEntity = null;
        Long curTenantId = InvocationInfoProxy.getTenantid();
        //是否是其他租户修改通用模板
        boolean isEditUniversalTemplate = (null != templateVO.getTenantId() && !curTenantId.equals(templateVO.getTenantId()));
        if(isEditUniversalTemplate || null == templateVO.getId()) {
            TemplateEntity entityByCode = templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if(null != entityByCode) {
                return CommonResponse.error("保存失败，编码重复！");
            }
            //根据单据类型找到单据类型对应的元数据Id
            CommonResponse<BillTypeVO> billType = billTypeApi.getById(templateVO.getBillTypeId());
            CommonResponse<MdClassVO> clsResp = mdClassApi.queryDetail(billType.getData().getMetadataId());
            if(1 == clsResp.getCode()) {
                logger.error("保存模板失败，查询单据对应元数据源失败: " + clsResp.getMsg());
                return CommonResponse.error("保存失败，查询单据对应元数据源失败！");
            }
            BusinessObjectEntity bo = businessObjectService.getByEntityIdAndProjectId(clsResp.getData().getId(), clsResp.getData().getProjectId());
            if(null == bo) {
                return CommonResponse.error("保存失败，该单据类型下未创建业务对象数据源！");
            }
            dbEntity = BeanMapper.map(templateVO, TemplateEntity.class);
            dbEntity.setBoCode(bo.getCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
            if(BASE_TENANT_ID.equals(curTenantId) || isEditUniversalTemplate) {
                //运营平台运用创建的为通用模板
                dbEntity.setTemplateType(TemplateVO.TEMPLATE_TYPE_UNIVERSAL);
            } else{
                //其他租户创建的为用户自定义模板
                dbEntity.setTemplateType(TemplateVO.TEMPLATE_TYPE_CUSTOM);
            }
            if(isEditUniversalTemplate) {
                dbEntity.setId(null);
                dbEntity.setCreateTime(null);
                dbEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                dbEntity.setUpdateTime(null);
                dbEntity.setCreateUserCode(null);
            }
        } else {
            dbEntity = templateService.detail(templateVO.getId());
            TemplateEntity entityByCode = templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if(null != entityByCode && !entityByCode.getId().equals(dbEntity.getId())) {
                return CommonResponse.error("保存失败，编码重复！");
            }
            dbEntity.setTemplateName(templateVO.getTemplateName());
            dbEntity.setDetailUrl(templateVO.getDetailUrl());
            dbEntity.setTemplateCode(templateVO.getTemplateCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
        }

        templateService.saveOrUpdate(dbEntity, false);
        resp = BeanMapper.map(dbEntity, TemplateVO.class);

        return CommonResponse.success("保存成功！", resp);
    }


    @PostMapping("saveDesign")
    public CommonResponse<String> saveDesign(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = templateService.detailByCode(templateVO.getTemplateCode(), InvocationInfoProxy.getTenantid());
        dbEntity.setContent(templateVO.getContent());
        TemplatePageModel model = new TemplatePageModel(templateVO.getContent());
        dbEntity.setFieldRelationJson(model.getRelationJson());
        dbEntity.setOrgId(InvocationInfoProxy.getOrgId());

        templateService.saveOrUpdate(dbEntity, false);
        return CommonResponse.success("保存成功！");
    }

    /**
     * 模板复制
     *
     * @param templateVO
     * @return
     */
    @PostMapping("copyTemplate")
    public CommonResponse<String> copyTemplate(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = templateService.detail(templateVO.getId());
        TemplateEntity saveEntity = new TemplateEntity();
        Long curTenantId = InvocationInfoProxy.getTenantid();

        TemplateEntity entityByCode = templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
        if(null != entityByCode) {
            return CommonResponse.error("保存失败，编码重复！");
        }

        saveEntity.setTemplateCode(templateVO.getTemplateCode());
        saveEntity.setTemplateName(templateVO.getTemplateName());
        saveEntity.setContent(dbEntity.getContent());
        saveEntity.setFieldRelationJson(dbEntity.getFieldRelationJson());
        saveEntity.setBoCode(dbEntity.getBoCode());
        saveEntity.setBillTypeId(dbEntity.getBillTypeId());
        saveEntity.setBillTypeCode(dbEntity.getBillTypeCode());
        saveEntity.setTemplateType(dbEntity.getTemplateType());
        saveEntity.setTenantId(curTenantId);
        saveEntity.setOrgId(InvocationInfoProxy.getOrgId());
        if(BASE_TENANT_ID.equals(curTenantId)) {
            //运营平台运用创建的为通用模板
            saveEntity.setTemplateType(TemplateVO.TEMPLATE_TYPE_UNIVERSAL);
        } else{
            //其他租户创建的为用户自定义模板
            saveEntity.setTemplateType(TemplateVO.TEMPLATE_TYPE_CUSTOM);
        }
        templateService.saveOrUpdate(saveEntity, false);

        return CommonResponse.success("模板复制成功！");
    }

    /**
     * 根据主键Id查询模板详情
     *
     * @param id
     * @return
     */
    @GetMapping("detail")
    public CommonResponse<TemplateVO> detail(@RequestParam Long id) {
        TemplateEntity dbEntity = templateService.detail(id);
        return CommonResponse.success(BeanMapper.map(dbEntity, TemplateVO.class));
    }

    @PostMapping("checkCode")
    public CommonResponse<String> checkCode(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<TemplateEntity> list = templateService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("编码重复！");
        }
        return CommonResponse.success("编码可以使用！");
    }

    /**
     * 根据code查询模板详情
     *
     * @param code
     * @return
     */
    @GetMapping("detailByCode")
    public CommonResponse<TemplateVO> detailByCode(@RequestParam String code) {
        TemplateEntity dbEntity = templateService.detailByCode(code, InvocationInfoProxy.getTenantid());
        if(null == dbEntity) {
            //查询公共模板
            dbEntity = templateService.detailByCode(code, BASE_TENANT_ID);
        }
        return CommonResponse.success(BeanMapper.map(dbEntity, TemplateVO.class));
    }

    /**
     * 根据主键code、租户Id删除对应模板
     *
     * @param id
     * @return
     */
    @PostMapping("delete")
    public CommonResponse<String> delete(@RequestBody Long id) {
        templateService.removeById(id, false);

        return CommonResponse.success("删除成功！");
    }

    /**
     * 租户打印模板查询
     *
     * @param templateVO
     * @return
     */
    @PostMapping(value = "queryList")
    public CommonResponse<List<TemplateVO>> queryList(@RequestBody TemplateVO templateVO) {
        List<TemplateVO> voList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        if(null != templateVO.getBillTypeId()) {
            queryParam.getParams().put("billTypeId", new Parameter(QueryParam.EQ, templateVO.getBillTypeId()));
        }
        if(StringUtils.isNotBlank(templateVO.getBillTypeCode())) {
            queryParam.getParams().put("billTypeCode", new Parameter(QueryParam.EQ, templateVO.getBillTypeCode()));
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<TemplateEntity> list = new ArrayList<>();
        
    	//先获取本上组织的模板，若模板不存在，则取平台模板
    	List<Long> orgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgList = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if(orgList.isSuccess()&&orgList.getData()!=null&&orgList.getData().size()>0){
        	orgList.getData().forEach(e -> {
        		orgIds.add(e.getId());
        	});
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }
        list = templateService.queryList(queryParam, false);
        if(CollectionUtils.isEmpty(list)) {
            //查询公共模板
        	queryParam.getParams().remove("orgId");
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, BASE_TENANT_ID));
            list = (templateService.queryList(queryParam, false));
        }
        
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, TemplateVO.class);
        }
        
        /*
         * 无组织时查询的逻辑
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        List<TemplateEntity> list = templateService.queryList(queryParam, false);
        if(CollectionUtils.isEmpty(list) && !tenantId.equals(BASE_TENANT_ID)) {
            //查询公共模板
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, BASE_TENANT_ID));
            list = (templateService.queryList(queryParam, false));
        }
        if(CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, TemplateVO.class);
        }
         */
        return CommonResponse.success(voList);
    }
}
