package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/bomanage/")
public class BusinessObjectController {

    @Value("${oms.tenantid}")
    private Long BASE_TENANT_ID;

    @Autowired
    private IBusinessObjectService businessObjectService;

    @Autowired
    private IMdClassApi mdClassApi;

    @Autowired
    private IMdProjectApi mdProjectApi;

    @PostMapping("save")
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if(null != vo.getId()) {
            dbEntity = businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
            dbEntity.setQrcode(vo.getQrcode());
        } else {
            dbEntity = businessObjectService.getByCode(vo.getCode(), InvocationInfoProxy.getTenantid());
            if(null != dbEntity) {

            } else {
                dbEntity = BeanMapper.map(vo, BusinessObjectEntity.class);
            }
        }
        businessObjectService.saveOrUpdate(dbEntity, false);

        return CommonResponse.success("保存业务对象成功！", BeanMapper.map(dbEntity, BusinessObjectVO.class));
    }

    @PostMapping("page")
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<BusinessObjectEntity> pagData = businessObjectService.queryPage(param, false);
        resp.put("data", pagData);
        return CommonResponse.success(resp);
    }

    @PostMapping("delete")
    public CommonResponse<String> del(@RequestBody Long id) {
        businessObjectService.removeById(id, false);
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("detail")
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = businessObjectService.queryDetail(id);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse<MdProjectVO> projectResp = mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse<MdClassVO> clsResp = mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject(projectResp.getData());
        vo.setEntity(clsResp.getData());
    }

    @GetMapping("detailByCode")
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value = "tenantId", required = false) Long tenantId) {
        BusinessObjectEntity entity = businessObjectService.getByCode(code, null != tenantId ? tenantId : BASE_TENANT_ID);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }


    @GetMapping("boCheck")
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = businessObjectService.getByCode(code, InvocationInfoProxy.getTenantid());
        if(null != e) {
            vo = BeanMapper.map(e, BusinessObjectVO.class);
        }

        return CommonResponse.success(vo);
    }

}
