/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.util.DataTransferUtil;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.foundation.print.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bomanage/"})
public class BusinessObjectController {
    private Gson gson = new Gson();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANT_ID;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IMdProjectApi mdProjectApi;

    @PostMapping(value={"save"})
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if (null != vo.getId()) {
            dbEntity = this.businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
            dbEntity.setQrcode(vo.getQrcode());
        } else {
            dbEntity = this.businessObjectService.getByCode(vo.getCode(), InvocationInfoProxy.getTenantid());
            if (null == dbEntity) {
                dbEntity = (BusinessObjectEntity)((Object)BeanMapper.map((Object)vo, BusinessObjectEntity.class));
            }
        }
        this.businessObjectService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)dbEntity), BusinessObjectVO.class));
    }

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pagData = this.businessObjectService.queryPage(param, false);
        resp.put("data", (Object)pagData);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> del(@RequestBody Long id) {
        this.businessObjectService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = this.businessObjectService.queryDetail(id);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse projectResp = this.mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse clsResp = this.mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject((MdProjectVO)projectResp.getData());
        vo.setEntity((MdClassVO)clsResp.getData());
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value="tenantId", required=false) Long tenantId) {
        BusinessObjectEntity entity = this.businessObjectService.getByCode(code, null != tenantId ? tenantId : this.BASE_TENANT_ID);
        if (null == entity) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        BusinessObjectVO vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)entity), BusinessObjectVO.class);
        this.fillAttrDetail(vo);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"boCheck"})
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = this.businessObjectService.getByCode(code, InvocationInfoProxy.getTenantid());
        if (null != e) {
            vo = (BusinessObjectVO)BeanMapper.map((Object)((Object)e), BusinessObjectVO.class);
        }
        return CommonResponse.success(vo);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
                return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
            }
            baseEntities = (List)this.businessObjectService.listByIds(publishVO.getIdList());
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BusinessObjectEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getCode())) continue;
                    codes.add(entity.getCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids, List<String> codes) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long l : ids) {
            idStr = idStr + "'" + l + "',";
        }
        String codeStr = "";
        for (String code : codes) {
            codeStr = codeStr + "'" + code + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        codeStr = "(" + codeStr.substring(0, codeStr.lastIndexOf(",")) + ")";
        String string = "ejc_print_business_object";
        String deleteBaseSql = " delete from " + string + " where id in " + idStr;
        String deleteByCodeSql = " delete from " + string + " where dr =1 and code in " + codeStr;
        sqlList.add(deleteBaseSql);
        sqlList.add(deleteByCodeSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<BusinessObjectEntity> baseEntityList) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        return retList;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            ArrayList<Long> ids = null;
            ArrayList<String> codes = null;
            List baseEntities = null;
            if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
                throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
            }
            baseEntities = (List)this.businessObjectService.listByIds(publishVO.getIdList());
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList<String>(baseEntities.size());
                for (BusinessObjectEntity entity : baseEntities) {
                    if (entity.getId() != null) {
                        ids.add(entity.getId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entity.getCode())) continue;
                    codes.add(entity.getCode());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids, codes);
            List<String> insertSql = this.getInsertSql(baseEntities);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

