/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.model.TemplatePageModel;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.util.DataTransferUtil;
import com.ejianc.foundation.print.vo.PublishVO;
import com.ejianc.foundation.print.vo.TemplateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/template/"})
public class TemplateController {
    private Gson gson = new Gson();
    @Value(value="${oms.tenantid}")
    private Long BASE_TENANT_ID;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBusinessObjectService businessObjectService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> page(@RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c21 = new ComplexParam();
        ArrayList orgIds = new ArrayList();
        CommonResponse orgList = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (orgList.isSuccess() && orgList.getData() != null && ((List)orgList.getData()).size() > 0) {
            ((List)orgList.getData()).forEach(e -> orgIds.add(e.getId()));
            c21.setLogic("or");
            c21.getParams().put("orgId", new Parameter("in", orgIds));
        }
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("tenantId", new Parameter("eq", (Object)this.BASE_TENANT_ID));
        if (orgIds != null && orgIds.size() > 0) {
            c1.getComplexParams().add(c21);
        }
        if (InvocationInfoProxy.getTenantid().equals(999999L)) {
            System.out.println("\u5e73\u53f0");
        } else {
            c1.getComplexParams().add(c3);
        }
        queryParam.getComplexParams().add(c1);
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.templateService.queryPage(queryParam, false);
        Page data = new Page();
        data.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), TemplateVO.class));
        data.setPages(pageData.getPages());
        data.setCurrent(pageData.getCurrent());
        data.setSize(pageData.getSize());
        data.setTotal(pageData.getTotal());
        resp.put("data", (Object)data);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"save"})
    public CommonResponse<TemplateVO> save(@RequestBody TemplateVO templateVO) {
        boolean isEditUniversalTemplate;
        TemplateVO resp = null;
        TemplateEntity dbEntity = null;
        Long curTenantId = InvocationInfoProxy.getTenantid();
        boolean bl = isEditUniversalTemplate = null != templateVO.getTenantId() && !curTenantId.equals(templateVO.getTenantId());
        if (isEditUniversalTemplate || null == templateVO.getId()) {
            TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if (null != entityByCode) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            CommonResponse billType = this.billTypeApi.getById(templateVO.getBillTypeId());
            CommonResponse clsResp = this.mdClassApi.queryDetail(((BillTypeVO)billType.getData()).getMetadataId());
            if (1 == clsResp.getCode()) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25: " + clsResp.getMsg());
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u5355\u636e\u5bf9\u5e94\u5143\u6570\u636e\u6e90\u5931\u8d25\uff01");
            }
            BusinessObjectEntity bo = this.businessObjectService.getByEntityIdAndProjectId(((MdClassVO)clsResp.getData()).getId(), ((MdClassVO)clsResp.getData()).getProjectId());
            if (null == bo) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u5355\u636e\u7c7b\u578b\u4e0b\u672a\u521b\u5efa\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u6e90\uff01");
            }
            dbEntity = (TemplateEntity)((Object)BeanMapper.map((Object)templateVO, TemplateEntity.class));
            dbEntity.setBoCode(bo.getCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
            if (this.BASE_TENANT_ID.equals(curTenantId) || isEditUniversalTemplate) {
                dbEntity.setTemplateType("1");
            } else {
                dbEntity.setTemplateType("2");
            }
            if (isEditUniversalTemplate) {
                dbEntity.setId(null);
                dbEntity.setCreateTime(null);
                dbEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                dbEntity.setUpdateTime(null);
                dbEntity.setCreateUserCode(null);
            }
        } else {
            dbEntity = this.templateService.detail(templateVO.getId());
            TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
            if (null != entityByCode && !entityByCode.getId().equals(dbEntity.getId())) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
            dbEntity.setTemplateName(templateVO.getTemplateName());
            dbEntity.setDetailUrl(templateVO.getDetailUrl());
            dbEntity.setTemplateCode(templateVO.getTemplateCode());
            dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
        }
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        resp = (TemplateVO)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"saveDesign"})
    public CommonResponse<String> saveDesign(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detailByCode(templateVO.getTemplateCode(), InvocationInfoProxy.getTenantid());
        dbEntity.setContent(templateVO.getContent());
        TemplatePageModel model = new TemplatePageModel(templateVO.getContent());
        dbEntity.setFieldRelationJson(model.getRelationJson());
        dbEntity.setOrgId(InvocationInfoProxy.getOrgId());
        this.templateService.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"copyTemplate"})
    public CommonResponse<String> copyTemplate(@RequestBody TemplateVO templateVO) {
        TemplateEntity dbEntity = this.templateService.detail(templateVO.getId());
        TemplateEntity saveEntity = new TemplateEntity();
        Long curTenantId = InvocationInfoProxy.getTenantid();
        TemplateEntity entityByCode = this.templateService.detailByCode(templateVO.getTemplateCode(), curTenantId);
        if (null != entityByCode) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        saveEntity.setTemplateCode(templateVO.getTemplateCode());
        saveEntity.setTemplateName(templateVO.getTemplateName());
        saveEntity.setContent(dbEntity.getContent());
        saveEntity.setFieldRelationJson(dbEntity.getFieldRelationJson());
        saveEntity.setBoCode(dbEntity.getBoCode());
        saveEntity.setBillTypeId(dbEntity.getBillTypeId());
        saveEntity.setBillTypeCode(dbEntity.getBillTypeCode());
        saveEntity.setTemplateType(dbEntity.getTemplateType());
        saveEntity.setTenantId(curTenantId);
        saveEntity.setOrgId(InvocationInfoProxy.getOrgId());
        if (this.BASE_TENANT_ID.equals(curTenantId)) {
            saveEntity.setTemplateType("1");
        } else {
            saveEntity.setTemplateType("2");
        }
        this.templateService.saveOrUpdate((Object)saveEntity, false);
        return CommonResponse.success((String)"\u6a21\u677f\u590d\u5236\u6210\u529f\uff01");
    }

    @GetMapping(value={"detail"})
    public CommonResponse<TemplateVO> detail(@RequestParam Long id) {
        TemplateEntity dbEntity = this.templateService.detail(id);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"checkCode"})
    public CommonResponse<String> checkCode(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.templateService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u7f16\u7801\u91cd\u590d\uff01");
        }
        return CommonResponse.success((String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528\uff01");
    }

    @GetMapping(value={"detailByCode"})
    public CommonResponse<TemplateVO> detailByCode(@RequestParam String code) {
        TemplateEntity dbEntity = this.templateService.detailByCode(code, InvocationInfoProxy.getTenantid());
        if (null == dbEntity) {
            dbEntity = this.templateService.detailByCode(code, this.BASE_TENANT_ID);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)dbEntity), TemplateVO.class));
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody Long id) {
        this.templateService.removeById(id, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"queryList"})
    public CommonResponse<List<TemplateVO>> queryList(@RequestBody TemplateVO templateVO) {
        List voList = new ArrayList();
        QueryParam queryParam = new QueryParam();
        if (null != templateVO.getBillTypeId()) {
            queryParam.getParams().put("billTypeId", new Parameter("eq", (Object)templateVO.getBillTypeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)templateVO.getBillTypeCode())) {
            queryParam.getParams().put("billTypeCode", new Parameter("eq", (Object)templateVO.getBillTypeCode()));
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List list = new ArrayList();
        ArrayList orgIds = new ArrayList();
        CommonResponse orgList = this.orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
        if (orgList.isSuccess() && orgList.getData() != null && ((List)orgList.getData()).size() > 0) {
            ((List)orgList.getData()).forEach(e -> orgIds.add(e.getId()));
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        if (CollectionUtils.isEmpty(list = this.templateService.queryList(queryParam, false))) {
            if (InvocationInfoProxy.getTenantid().equals(999999L)) {
                System.out.println("\u5e73\u53f0");
            } else {
                queryParam.getParams().remove("orgId");
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)this.BASE_TENANT_ID));
                list = this.templateService.queryList(queryParam, false);
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, TemplateVO.class);
        }
        return CommonResponse.success(voList);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            Long orgId = this.getOrgId(targetEnv);
            if (orgId == null) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u8be5\u73af\u5883\u7684\u7ec4\u7ec7id!");
            }
            ArrayList<Long> ids = null;
            ArrayList codes = null;
            List baseEntities = null;
            if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
                return CommonResponse.error((String)"\u672a\u9009\u4e2d\u8981\u53d1\u5e03\u7684\u6570\u636e");
            }
            baseEntities = (List)this.templateService.listByIds(publishVO.getIdList());
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
                codes = new ArrayList(baseEntities.size());
                for (TemplateEntity entity : baseEntities) {
                    if (entity.getId() == null) continue;
                    ids.add(entity.getId());
                }
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids);
            List<String> insertSql = this.getInsertSql(baseEntities, orgId);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            String url = publishVO.getTarget() + "/ejc-support-web/dataTransfer/transferBySql";
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("sql", sqls);
            String paramterStr = this.gson.toJson(params);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u53d1\u5e03\u53c2\u7167\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
    }

    private List<String> getDeleteSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String idStr = "";
        for (Long id : ids) {
            idStr = idStr + "'" + id + "',";
        }
        idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
        String baseTableName = "ejc_print_template";
        String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
        sqlList.add(deleteBaseSql);
        return sqlList;
    }

    private List<String> getInsertSql(List<TemplateEntity> baseEntityList, Long orgId) throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> baseInsertSql = DataTransferUtil.getInsertSql2(baseEntityList, orgId);
        if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
            retList.addAll(baseInsertSql);
        }
        return retList;
    }

    private Long getOrgId(String targetEnv) {
        Long orgId = null;
        switch (targetEnv) {
            case "https://dev.17elian.com": {
                orgId = 1247777316689256450L;
                break;
            }
            case "https://portal.17elian.com": {
                orgId = 1247777316689256450L;
                break;
            }
            case "http://testqlh.baju.com.cn:8087": {
                orgId = 1247777316689256450L;
                break;
            }
            case "https://qlh.baju.com.cn": {
                orgId = 1247777316689256450L;
                break;
            }
            case "http://wei.cscec5b.com.cn:9082": {
                orgId = 1247777316689256450L;
                break;
            }
            case "http://wei.cscec5b.com.cn:9080": {
                orgId = 1247777316689256450L;
                break;
            }
        }
        return orgId;
    }

    @ResponseBody
    @RequestMapping(value={"/exportSQL"})
    public void exportSQL(HttpServletRequest req, HttpServletResponse response, @RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                throw new BusinessException("\u5bfc\u51fa\u811a\u672c\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            Long orgId = this.getOrgId(targetEnv);
            if (orgId == null) {
                throw new BusinessException("\u5bfc\u51fa\u811a\u672c\u5931\u8d25:\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u8be5\u73af\u5883\u7684\u7ec4\u7ec7id!");
            }
            ArrayList<Long> ids = null;
            List codes = null;
            List baseEntities = null;
            if (publishVO.getIdList() == null || publishVO.getIdList().size() <= 0) {
                throw new BusinessException("\u672a\u9009\u4e2d\u8981\u5bfc\u51fa\u811a\u672c\u7684\u6570\u636e!");
            }
            baseEntities = (List)this.templateService.listByIds(publishVO.getIdList());
            if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
                ids = new ArrayList<Long>(baseEntities.size());
            }
            ArrayList<String> sqls = new ArrayList<String>();
            List<String> deleteSql = this.getDeleteSql(ids);
            List<String> insertSql = this.getInsertSql(baseEntities, orgId);
            if (deleteSql != null && !deleteSql.isEmpty()) {
                sqls.addAll(deleteSql);
            }
            if (insertSql != null && !insertSql.isEmpty()) {
                sqls.addAll(insertSql);
            }
            StringBuffer fileName = new StringBuffer();
            fileName.append("billType.sql");
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            out.write(String.join((CharSequence)"\r\n", sqls).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.setStatus(400);
        }
    }
}

