package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/23 10:06
 */
@RestController
@RequestMapping("/commonPrint/")
public class DataPrintController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMdApi mdApi;
	@Autowired
	private ICustomTableApi customTableApi;

    /**
     * 通用打印数据获取
     *
     * @param id
     * @return
     */
    @GetMapping("printDetail")
    public CommonResponse<JSONObject> printDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "billType") String billType) {
    	CommonResponse<JSONObject> printData = new CommonResponse<JSONObject>();
    	if(billType.contains("CFS")){
    		JSONObject resp = new JSONObject();
    		CommonResponse<JSONObject> data = customTableApi.queryDetail(billType, id);
    		if(data.isSuccess()){
    			resp.put(billType, data.getData());
    			return CommonResponse.success(resp);
    		}else{
    			return CommonResponse.error(data.getMsg());
    		}
    	}else{
            //根据单据类型找到单据类型对应的元数据Id
            CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(billType);
            if(!billTypeVo.isSuccess()) {
                logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", billType);
                return CommonResponse.error("查询打印数据详情失败，获取对应单据类型信息失败！");
            }
            printData = mdApi.queryCommonPrintData(billTypeVo.getData().getMetadataId(), id);
    	}
        return printData;
    }
}
