package com.ejianc.foundation.print.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 模板字段模型
 */
public class BaseFieldModel {

    private String tid;
    /**
     * 属性：left、top、height、width、title、field 。。。。
     */
    private Map<String, Object> options;
    /**
     * 属性：field、title、type、columns。。。
     */
    private Map<String, Object> printElementType;


    //维护字段关系使用
    private String code;
    private String name;
    private String parentCode;
    private List<BaseFieldModel> subFields;

    public BaseFieldModel() {
        super();
    };

    public BaseFieldModel(String parentField, BaseFieldModel field) {
        this.code = parentField;
        parentCode = parentField.contains(".") ? parentField.substring(0, parentField.lastIndexOf(".")) : null;
        if(null == subFields) {
            subFields = new ArrayList<>();
        }
        subFields.add(field);
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public Map<String, Object> getOptions() {
        return options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public Map<String, Object> getPrintElementType() {
        return printElementType;
    }

    public void setPrintElementType(Map<String, Object> printElementType) {
        this.printElementType = printElementType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BaseFieldModel> getSubFields() {
        return subFields;
    }

    public void setSubFields(List<BaseFieldModel> subFields) {
        this.subFields = subFields;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}
