package com.ejianc.foundation.print.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.util.DataTransferUtil;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.foundation.print.vo.PublishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;

@RestController
@RequestMapping("/bomanage/")
public class BusinessObjectController {
	private Gson gson = new Gson();
	// 日志
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${oms.tenantid}")
    private Long BASE_TENANT_ID;

    @Autowired
    private IBusinessObjectService businessObjectService;

    @Autowired
    private IMdClassApi mdClassApi;

    @Autowired
    private IMdProjectApi mdProjectApi;

    @PostMapping("save")
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if(null != vo.getId()) {
            dbEntity = businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
            dbEntity.setQrcode(vo.getQrcode());
        } else {
			dbEntity = businessObjectService.getByCode(vo.getCode(), InvocationInfoProxy.getTenantid());
            if(null != dbEntity) {
				return CommonResponse.error("编码重复，保存失败！");
            } else {
                dbEntity = BeanMapper.map(vo, BusinessObjectEntity.class);
            }
        }
        businessObjectService.saveOrUpdate(dbEntity, false);

        return CommonResponse.success("保存业务对象成功！", BeanMapper.map(dbEntity, BusinessObjectVO.class));
    }

    @PostMapping("page")
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        resp.put("data", pageList(param));
        return CommonResponse.success(resp);
    }

	@GetMapping(value = "/pageRefer")
    public CommonResponse<IPage<BusinessObjectEntity>> pageRefer(@RequestParam(value = "pageNumber", required = false, defaultValue = "1") int pageNumber,
																 @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
																 @RequestParam(value = "relyCondition", required = false) String relyCondition,
																 @RequestParam(value = "condition", required = false) String condition,
																 @RequestParam(value = "searchText", required = false) String searchText) {
		QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, BASE_TENANT_ID));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);
		queryParam.setPageSize(pageSize);
		queryParam.setPageIndex(pageNumber);
		queryParam.setSearchText(searchText);

        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");

		return CommonResponse.success(pageList(queryParam));
	}

	private IPage<BusinessObjectEntity> pageList(QueryParam queryParam) {
		return businessObjectService.queryPage(queryParam, false);
    }

    @PostMapping("delete")
    public CommonResponse<String> del(@RequestBody Long id) {
        businessObjectService.removeById(id, false);
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("detail")
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = businessObjectService.queryDetail(id);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse<MdProjectVO> projectResp = mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse<MdClassVO> clsResp = mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject(projectResp.getData());
        vo.setEntity(clsResp.getData());
    }

    @GetMapping("detailByCode")
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value = "tenantId", required = false) Long tenantId) {
        BusinessObjectEntity entity = businessObjectService.getByCode(code, null != tenantId ? tenantId : BASE_TENANT_ID);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }

    @GetMapping(value = "detailForDatav")
    public CommonResponse<JSONArray> detailForDatav(@RequestParam Long id) {
		JSONArray resp = new JSONArray();
		BusinessObjectEntity entity = businessObjectService.queryDetail(id);
		if(null == entity) {
			return CommonResponse.error("业务对象不存在！");
		}

		if(StringUtils.isNotBlank(entity.getContent())) {
			JSONObject content = JSONObject.parseObject(entity.getContent());
			JSONObject boJson = JSONObject.parseObject(content.getString("bo"));
			JSONObject mainEntity = dataTranslate(content);
			resp.add(mainEntity);

			mainEntity.put("id", boJson.get("key"));
			mainEntity.put("code", boJson.get("bo_code"));
			mainEntity.put("title", boJson.get("bo_name"));
			mainEntity.put("fieldText", boJson.get("bo_name"));
			mainEntity.put("type", 0);
			mainEntity.put("isList", "1");
			mainEntity.put("expand", true);
			List<JSONObject> attrs = JSONArray.parseArray(boJson.getString("bo_attrs"), JSONObject.class);
			List<JSONObject> children = new ArrayList<>();

			for(JSONObject attr : attrs) {
				if(attr.containsKey("bo_attrs")) {
					parseEntityAttr(attr, resp);
				} else {
					children.add(dataTranslate(attr));
				}
			}
			mainEntity.put("children", children);
		}

		return CommonResponse.success(resp);
	}

	private JSONObject dataTranslate(JSONObject attr) {
    	JSONObject resp = new JSONObject();
		resp.put("id", attr.get("key"));
		resp.put("code", attr.get("fieldname"));
		resp.put("title", attr.get("name"));
		resp.put("type", 0);
		resp.put("isList", "1");
		resp.put("expand", true);
		resp.put("dataFormat", attr.getString("dataFormat"));
		resp.put("fieldText", attr.get("name"));

		return resp;
	}

	private void parseEntityAttr(JSONObject attrJson, JSONArray respArr) {
		JSONObject resp = dataTranslate(attrJson);
		List<JSONObject> attrs = JSONArray.parseArray(attrJson.getString("bo_attrs"), JSONObject.class);
		List<JSONObject> children = new ArrayList<>();

		resp.put("children", children);
		respArr.add(resp);

		for(JSONObject attr : attrs) {
			if(attr.containsKey("bo_attrs")) {
				parseEntityAttr(attr, respArr);
			} else {
				children.add(dataTranslate(attr));
			}
		}
	}

   @GetMapping("boCheck")
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = businessObjectService.getByCode(code, InvocationInfoProxy.getTenantid());
        if(null != e) {
            vo = BeanMapper.map(e, BusinessObjectVO.class);
        }

        return CommonResponse.success(vo);
    }

	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			Long userId = getUserId(publishVO.getTarget());
			if(userId==null){
				return CommonResponse.error("发布数据失败:请联系管理员配置该环境的用户id!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BusinessObjectEntity> baseEntities = null;
			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<BusinessObjectEntity>) businessObjectService.listByIds(publishVO.getIdList());
			}else{
				return CommonResponse.error("未选中要发布的数据");
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BusinessObjectEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			String paramterStr = gson.toJson(params);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				//获取上下文
				Map<String,String> headers = new HashMap<>();
				String contextUrl = publishVO.getTarget() + DataTransferUtil.GETCONTEXT;
				Map<String, Object> contextParams = new HashMap<>();
				contextParams.put("userid", userId);
				String resultContext = HttpTookit.get(contextUrl, contextParams, headers);
				CommonResponse<Map<String,Object>> back = gson.fromJson(resultContext, CommonResponse.class);
				if(back.isSuccess()){
					Map<String, Object> context = back.getData();
					String authority = "userType="+context.get("userType") + 
					    	";userCode="+context.get("userCode") +
					    	";userName="+context.get("userName") +
					    	";orgId="+context.get("orgId") +
					    	";orgName="+context.get("orgName") +
					    	";tenantid="+context.get("tenantid") +
					    	";token="+context.get("token") +
					    	";u_logints="+context.get("u_logints") +
					    	";u_usercode="+context.get("u_usercode") +
					    	";userId="+context.get("userId");
					headers.put("authority", authority);
					String result = HttpTookit.postByJson(url, paramterStr,headers);
					logger.info("发布数据返回的结果：---------------"+result);
					return gson.fromJson(result, CommonResponse.class);
				}else{
					return CommonResponse.error("发布参照数据失败:获取对应环境上下文失败");
				}
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		String baseTableName = "ejc_print_business_object";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
		sqlList.add(deleteBaseSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<BusinessObjectEntity> baseEntityList) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		return retList;
	}

	private Long getUserId(String targetEnv){
		Long userId = null;
		switch (targetEnv){
			case "https://dev.17elian.com":
				userId = 303581417601122400l;
				break;
			case "https://portal.17elian.com":
				userId = 303581417601122400l;
				break;
			case "http://testqlh.baju.com.cn:8087":
				userId = 303581417601122400l;
				break;
			case "https://qlh.baju.com.cn":
				userId = 303581417601122400l;
				break;
			case "http://wei.cscec5b.com.cn:9082":
				userId = 303581417601122400l;
				break;
			case "http://wei.cscec5b.com.cn:9080":
				userId = 303581417601122400l;
				break;
			default: 
				break;
		}
		return userId;
	}
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BusinessObjectEntity> baseEntities = null;
			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<BusinessObjectEntity>) businessObjectService.listByIds(publishVO.getIdList());
			}else{
				throw new BusinessException("未选中要导出脚本的数据!");
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BusinessObjectEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
}
