package com.ejianc.foundation.print.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.mapper.TemplateMapper;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

@Service("templateService")
public class TemplateServiceImpl extends BaseServiceImpl<TemplateMapper, TemplateEntity> implements ITemplateService {

    @Override
    public TemplateEntity detail(Long id) {
        return baseMapper.selectById(id);
    }

    @Override
    public TemplateEntity detailByCode(String code, Long tenantId) {
        QueryWrapper<TemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("template_code", code);
        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        return baseMapper.selectOne(queryWrapper);
    }
}
