package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/23 10:06
 */
@RestController
@RequestMapping("/commonPrint/")
public class DataPrintController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMdApi mdApi;
	@Autowired
	private ICustomTableApi customTableApi;

	@Autowired
    private ITemplateService templateService;

	@Autowired
    private IBusinessObjectService businessObjectService;

	@Value("${oms.tenantid}")
    private Long OMS_TENANTID;

    /**
     * 通用打印数据获取
     *
     * @param id
     * @return
     */
    @GetMapping("printDetail")
    public CommonResponse<JSONObject> printDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "billType") String billType) {
    	CommonResponse<JSONObject> printData = new CommonResponse<JSONObject>();
    	if(billType.contains("CFS")){
    		JSONObject resp = new JSONObject();
    		CommonResponse<JSONObject> data = customTableApi.queryPrintDetail(billType, id);
    		if(data.isSuccess()){
    			resp.put(billType, data.getData());
    			return CommonResponse.success(resp);
    		}else{
    			return CommonResponse.error(data.getMsg());
    		}
    	}else{
            //根据单据类型找到单据类型对应的元数据Id
            CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(billType);
            if(!billTypeVo.isSuccess()) {
                logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", billType);
                return CommonResponse.error("查询打印数据详情失败，获取对应单据类型信息失败！");
            }
            printData = mdApi.queryCommonPrintData(billTypeVo.getData().getMetadataId(), id);

            return handleData(printData, billTypeVo.getData());
    	}
    }

    private CommonResponse<JSONObject> handleData(CommonResponse<JSONObject> printData, BillTypeVO billType) {
        //数据处理，处理业务对象编码不是实体类名的数据
        if(printData.isSuccess()) {
            QueryWrapper<TemplateEntity> templateQuery = new QueryWrapper<>();
            templateQuery.eq("bill_type_code", billType.getBillCode());
            List<TemplateEntity> tempLsit = templateService.list(templateQuery);
            TemplateEntity template = tempLsit.get(0);
            String boKey = template.getBoCode().substring(template.getBoCode().lastIndexOf(".")+1);

            JSONObject data = printData.getData();
            if(null == data.get(boKey)) {
                JSONObject newData = new JSONObject();
                CommonResponse<MdReferVO> mdRefer = mdApi.queryMetadataById(billType.getMetadataId());
                if(mdRefer.isSuccess()) {
                    String key = mdRefer.getData().getEntityName().replace("Entity", "");
                    for(String k : data.keySet()) {
                        if(key.equals(k)) {
                            newData.put(boKey, data.get(k));
                        } else {
                            newData.put(k, data.get(k));
                        }
                    }

                    printData.setData(newData);
                }
            }
        }
        return printData;
    }

    /**
     * 单据打印数据详情（供datav使用）
     *
     * @param boId
     * @param billId
     * @return
     */
    @GetMapping(value = "printDetailData")
    public CommonResponse<JSONObject> printDetailForData(@RequestParam(value = "boId") Long boId, @RequestParam(value = "billId") Long billId) {
        BusinessObjectEntity bo = businessObjectService.selectById(boId);
        QueryWrapper<TemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bo_code", bo.getCode());
        List<TemplateEntity> templateList = templateService.list(queryWrapper);
        if(CollectionUtils.isEmpty(templateList)) {
            return CommonResponse.error("查询打印数据详情失败，获取对应打印模板信息失败！");
        }
        TemplateEntity t = templateList.get(0);
        //根据单据类型找到单据类型对应的元数据Id
        CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(t.getBillTypeCode());
        if(!billTypeVo.isSuccess()) {
            logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", t.getBillTypeCode());
            return CommonResponse.error("查询打印数据详情失败，获取对应单据类型信息失败！");
        }
        CommonResponse<JSONObject> printData = mdApi.queryCommonPrintDetail(billTypeVo.getData().getMetadataId(), billId);

        return handleData(printData, billTypeVo.getData());
    }
}
