/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commonPrint/"})
public class DataPrintController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private ICustomTableApi customTableApi;
    @Autowired
    private ITemplateService templateService;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Value(value="${oms.tenantid}")
    private Long OMS_TENANTID;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @GetMapping(value={"printDetail"})
    public CommonResponse<JSONObject> printDetail(@RequestParam(value="id") Long id, @RequestParam(value="billType") String billType) {
        CommonResponse printData = new CommonResponse();
        if (billType.contains("CFS")) {
            JSONObject resp = new JSONObject();
            CommonResponse data = this.customTableApi.queryPrintDetail(billType, id);
            if (data.isSuccess()) {
                resp.put(billType, data.getData());
                return CommonResponse.success((Object)resp);
            }
            return CommonResponse.error((String)data.getMsg());
        }
        CommonResponse billTypeVo = this.billTypeApi.getByCode(billType);
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)billType);
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        printData = this.mdApi.queryCommonPrintData(((BillTypeVO)billTypeVo.getData()).getMetadataId(), id);
        return this.handleData((CommonResponse<JSONObject>)printData, (BillTypeVO)billTypeVo.getData());
    }

    private CommonResponse<JSONObject> handleData(CommonResponse<JSONObject> printData, BillTypeVO billType) {
        if (printData.isSuccess()) {
            QueryWrapper templateQuery = new QueryWrapper();
            templateQuery.eq((Object)"bill_type_code", (Object)billType.getBillCode());
            List tempLsit = this.templateService.list((Wrapper)templateQuery);
            TemplateEntity template = (TemplateEntity)((Object)tempLsit.get(0));
            String boKey = template.getBoCode().substring(template.getBoCode().lastIndexOf(".") + 1);
            JSONObject data = (JSONObject)printData.getData();
            if (null == data.get((Object)boKey)) {
                JSONObject newData = new JSONObject();
                CommonResponse mdRefer = this.mdApi.queryMetadataById(billType.getMetadataId());
                if (mdRefer.isSuccess()) {
                    String key = ((MdReferVO)mdRefer.getData()).getEntityName().replace("Entity", "");
                    for (String k : data.keySet()) {
                        if (key.equals(k)) {
                            newData.put(boKey, data.get((Object)k));
                            continue;
                        }
                        newData.put(k, data.get((Object)k));
                    }
                    printData.setData((Object)newData);
                }
            }
            if (StringUtils.isNotBlank((String)template.getDataHandleUrl())) {
                String reqUrl = (template.getDataHandleUrl().indexOf("http") < 0 ? this.BaseHost : "") + (template.getDataHandleUrl().startsWith("/") ? template.getDataHandleUrl().substring(0) : template.getDataHandleUrl());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("detailJson", JSONObject.toJSONString((Object)printData.getData()));
                params.put("billType", billType.getBillCode());
                try {
                    this.logger.info("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}", (Object)reqUrl, (Object)JSONObject.toJSONString(params));
                    String result = HttpTookit.postParameters(reqUrl, params);
                    this.logger.info("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}, \u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(params), result});
                    return (CommonResponse)BeanMapper.map((Object)result, CommonResponse.class);
                }
                catch (Exception e) {
                    this.logger.error("\u6a21\u677f\u914d\u7f6e\u6709\u6570\u636e\u5904\u7406\u670d\u52a1-{}\uff0c \u5f85\u5904\u7406\u6570\u636e-{}, \u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                    return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25, \u6253\u5370\u8be6\u60c5\u5904\u7406\u5931\u8d25\uff01");
                }
            }
        }
        return printData;
    }

    @GetMapping(value={"printDetailData"})
    public CommonResponse<JSONObject> printDetailForData(@RequestParam(value="boId") Long boId, @RequestParam(value="billId") Long billId) {
        BusinessObjectEntity bo = (BusinessObjectEntity)((Object)this.businessObjectService.selectById(boId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bo_code", (Object)bo.getCode());
        List templateList = this.templateService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u6253\u5370\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateEntity t = (TemplateEntity)((Object)templateList.get(0));
        CommonResponse billTypeVo = this.billTypeApi.getByCode(t.getBillTypeCode());
        if (!billTypeVo.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u3010code: {}\u3011\u4fe1\u606f\u5931\u8d25\uff01", (Object)t.getBillTypeCode());
            return CommonResponse.error((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u8be6\u60c5\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse printData = this.mdApi.queryCommonPrintDetail(((BillTypeVO)billTypeVo.getData()).getMetadataId(), billId);
        return this.handleData((CommonResponse<JSONObject>)printData, (BillTypeVO)billTypeVo.getData());
    }
}

