package com.ejianc.foundation.print.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_print_template")
public class TemplateEntity extends BaseEntity {

    private static final long serialVersionUID = -6680697857049690363L;

    /**
     * 单据类型主键Id
     */
    @TableField(value = "bill_type_id")
    private Long billTypeId;

    /**
     * 单据类型编号
     */
    @TableField(value = "bill_type_code")
    private String billTypeCode;

    /**
     * 模板编码
     */
    @TableField(value = "template_code")
    private String templateCode;
    /**
     * 模板名称
     */
    @TableField(value = "template_name")
    private String templateName;
    /**
     * 模板对应业务对象编码
     */
    @TableField(value = "bo_code")
    private String boCode;

    /**
     * 模板内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 模板类型：1-通用模板（运营平台用户创建），2-自定义表单模板（非运营平台租户创建）
     */
    @TableField(value = "template_type")
    private String templateType;

    /**
     * 模板字段间关系
     */
    @TableField(value = "field_relation_json")
    private String fieldRelationJson;

    /**
     * 数据查询Url
     */
    @TableField(value = "detail_url")
    private String detailUrl;

    /**
     * 打印数据处理服务地址
     */
    @TableField(value = "data_handle_url")
    private String dataHandleUrl;
    
    /**
     * 组织id
     */
    @TableField(value = "org_id")
    private Long orgId;
    public String getDataHandleUrl() {
        return dataHandleUrl;
    }

    public void setDataHandleUrl(String dataHandleUrl) {
        this.dataHandleUrl = dataHandleUrl;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getFieldRelationJson() {
        return fieldRelationJson;
    }

    public void setFieldRelationJson(String fieldRelationJson) {
        this.fieldRelationJson = fieldRelationJson;
    }

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    public Long getBillTypeId() {
        return billTypeId;
    }

    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public String getBoCode() {
        return boCode;
    }

    public void setBoCode(String boCode) {
        this.boCode = boCode;
    }

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
}
