package com.ejianc.foundation.print.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_print_business_object")
public class BusinessObjectEntity extends BaseEntity {

    private static final long serialVersionUID = -1674410791004721058L;

    /**
     * 业务对象编码
     */
    @TableField(value = "code")
    private String code;
    /**
     * 业务对象名称
     */
    @TableField(value = "name")
    private String name;
    /**
     *  业务对象内容
     */
    @TableField(value = "content")
    private String content;
    /**
     * 业务对象所属实体主键Id
     */
    @TableField(value = "entity_id")
    private Long entityId;
    /**
     * 业务对象所属工程主键Id
     */
    @TableField(value = "project_id")
    private Long projectId;
    
    /**
     * 二维码链接
     */
    @TableField(value = "qrcode")
    private String qrcode;

    /**
     * 是否显示打印次数
     */
    @TableField(value = "show_print_number")
    private Boolean showPrintNumber;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getEntityId() {
        return entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

	public String getQrcode() {
		return qrcode;
	}

	public void setQrcode(String qrcode) {
		this.qrcode = qrcode;
	}

    public Boolean getShowPrintNumber() {
        return showPrintNumber;
    }

    public void setShowPrintNumber(Boolean showPrintNumber) {
        this.showPrintNumber = showPrintNumber;
    }
}
