package com.ejianc.foundation.print.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.bean.TemplateEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.service.INumberService;
import com.ejianc.foundation.print.service.ITemplateService;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.print.vo.NumberVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author CJ
 * @Description:
 * @date 2020/7/23 10:06
 */
@RestController
@RequestMapping("/commonPrint/")
public class DataPrintController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMdApi mdApi;
	@Autowired
	private ICustomTableApi customTableApi;
	@Autowired
    private ITemplateService templateService;
	@Autowired
    private IBusinessObjectService businessObjectService;
	@Autowired
	private EnvironmentTools environmentTools;
    @Autowired
    private INumberService numberService;

	@Value("${oms.tenantid}")
    private Long OMS_TENANTID;


    /**
     * 通用打印数据获取
     *
     * @param id
     * @return
     */
    @GetMapping("printDetail")
    public CommonResponse<JSONObject> printDetail(@RequestParam(value = "id") Long id, @RequestParam(value = "billType") String billType,
                                                  @RequestParam(value = "allApprove", required = false) Boolean allApprove,
                                                  @RequestParam(value = "templateId", required = false) Long templateId,HttpServletRequest req) {
    	CommonResponse<JSONObject> printData = new CommonResponse<JSONObject>();
    	if(billType.contains("CFS")){
    		JSONObject resp = new JSONObject();
            CommonResponse<JSONObject> data = customTableApi.queryPrintDetail(billType, id);
            logger.info("查询CFS 打印数据结果：{}",JSONObject.toJSONString(data));
    		if(data.isSuccess()){
    			resp.put(billType, data.getData());
    			return CommonResponse.success(resp);
    		}else{
    			return CommonResponse.error(data.getMsg());
    		}
    	}else{
            //根据单据类型找到单据类型对应的元数据Id
            CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(billType);
            if(!billTypeVo.isSuccess()) {
                logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", billType);
                return CommonResponse.error("查询打印数据详情失败，获取对应单据类型信息失败！");
            }
            CommonResponse<JSONObject> data = new CommonResponse<>();
            if(allApprove!=null && allApprove){
                printData = mdApi.queryCommonPrintDataAllApprove(billTypeVo.getData().getMetadataId(), id);
            }else{
                printData = mdApi.queryCommonPrintData(billTypeVo.getData().getMetadataId(), id);
            }

            logger.info("根据单据类型-【{}】,单据Id-【{}】查询单据详情：{}", billType, id, JSONObject.toJSONString(printData));
            if(!printData.isSuccess()) {
                return CommonResponse.error("根据单据类型-【"+billType+"】,单据Id-【"+id+"】查询单据详情失败！");
            }

            return handleData(printData, billTypeVo.getData(), req.getHeader("authority"), templateId);
    	}
    }

    /**
     * 通用打印数据获取 批量
     *
     * @param id
     * @return
     */
    @PostMapping("printBatch")
    public CommonResponse<JSONArray> printBatch(@RequestBody Map<String ,String> params, HttpServletRequest req) {
        if(params == null){
            return CommonResponse.error("参数错误！");
        }
        String billIds = params.get("billIds");
        String detailUrl = params.get("detailUrl");
        if(StringUtils.isEmpty(billIds)){
            return CommonResponse.error("参数错误！billIds为空！");
        }
        String billType = params.get("billType");
        String templateId = params.get("templateId");
        String templateCode = params.get("templateCode");
        if(StringUtils.isEmpty(billIds)){
            return CommonResponse.error("参数错误！billType为空！");
        }
        Boolean allApprove = params.get("allApprove")==null?null:Boolean.parseBoolean(params.get("allApprove"));
        //根据单据类型找到单据类型对应的元数据Id
        CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(billType);
        if(!billTypeVo.isSuccess()) {
            logger.error("批量查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", billType);
            return CommonResponse.error("批量查询打印数据详情失败，获取对应单据类型信息失败！");
        }
        JSONArray array = new JSONArray();
        CommonResponse<JSONObject> printData;
        for (String s : billIds.split(",")) {
            Long id = Long.parseLong(s);
            CommonResponse<NumberVO> commonResponse = numberService.printNumer(Long.parseLong(templateId),templateCode,id);
            if(StringUtils.isEmpty(detailUrl)){
                if(allApprove!=null && allApprove){
                    printData = mdApi.queryCommonPrintDataAllApprove(billTypeVo.getData().getMetadataId(), id);
                }else{
                    printData = mdApi.queryCommonPrintData(billTypeVo.getData().getMetadataId(), id);
                }
                if(!printData.isSuccess()) {
                    logger.error("批量查询打印数据详情失败,根据单据类型-【"+billType+"】,单据Id-【"+id+"】查询单据详情失败！");
                }else {
                    printData = handleData(printData, billTypeVo.getData(), req.getHeader("authority"), Long.parseLong(templateId));
                    if(printData.isSuccess()) {
                        Set<String> keys = printData.getData().keySet();
                        for(String key :keys){
                            printData.getData().getJSONObject(key).put("printNumber","已打印"+commonResponse.getData().getNumber()+"次");
                        }
                        array.add(printData.getData());
                    }else {
                        logger.error("批量查询打印数据详情失败,根据单据类型-【"+billType+"】,单据Id-【"+id+"】 处理单据详情失败！");
                    }
                }
            }else {
                params.remove("billIds");
                /** 自定义查询数据接口 */
                String reqUrl = detailUrl.contains("http") ? detailUrl:(environmentTools.getBaseHost()
                        + (detailUrl.startsWith("/") ? detailUrl.substring(1) : detailUrl));
                Map<String, String> header = new HashMap<>();
                header.put("authority", req.getHeader("authority"));
                params.put("id",s);
                try {
                    String result = HttpTookit.get(reqUrl, params, header);
                    CommonResponse<JSONObject> resp = JSONObject.parseObject(result, CommonResponse.class);
                    if(resp.isSuccess()) {
                        Set<String> keys = resp.getData().keySet();
                        for(String key :keys){
                            resp.getData().getJSONObject(key).put("printNumber","已打印"+commonResponse.getData().getNumber()+"次");
                        }
                        array.add(resp.getData());
                    }else {
                        logger.error("批量查询打印数据详情失败,根据单据类型-【"+billType+"】,单据Id-【"+id+"】,自定义打印数据接口-【"+reqUrl+"】查询单据打印数据失败！{}",resp.getMsg());
                    }
                } catch (GeneralSecurityException | IOException e) {
                    logger.error("批量查询打印数据详情失败,根据单据类型-【"+billType+"】,单据Id-【"+id+"】,自定义打印数据接口-【"+reqUrl+"】查询单据打印数据失败！异常信息：{}",e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success(array);
    }

    private CommonResponse<JSONObject> handleData(CommonResponse<JSONObject> printData, BillTypeVO billType, String authority){
        return handleData(printData, billType, authority, null);
    }
    private CommonResponse<JSONObject> handleData(CommonResponse<JSONObject> printData, BillTypeVO billType, String authority, Long templateId) {
        //数据处理，处理业务对象编码不是实体类名的数据
        if(printData.isSuccess()) {
            QueryWrapper<TemplateEntity> templateQuery = new QueryWrapper<>();
            if(null != templateId) {
                templateQuery.eq("id", templateId);
            } else {
                templateQuery.eq("bill_type_code", billType.getBillCode());
            }

            List<TemplateEntity> tempLsit = templateService.list(templateQuery);
            logger.info("查询单据详情：{}",JSONObject.toJSONString(tempLsit));

            TemplateEntity template = tempLsit.get(0);
            logger.info("查询单据详情：" + JSONObject.toJSONString(template));
            String boKey = template.getBoCode().substring(template.getBoCode().lastIndexOf(".")+1);

            JSONObject data = printData.getData();
            if(null == data.get(boKey)) {
                JSONObject newData = new JSONObject();
                CommonResponse<MdReferVO> mdRefer = mdApi.queryMetadataById(billType.getMetadataId());
                logger.info("查询元数据信息：" + JSONObject.toJSONString(mdRefer));
                if(mdRefer.isSuccess()) {
                    String key = mdRefer.getData().getEntityName().replace("Entity", "");
                    for(String k : data.keySet()) {
                        if(key.equals(k)) {
                            newData.put(boKey, data.get(k));
                        } else {
                            newData.put(k, data.get(k));
                        }
                    }

                    printData.setData(newData);
                }
            }

            logger.info("模板数据处理URL：" + template.getDataHandleUrl());
            if(StringUtils.isNotBlank(template.getDataHandleUrl())) {
                Map<String, String> header = new HashMap<>();
                header.put("authority", authority);
                logger.info("BASEHOST ：" + environmentTools.getBaseHost());
                String reqUrl = (template.getDataHandleUrl().indexOf("http") < 0 ? environmentTools.getBaseHost() : "")
                        + (template.getDataHandleUrl().startsWith("/") ? template.getDataHandleUrl().substring(0) : template.getDataHandleUrl());
                Map<String, String> params = new HashMap<>();
                params.put("detailJson", JSONObject.toJSONString(printData.getData()));
                params.put("billType", billType.getBillCode());

                try {
                    logger.info("模板配置有数据处理服务-{}， 待处理数据-{}", reqUrl, JSONObject.toJSONString(params));
                    String result = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(params), header);
                    logger.info("模板配置有数据处理服务-{}， 待处理数据-{}, 结果-{}", reqUrl, JSONObject.toJSONString(params), result);
                    CommonResponse<JSONObject> resp = BeanMapper.map(result, CommonResponse.class);
                    if(resp.isSuccess()) {
                        resp.setData(JSONObject.parseObject(JSONObject.parseObject(result).getString("data")));
                    }
                    return resp;
                } catch (Exception e) {
                    logger.error("模板配置有数据处理服务-{}， 待处理数据-{}, 处理异常：", e);
                    return CommonResponse.error("查询打印数据详情失败, 打印详情处理失败！");
                }
            }
        }
        return printData;
    }

    /**
     * 单据打印数据详情（供datav使用）
     *
     * @param boId
     * @param billId
     * @return
     */
    @GetMapping(value = "printDetailData")
    public CommonResponse<JSONObject> printDetailForData(@RequestParam(value = "boId") Long boId, @RequestParam(value = "billId") Long billId, HttpServletRequest req) {
        BusinessObjectEntity bo = businessObjectService.selectById(boId);
        QueryWrapper<TemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bo_code", bo.getCode());
        List<TemplateEntity> templateList = templateService.list(queryWrapper);
        if(CollectionUtils.isEmpty(templateList)) {
            return CommonResponse.error("查询打印数据详情失败，获取对应打印模板信息失败！");
        }
        TemplateEntity t = templateList.get(0);
        //根据单据类型找到单据类型对应的元数据Id
        CommonResponse<BillTypeVO> billTypeVo = billTypeApi.getByCode(t.getBillTypeCode());
        if(!billTypeVo.isSuccess()) {
            logger.error("查询打印数据详情失败，获取对应单据类型【code: {}】信息失败！", t.getBillTypeCode());
            return CommonResponse.error("查询打印数据详情失败，获取对应单据类型信息失败！");
        }
        CommonResponse<JSONObject> printData = mdApi.queryCommonPrintDetail(billTypeVo.getData().getMetadataId(), billId);

        return handleData(printData, billTypeVo.getData(), req.getHeader("authority"));
    }
}
