package com.ejianc.foundation.print.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.metadata.vo.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.print.bean.BusinessObjectEntity;
import com.ejianc.foundation.print.service.IBusinessObjectService;
import com.ejianc.foundation.print.util.DataTransferUtil;
import com.ejianc.foundation.print.util.HttpTookit;
import com.ejianc.foundation.print.vo.BusinessObjectVO;
import com.ejianc.foundation.print.vo.PublishVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.google.gson.Gson;

@RestController
@RequestMapping("/bomanage/")
public class BusinessObjectController {
	private Gson gson = new Gson();
	// 日志
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${oms.tenantid}")
    private Long BASE_TENANT_ID;

    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IMdProjectApi mdProjectApi;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private EnvironmentTools environmentTools;


	private final String QUERY_CLAUSE_LIST_BY_CATEGORY_ID_URL = "ejc-contractbase-web/api/clauseSetting/getListByCategoryId";

    @PostMapping("save")
    public CommonResponse<BusinessObjectVO> save(@RequestBody BusinessObjectVO vo) {
        BusinessObjectEntity dbEntity = null;
        if(null != vo.getId()) {
            dbEntity = businessObjectService.queryDetail(vo.getId());
            dbEntity.setContent(vo.getContent());
            dbEntity.setName(vo.getName());
            dbEntity.setCode(vo.getCode());
			dbEntity.setQrcode(vo.getQrcode());
			dbEntity.setShowPrintNumber(vo.getShowPrintNumber());
        } else {
			dbEntity = businessObjectService.getByCode(vo.getCode());
            if(null != dbEntity) {
				return CommonResponse.error("编码重复，保存失败！");
            } else {
                dbEntity = BeanMapper.map(vo, BusinessObjectEntity.class);
            }
        }
        businessObjectService.saveOrUpdate(dbEntity, false);

        return CommonResponse.success("保存业务对象成功！", BeanMapper.map(dbEntity, BusinessObjectVO.class));
    }

    @PostMapping("page")
    public CommonResponse<JSONObject> page(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
//		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        resp.put("data", pageList(param));
        return CommonResponse.success(resp);
    }

	@GetMapping(value = "/pageRefer")
    public CommonResponse<IPage<BusinessObjectEntity>> pageRefer(@RequestParam(value = "pageNumber", required = false, defaultValue = "1") int pageNumber,
																 @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
																 @RequestParam(value = "relyCondition", required = false) String relyCondition,
																 @RequestParam(value = "condition", required = false) String condition,
																 @RequestParam(value = "searchText", required = false) String searchText) {
		QueryParam queryParam = new QueryParam();
//		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, BASE_TENANT_ID));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);
		queryParam.setPageSize(pageSize);
		queryParam.setPageIndex(pageNumber);
		queryParam.setSearchText(searchText);

        queryParam.getFuzzyFields().add("name");
        queryParam.getFuzzyFields().add("code");

		return CommonResponse.success(pageList(queryParam));
	}

	private IPage<BusinessObjectEntity> pageList(QueryParam queryParam) {
		return businessObjectService.queryPage(queryParam, false);
    }

    @PostMapping("delete")
    public CommonResponse<String> del(@RequestBody Long id) {
        businessObjectService.removeById(id, false);
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("detail")
    public CommonResponse<BusinessObjectVO> detail(@RequestParam Long id) {
        BusinessObjectEntity entity = businessObjectService.queryDetail(id);
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }

    private void fillAttrDetail(BusinessObjectVO vo) {
        CommonResponse<MdProjectVO> projectResp = mdProjectApi.queryDetail(vo.getProjectId());
        CommonResponse<MdClassVO> clsResp = mdClassApi.queryDetail(vo.getEntityId());
        vo.setProject(projectResp.getData());
        vo.setEntity(clsResp.getData());

        CommonResponse<CustomObjVO> commonResponse = mdClassApi.queryCustomObjInfoByEntityId(vo.getEntityId());
		logger.info("打印模板，查询扩展字段信息：---{}",JSONObject.toJSONString(commonResponse));
        if(commonResponse.getData()!=null && ListUtil.isNotEmpty(commonResponse.getData().getCustomFieldList())){
			List<CustomFieldVO> cfl = commonResponse.getData().getCustomFieldList();
        	String strContent = vo.getContent();
        	if(StringUtils.isNotEmpty(strContent)){
        		JSONObject content = JSONObject.parseObject(strContent);
        		JSONObject bo = content.getJSONObject("bo");
        		JSONArray bo_attrs = bo.getJSONArray("bo_attrs");
				for (CustomFieldVO fieldVO : cfl) {
					JSONObject attr = new JSONObject();
					attr.put("code",fieldVO.getAttributeName());
					attr.put("fieldname",fieldVO.getAttributeName());
					attr.put("typename",fieldVO.getAttributeName());
					attr.put("name",fieldVO.getDisplayName());
					attr.put("fieldtype","string");
					attr.put("key", IdWorker.getId());
					attr.put("type","attr");
					attr.put("dataFormat","");
					attr.put("sourceType","");
					attr.put("isPrimary",0);
					if(bo_attrs == null){
						bo_attrs = new JSONArray();
					}
					boolean has = false;
					for (Object bo_attr : bo_attrs) {
						JSONObject a = (JSONObject)bo_attr;
						if(a.getString("fieldname").equals(fieldVO.getAttributeName())){
							has = true;
						}
					}
					if(!has){
						bo_attrs.add(attr);
					}
				}
				bo.put("bo_attrs",bo_attrs);
				/** 处理子表 */
				JSONArray sub_bos = bo.getJSONArray("sub_bos");
				if(sub_bos!=null && sub_bos.size()>0){
					for (Object sub_bo : sub_bos) {
						JSONObject subBo = (JSONObject) sub_bo;
						if(!bo.getString("bo_code").equals("ApproveInfo")){
							bo_attrs = subBo.getJSONArray("bo_attrs");
							for (CustomFieldVO fieldVO : cfl) {
								JSONObject attr = new JSONObject();
								if(bo_attrs == null){
									bo_attrs = new JSONArray();
								}
								attr.put("code",fieldVO.getAttributeName());
								attr.put("fieldname",fieldVO.getAttributeName());
								attr.put("typename",fieldVO.getAttributeName());
								attr.put("name",fieldVO.getDisplayName());
								attr.put("fieldtype","string");
								attr.put("key", IdWorker.getId());
								attr.put("type","attr");
								attr.put("dataFormat","");
								attr.put("sourceType","");
								attr.put("isPrimary",0);
								boolean has = false;
								for (Object bo_attr : bo_attrs) {
									JSONObject a = (JSONObject)bo_attr;
									if(a.getString("fieldname").equals(fieldVO.getAttributeName())){
										has = true;
									}
								}
								if(!has){
									bo_attrs.add(attr);
								}
							}
							subBo.put("bo_attrs",bo_attrs);
						}
					}
				}
				bo.put("sub_bos",sub_bos);
				vo.setContent(content.toJSONString());
			}
		}
    }

	/**
	 * 根据单据类型编码查询业务对象 --- 合同模板使用
	 *
	 * @param billTypeCode 单据类型编码
	 * @param tenantId 租户Id
	 * @return
	 */
	@GetMapping("detailByBillType")
	public CommonResponse<BusinessObjectVO> detailByBillType(@RequestParam String billTypeCode,
															 @RequestParam(value = "tenantId", required = false) Long tenantId,
															 @RequestParam(value = "contractCategoryId", required = false) String contractCategoryId,
															 HttpServletRequest request) {
		CommonResponse<MdReferVO> mdReferVOResp = billTypeApi.queryMetadataByBillType(billTypeCode);
		if(!mdReferVOResp.isSuccess()) {
			logger.error("根据单据类型编码billTypeCode-{}获取对应元数据失败,原因:{}", billTypeCode, mdReferVOResp.getMsg());
			return CommonResponse.error("根据单据类型获取元数据失败！");
		}
		MdReferVO mdReferVO = mdReferVOResp.getData();
		BusinessObjectEntity entity = businessObjectService.getByEntityIdAndProjectId(mdReferVO.getMetadataId(), mdReferVO.getProjectId());
		if(null == entity) {
			return CommonResponse.error("业务对象不存在！");
		}
		BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
		fillAttrDetail(vo);

		//拼接合同条款
		if(StringUtils.isNotBlank(vo.getContent())) {
			fillContractClauseMetadata(vo, request.getHeader("authority"),
					billTypeCode, contractCategoryId, mdReferVO);
		}
		return CommonResponse.success(vo);
	}

	/**
	 * 查询合同条款并放入单据的元数据中
	 *  @param vo
	 * @param authority
	 * @param billTypeCode
	 * @param contractCategoryId
	 * @param mdReferVO
	 */
	private void fillContractClauseMetadata(BusinessObjectVO vo, String authority, String billTypeCode, String contractCategoryId, MdReferVO mdReferVO) {
		//查询合同条款
		try {
			String entityNameFmt = mdReferVO.getEntityName().replace("Entity", "");

			Map<String, String> header = new HashMap<>();
			header.put("authority", authority);
			Map<String, String> params = new HashMap<>();

			JSONObject clauseListJson = null;
			if(null != contractCategoryId) {
				//根据合同分类Id查询该分类下可用的合同条款列表
				params.put("categoryId", contractCategoryId);
				String respStr = HttpTookit.get(environmentTools.getBaseHost() + QUERY_CLAUSE_LIST_BY_CATEGORY_ID_URL, params, header);
				logger.error("查询可用合同条款结果：{} ", respStr);
				CommonResponse<List<JSONObject>> resp = JSONObject.parseObject(respStr, CommonResponse.class);
				if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
					//拼接合同条款元数据
					clauseListJson = new JSONObject();
					List<JSONObject> attrs = new ArrayList<>();
					clauseListJson.put("bo_code", "ContractClause");
					clauseListJson.put("bo_name", "合同条款");
					clauseListJson.put("bo_attrs", attrs);

					JSONObject tmp = null;
					for(JSONObject clause : resp.getData()) {
						tmp = new JSONObject();
						tmp.put("id", clause.getLong("id"));
						tmp.put("code", "::clauseNameId$clauseContent$" + clause.getLong("id"));
						tmp.put("fieldname", "::clauseNameId$clauseContent$" + clause.getLong("id"));
						tmp.put("clauseCode", clause.getString("code"));
						tmp.put("name", clause.getString("clauseName"));
						tmp.put("type", "attr");
						tmp.put("fieldtype", "text");

						attrs.add(tmp);
					}
				}

			} else {
				//根据单据类型调用对应应用服务查询合同下可用条款列表
				params.put("billType", billTypeCode);
				String respStr = HttpTookit.get(environmentTools.getBaseHost() + mdReferVO.getProjectName()+ "/" + entityNameFmt.substring(0,1).toLowerCase() + entityNameFmt.substring(1) + "Clause/getContractClauses", params, header);
				logger.error("查询可用合同条款结果：{} ", respStr);
				CommonResponse<JSONObject> resp = JSONObject.parseObject(respStr, CommonResponse.class);

				if(resp.isSuccess() && null != resp.getData()) {
					clauseListJson = resp.getData();
				}
			}

			if(null != clauseListJson) {
				JSONObject content = JSONObject.parseObject(vo.getContent());
				content.getJSONObject("bo").getJSONArray("sub_bos").add(clauseListJson);
				vo.setContent(JSONObject.toJSONString(content));
			}

		} catch (Exception e) {
			logger.error("查询可用合同条款异常, ", e);
		}
	}

	@GetMapping("detailByCode")
    public CommonResponse<BusinessObjectVO> detailByCode(@RequestParam String code, @RequestParam(value = "tenantId", required = false) Long tenantId) {
        BusinessObjectEntity entity = businessObjectService.getByCode(code);
//        if(null != tenantId && null == entity) {
//        	//查询租户下业务对象
//			entity = businessObjectService.getByCode(code, BASE_TENANT_ID);
//		}
        if(null == entity) {
            return CommonResponse.error("业务对象不存在！");
        }
        BusinessObjectVO vo = BeanMapper.map(entity, BusinessObjectVO.class);
        fillAttrDetail(vo);
        return CommonResponse.success(vo);
    }

    @GetMapping(value = "detailForDatav")
    public CommonResponse<JSONArray> detailForDatav(@RequestParam Long id) {
		JSONArray resp = new JSONArray();
		BusinessObjectEntity entity = businessObjectService.queryDetail(id);
		if(null == entity) {
			return CommonResponse.error("业务对象不存在！");
		}

		if(StringUtils.isNotBlank(entity.getContent())) {
			JSONObject content = JSONObject.parseObject(entity.getContent());
			JSONObject boJson = JSONObject.parseObject(content.getString("bo"));
			formatBoData(boJson, resp);
		}

		return CommonResponse.success(resp);
	}

    public void formatBoData(JSONObject boJson, JSONArray boArr) {
        JSONObject mainEntity = entityDataTranslate(boJson);
        boArr.add(mainEntity);

        List<JSONObject> attrs = JSONArray.parseArray(boJson.getString("bo_attrs"), JSONObject.class);
        List<JSONObject> children = new ArrayList<>();

        for(JSONObject attr : attrs) {
            if(attr.containsKey("bo_attrs")) {
                parseEntityAttr(attr, boArr);
            } else {
                children.add(attrDataTranslate(attr));
            }
        }
        mainEntity.put("children", children);

        if(boJson.containsKey("sub_bos") && StringUtils.isNotBlank(boJson.getString("sub_bos"))) {
            List<JSONObject> subBos = JSONArray.parseArray(boJson.getString("sub_bos"), JSONObject.class);
            for(JSONObject subBo : subBos) {
                formatBoData(subBo, boArr);
            }
        }
    }

    private JSONObject entityDataTranslate(JSONObject entityJson) {
        JSONObject resp = new JSONObject();
        String code = entityJson.getString("bo_code");
        code = code.indexOf(".") >= 0 ? code.substring(code.lastIndexOf(".")+1) : code;

        resp.put("id", entityJson.get("key"));
        resp.put("code", code);
        resp.put("title", entityJson.get("bo_name"));
        resp.put("type", 0);
        resp.put("isList", "1");
        resp.put("expand", true);
        resp.put("dataFormat", null);
        resp.put("fieldText", entityJson.get("bo_name"));
		resp.put("fieldtype", entityJson.get("fieldtype"));
		resp.put("sourceType", entityJson.get("sourceType"));
        return resp;
    }

	private JSONObject attrDataTranslate(JSONObject attr) {
    	JSONObject resp = new JSONObject();

		resp.put("id", attr.get("key"));
		resp.put("code", attr.get("fieldname"));
		resp.put("title", attr.get("name"));
		resp.put("type", 0);
		resp.put("isList", "1");
		resp.put("expand", true);
		resp.put("fieldtype", attr.get("fieldtype"));
		resp.put("sourceType", attr.get("sourceType"));
		resp.put("dataFormat", attr.getString("dataFormat"));
		resp.put("fieldText", attr.get("name"));

		return resp;
	}

	private void parseEntityAttr(JSONObject attrJson, JSONArray pChildren) {
		JSONObject resp = attrDataTranslate(attrJson);
		List<JSONObject> attrs = JSONArray.parseArray(attrJson.getString("bo_attrs"), JSONObject.class);
		List<JSONObject> children = new ArrayList<>();

		resp.put("children", children);
		pChildren.add(resp);

		for(JSONObject attr : attrs) {
			if(attr.containsKey("bo_attrs")) {
				parseEntityAttr(attr, pChildren);
			} else {
				children.add(attrDataTranslate(attr));
			}
		}
	}

   @GetMapping("boCheck")
    public CommonResponse<BusinessObjectVO> boCheck(@RequestParam String code) {
        BusinessObjectVO vo = null;
        BusinessObjectEntity e = businessObjectService.getByCode(code);
        if(null != e) {
            vo = BeanMapper.map(e, BusinessObjectVO.class);
        }

        return CommonResponse.success(vo);
    }

	/**
	 * 发布数据
	 * 
	 * @param bo
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "publish")
	public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
		try {
			String targetEnv = publishVO.getTarget();
			if (StringUtils.isBlank(targetEnv)) {
				return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
			}
			Long userId = getUserId(publishVO.getTarget());
			if(userId==null){
				return CommonResponse.error("发布数据失败:请联系管理员配置该环境的用户id!");
			}
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BusinessObjectEntity> baseEntities = null;
			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<BusinessObjectEntity>) businessObjectService.listByIds(publishVO.getIdList());
			}else{
				return CommonResponse.error("未选中要发布的数据");
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BusinessObjectEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			String url = publishVO.getTarget() + DataTransferUtil.DATA_TRANSFER_REST_URL2;
			Map<String, Object> params = new HashMap<>();
			params.put("sql", sqls);
			String paramterStr = gson.toJson(params);
			
			logger.info("发布数据的url：---------------"+url);
			try {
				//获取上下文
				Map<String,String> headers = new HashMap<>();
				String contextUrl = publishVO.getTarget() + DataTransferUtil.GETCONTEXT;
				Map<String, Object> contextParams = new HashMap<>();
				contextParams.put("userid", userId);
				String resultContext = HttpTookit.get(contextUrl, contextParams, headers);
				CommonResponse<Map<String,Object>> back = gson.fromJson(resultContext, CommonResponse.class);
				if(back.isSuccess()){
					Map<String, Object> context = back.getData();
					String authority = "userType="+context.get("userType") + 
					    	";userCode="+context.get("userCode") +
					    	";userName="+context.get("userName") +
					    	";orgId="+context.get("orgId") +
					    	";orgName="+context.get("orgName") +
					    	";tenantid="+context.get("tenantid") +
					    	";token="+context.get("token") +
					    	";u_logints="+context.get("u_logints") +
					    	";u_usercode="+context.get("u_usercode") +
					    	";userId="+context.get("userId");
					headers.put("authority", authority);
					String result = HttpTookit.postByJson(url, paramterStr,headers);
					logger.info("发布数据返回的结果：---------------"+result);
					return gson.fromJson(result, CommonResponse.class);
				}else{
					return CommonResponse.error("发布参照数据失败:获取对应环境上下文失败");
				}
			} catch (Exception e) {
				e.printStackTrace();
				return CommonResponse.error("发布参照数据失败");
			}
		} catch (Exception e) {
			return CommonResponse.error("发布参照数据失败:" + e.getMessage());
		}
	}

	private List<String> getDeleteSql(List<Long> ids) {
		if (ids == null || ids.isEmpty()) {
			return null;
		}
		List<String> sqlList = new ArrayList<String>();
		String idStr = "";
		for (Long id : ids) {
			idStr = idStr + "'" + id + "',";
		}
		idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
		String baseTableName = "ejc_print_business_object";
		String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr;
		sqlList.add(deleteBaseSql);
		return sqlList;
	}
	private List<String> getInsertSql(List<BusinessObjectEntity> baseEntityList) throws Exception {
		List<String> retList = new ArrayList<String>();
		List<String> baseInsertSql = DataTransferUtil.getInsertSql(baseEntityList);
		if (baseInsertSql != null && !baseInsertSql.isEmpty()) {
			retList.addAll(baseInsertSql);
		}
		return retList;
	}

	private Long getUserId(String targetEnv){
		Long userId = null;
		switch (targetEnv){
			case "https://dev.17elian.com":
				userId = 303581417601122400l;
				break;
			case "https://portal.17elian.com":
				userId = 303581417601122400l;
				break;
			case "http://testqlh.baju.com.cn:8087":
				userId = 303581417601122400l;
				break;
			case "https://qlh.baju.com.cn":
				userId = 303581417601122400l;
				break;
			case "http://wei.cscec5b.com.cn:9082":
				userId = 303581417601122400l;
				break;
			case "http://wei.cscec5b.com.cn:9080":
				userId = 303581417601122400l;
				break;
			case "http://testpm.ynsbj.com":
				userId = 303581417601122400l;
				break;
			default: 
				userId = 303581417601122400l;
				break;
		}
		return userId;
	}
	/**
	 * 抽取SQL脚本
	 * 
	 * @param req
	 *            HTTP头信息
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/exportSQL")
	public void exportSQL(HttpServletRequest req, HttpServletResponse response,
			@RequestBody PublishVO publishVO) {
		try {
			
			List<Long> ids = null;
			List<String> codes = null;
			List<BusinessObjectEntity> baseEntities = null;
			if(publishVO.getIdList()!=null&&publishVO.getIdList().size()>0){
				baseEntities = (List<BusinessObjectEntity>) businessObjectService.listByIds(publishVO.getIdList());
			}else{
				throw new BusinessException("未选中要导出脚本的数据!");
			}
			if (ids == null || ids.isEmpty() || codes == null || codes.isEmpty()) {
				ids = new ArrayList<Long>(baseEntities.size());
				codes = new ArrayList<String>(baseEntities.size());
				for (BusinessObjectEntity entity : baseEntities) {
					if (entity.getId()!=null) {
						ids.add(entity.getId());
					}
					if (StringUtils.isNotBlank(entity.getCode())) {
						codes.add(entity.getCode());
					}
				}
			}
			List<String> sqls = new ArrayList<String>();
			List<String> deleteSql = getDeleteSql(ids);
			List<String> insertSql = getInsertSql(baseEntities);
			if (deleteSql != null && !deleteSql.isEmpty()) {
				sqls.addAll(deleteSql);
			}
			if (insertSql != null && !insertSql.isEmpty()) {
				sqls.addAll(insertSql);
			}
			
			StringBuffer fileName = new StringBuffer();
			fileName.append("billType.sql");

			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition",
					"attachment; filename=" + URLEncoder.encode(fileName.toString(), "UTF-8"));
			OutputStream out = response.getOutputStream();
			// 将sql结果list转换为string并换行
			out.write(String.join("\r\n", sqls).getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}
	}
}
